//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSDTHREAD_H
#define WSDTHREAD_H

#include <WSCroot.h>

#define WS_THREAD_STOPPED 0
#define WS_THREAD_RUNNING 1

class WSDthread :public WSCroot{

  protected:
    void*      _ptr;
    void*      (*_proc)(WSDthread*,void*);
    void*      _callback_data;
    void      (*_callback_proc)(WSDthread*,void*);

    static WSDthread* (*_create_handler)();

  public:
    WSDthread();
    virtual ~WSDthread();

    void setFunction(void*(*func)(WSDthread*,void*));
    void* getFunction();

    void setCallbackFunction(void(*func)(WSDthread*,void*));
    void* getCallbackFunction();
    void* getCallbackData();

    virtual long    createThread(void* data);
    virtual long    detachThread();
    virtual long    joinThread(void**);
    virtual long    terminateThread();
    virtual long    getStatus();
    virtual long    execCallback(void*);

    static WSDthread* getNewInstance();
    static void      setCreateInstanceHandler(void* hd);
    static void*     getCreateInstanceHandler();

    WSMFclassDef(WSDthread,WSCroot);
};
typedef void* (*WSthreadProc)(WSDthread*,void*);
typedef void (*WSthreadCallbackProc)(WSDthread*,void*);

#endif
