/*-------------------------------------------------------------------------*/
/*  J3W ver 6.50  3D Animation Kit                                         */
/*  axis.h        10/16/2000                                               */
/*  Copyright (C) 1996 - 2000 Jun Mizutani <mizutani.jun@nifty.ne.jp>      */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_axis_h)
#define _axis_h

#include "misc3d.h"

class TAxis {
    int     change;
    Vector  origin;
    Matrix3      m;
    Quaternion   q;

    void SetAngle(long h, long p, long b);
    void GetAngle(long &h, long &p, long &b);
    void EulerAngle(long DH, long DP, long DB);

  public:
    TAxis();
    void reset_change() { change = 0; };
    void move(Vector v);

    void rotate(long h, long p, long b);

    void set_origin(long x, long y, long z);

    Vector get_origin();

    Matrix3 get_matrix();
    void    set_matrix(Matrix3 tm);
    Quaternion get_quat();
    Vector RelativePosition(Vector v);

    void attitude(long h, long p, long b);

    void get_attitude(long &h, long &p, long &b);

    void CalcRotationMatrix();

    int  CheckShortestPath(const Quaternion &q1, const Quaternion &q2);

    void attitudeq(Quaternion qq);

};

#endif
