/*-------------------------------------------------------------------------*/
/*  J3W ver 6.43  3D Animation Kit                                         */
/*  j3djob.h       4/24/2001                                               */
/*  Copyright (C) 1995 - 2001  Jun Mizutani <mizutani.jun@nifty.ne.jp>     */
/*                      All rights reserved.                               */
/*                                                                         */
/*   This file is part of the J3W 3D Animation Kit, and is covered under   */
/*  the terms of the GNU General Public License, version 2. This file has  */
/*  NO WARRANTY. See file COPYING for copyright details.                   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#if !defined(_j3djob_h)
#define _j3djob_h

#include  "jrlcode.h"
#include  "j3dproc.h"
#include  "spaceh3d.h"
#include  "hobj3d.h"
#include  "screen.h"
#include  "misc3d.h"
#include  "timing.h"

const int MAXCOMMON = 30000;
const int MAXLINES  = 100;
const int MAX_STRING = 2000;

typedef struct Line2D {
    Vector2D p0, p1;
    int color;
    int stat;
};
#ifdef WS
#ifdef WIN32
#ifdef GetObject
#undef GetObject
#endif //GetObject
#ifdef SendMessage
#undef SendMessage
#endif //SendMessage
#ifdef GetMessage
#undef GetMessage
#endif //GetMessage
#endif //WIN32
#endif //WS
class TJob {
    cCode     Code;
    int       hMidi;
    int       numProc;
    long      Count;
    int       maxProc;
    int       current_process;
    TProcess  **process;
    cTiming   aTimer;
    long      last_time;
    long      *CommonMem;
    TSpaceH3D *pSpace;
    TScreen   *pScreen;
    char      ScreenString[MAX_STRING+1];
    int       StrColor;
    int       StrStat;
    int       Cursor;
    Line2D    GrLines[MAXLINES];
    int       InKey;
    int       MouseX, MouseY;
    int       MouseShift;
    int       g_mode;
    int       MidiInUse;
    char      ObjectPath[128];
    void  common_func(long delta);
  public:
    TJob(int code_size, int max_proc, TSpaceH3D *p_space,
                       TScreen *sc);
    ~TJob();
    int  LoadObjFile(char* FileName);
    int  SaveObjFile(char* FileName);
    int count_process(){ return numProc;}
    int new_process(int maxData, int StartPos, int on, long *reg);

    void delete_process(int i);
    void SendMessage(int id, long msg);
    void SendMessageTo(int pno, long msg);
    THObj3D *GetObject(int id);
    long job_scheduler();
    void SetEye(THObj3D *eye);
    void SetGraph();
    void SetMode(int m);
    void ResetGraph();
    long GetCount(){return Count;}
    void StartTimer();
    long GetTime();
    int  GetCurProc(){ return  current_process;}

    void SetBackGroundColor(int bg);
    void SetZoom(int angle);
    long Distance(THObj3D* obj1, int id, long &pno, long &cnt);

    void RelativePosition(THObj3D* obj1, int id, long *reg);

    long Look(THObj3D* obj1, int id, long &head, long &pitch);

    long GetCommonMem(int i) { return CommonMem[i]; }

    void SetCommonMem(int i, long val) {
             if ((i<MAXCOMMON) && (i>=0))
                 CommonMem[i] = val;
    }
    long NearestVertex(long x, long y, long z,long id, long &nvertex);
    long WriteCommon(char *filename, long Pos, long Size);

    long ReadCommon(char *filename, long Pos);

    void SetCursorPosition(int pos);
    int  GetCursorPosition(){ return  Cursor;}
    void StringColor(int col);
    void WriteString(char *str);
    void ClearString();
    void GrLine(int n, Vector2D pa, Vector2D pb, int color);
    void GrLineClear(int n);
    void SetKey(int Key);
    int  GetKey();
    void SetMouse(int X, int Y, int Shift);
    void GetMouse(long &X, long &Y, long &Z);

#ifdef MIDI_SUPPORT
    void MidiOpen();
    void Midi(int MidiEvent, long MidiMes);
#endif
    char *Path() { return ObjectPath;}
    void Color(long no, long dr, long dg, long db, long ar, long ag, long ab);
    void ColorReset();
    void Light(int intensity, int x, int y, int z, int dx, int dy, int dz);
    void SetLightObject(THObj3D * pObj, int emit);

    void SetLightType(int parallel);
};

#endif
