#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
#include <WSCvdrawingArea.h>
#include <WSCvslider.h>
double scale;

void drawep(WSCbase* object){
  //drawing_a is same as newvdra_000...
  //You can get it extern WSCvdrawingArea* newvdra000; also.
  WSCvdrawingArea* drawing_a =(WSCvdrawingArea*)object->cast("WSCvdrawingArea");
  if (drawing_a == NULL){
    return;
  }

  WSCulong w = drawing_a->getProperty(WSNwidth);
  WSCulong h = drawing_a->getProperty(WSNheight);
  long scale1 = (long)drawing_a->getUserData("scale value");
  long pos = (long)drawing_a->getUserData("pos value");

  if (scale1 == 0){
    scale1 = 100;
  }
  scale = (double)scale1 / 100;
  drawing_a->setScaleOffsetPtr(&scale);
  long i=0;
  for(i=0; i< 256; i++){
    char cname[16];
    sprintf(cname,"#%02x%02x%02x",i/2 + 0x80 ,255-i ,i );    
    drawing_a->setForeColor(cname);
    drawing_a->drawLine(0,i/2,150+pos,h/2);
  }



}
static WSCfunctionRegister  op("drawep",(void*)drawep);
