//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <basic.h>
#include <WScom.h>
#include <WSCfontSet.h>
#include <btron/WSDbtronFont.h>
#include <btron/WSDbtronAppDev.h>
#include <WSClocaleSet.h>
#include <tstring.h>

#define DEFAULT_FONT_SET  "14 60c6 "

char* dfnames[] = { 
"0 14 60c6 ", //No. size code
"1 16 60c6 ",
"2 18 60c6 ",
"3 20 60c6 ",
"4 22 60c6 ",
"5 24 60c6 ",
"6 24 60c6 ",
"7 24 60c6 ",
"8 14 60c6 ",
NULL
};

WSMFclassInit(WSDbtronFont,WSDfont);
WSDfont* _btronFont_chandler(){
  WSDfont* font = new WSDbtronFont();
  return font;
};
long _btronFont_setup_handler(WSDfont* font,char* str){
  char str1[128];
  char fname[256];
  str1[0] = 0;
  fname[0] = 0;
  long no;
  long fno;
  sscanf(str,"%d %s %x",&no,str1,&fno);
  sprintf(fname,"%s %x",str1,fno);
  font->setFontName(fname);
  font->setId((short)no);
  return WS_NO_ERR;
};

long _btronFont_default_init_handler(WSCfontSet* fontset){
  long i=0;
  char** _dfnames = dfnames;
//  if (!strcmp(WSGIappLocaleSet()->getDefaultLocaleName(),WS_LOCALE_JAPANESE)){
//    _dfnames = dfnames_j;
//  } 
 
  while(_dfnames[i]){
    WSDfont* font = new WSDbtronFont();
    _btronFont_setup_handler(font,_dfnames[i]);
    fontset->addFont(font);
    i++;
  }
  return WS_NO_ERR;
};

void _btronFont_init(){
  WSGIappFontSet()->setCreateHandler(_btronFont_chandler);
  WSGIappFontSet()->setSetupHandler(_btronFont_setup_handler);
  WSGIappFontSet()->setDefaultInitializeHandler(_btronFont_default_init_handler);
  WSGIappFontSet()->initializeDefault();
};



WSDbtronFont::WSDbtronFont(){
}

WSDbtronFont::~WSDbtronFont(){
  destroy();
}

long WSDbtronFont::initialize(){
  char* fname = getSrc();
  _font_height = 14;
  sscanf(fname,"%d %x ",&_font_height,&_fno);
dbprintf("#####font fh=%d 0x%x\n",_font_height,_fno);
  _fnt.name[0] = 0;
//  _fnt.fclass = FTC_DEFAULT;
  _fnt.fclass =_fno;
  _fnt.attr = 0;
  _fnt.size.v = _font_height;
//  _fnt.size.v = 0;
  _fnt.size.h = _font_height;
//  _fnt.size.h = 0;
//  _fnt.size.h = _font_height/2;
  setValue1((long)&_fnt);

  _fnt2.name[0] = 0;
  _fnt2.fclass =_fno;
  _fnt2.attr = 0;
  _fnt2.size.v = _font_height;
  _fnt2.size.h = _font_height/2;
  setValue3((long)&_fnt2);



  W font_desc = fopn_fon();
  fset_fon(font_desc,&_fnt);
  setValue2((long)font_desc);
  return WS_NO_ERR;
}
long WSDbtronFont::destroy(){
  W fdesc = getValue2();
  if (fdesc > 0){
    fcls_fon(fdesc);
  }
  return WS_NO_ERR;
}
long WSDbtronFont::getStringWidthUCS2(WSCushort* str){
  char* cstr = WSGFgetString(str,WS_EN_UTF8);
  if (cstr == NULL){
    return 0;
  }
  WSCstring s;
  s.setString(cstr,WS_EN_UTF8);
  delete cstr;
  return getStringWidth(&s);
}
long WSDbtronFont::getStringHeightUCS2(WSCushort* str){
  getValue1();
  return  _font_height;
}
long WSDbtronFont::getStringWidth(WSCstring* str){
  char* tstr = str->getString(WS_EN_UTF8);
  long tclen = 0;
extern TC* WSGFbtronStringToTc(char*,long*);
  TC* tstr2 = WSGFbtronStringToTc(tstr,&tclen);

extern short WSGFbtronGetStringWidth(TC* str,WSDfont* fn,long slen);
 
  W width = WSGFbtronGetStringWidth(tstr2,this,tclen);
dbprintf("FF WSDbtronFont::getStringWidth() w=%d\n",width);
  return width;
}
long WSDbtronFont::getStringHeight(WSCstring*){
  getValue1();
  return  _font_height;
}
