//
// Copyright (C) 1999-2004 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <basic.h>
#include <WScom.h>
#include <WStcpcom.h>
#include <btron/WSDbtronThread.h>
#include <btron/WSDbtronAppDev.h>
#include <stdio.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDbtronThread,WSDthread);

WSDthread* _btron_th_chandler(){
  return new WSDbtronThread;
}

void WSGFinitializeUnixThread(){
    WSDthread::setCreateInstanceHandler((void*)_btron_th_chandler);
}

class _btron_th_init {
  public: _btron_th_init(){
    WSDthread::setCreateInstanceHandler((void*)_btron_th_chandler);
  };
};
_btron_th_init  _btron_th_init_execute;

WSDbtronThread::WSDbtronThread(){
  _mutex = cre_sem(1,SEM_EXCL | DELEXIT);
  _id = 0;
}

WSDbtronThread::~WSDbtronThread(){
  if (_id != 0){
    terminateThread();
  }
  if (_mutex != 0){
    del_sem(_mutex);
  }
}

long WSDbtronThread::createThread(void* data){
  wai_sem(_mutex,T_FOREVER);
  if (_proc == 0){
    sig_sem(_mutex);
    return WS_ERR;
  }
  if (_id != 0){
    sig_sem(_mutex);
    return WS_ERR;
  }
  _ptr = data;
  int ret = cre_tsk(_thread_start_handler,-1,(int)this);
  if (ret < 0){
dbprintf("Error. WSDbtronPrivateTimer can not create thread...\n");
WSMFtrace("Error. WSDbtronPrivateTimer can not create thread...\n");
    sig_sem(_mutex);
    return WS_ERR;
  }
  _id = ret;
  sig_sem(_mutex);
  return WS_NO_ERR;
}

void WSDbtronThread::_thread_start_handler(W ptr){
  WSDbtronThread* _this = (WSDbtronThread*)ptr;
  void* ret = NULL;
  if (_this->_proc != NULL){
    ret = _this->_proc(_this,_this->_ptr);
  }
  wai_sem(_this->_mutex,T_FOREVER);
  _this->_id = 0;
  sig_sem(_this->_mutex);
  ext_tsk();
  return;
}

long WSDbtronThread::detachThread(){
#if 0
  if (_id != 0){
    int ret = pthread_detach(_id);
    if (ret == 0){
      return WS_NO_ERR;
    }
  }
  return WS_ERR;
#endif
  return WS_NO_ERR;
}
long WSDbtronThread::terminateThread(){
  if (_id == 0){
    return WS_ERR;  
  }
  wai_sem(_mutex,T_FOREVER);
  ter_tsk(_id);
  _id = 0;
  sig_sem(_mutex);
  return WS_ERR;  
}
long WSDbtronThread::joinThread(void** retval){
  *retval = (void*)0;
  return WS_ERR;
}
long WSDbtronThread::getStatus(){
  if (_id == 0){
    return WS_THREAD_STOPPED;
  }
  return WS_THREAD_RUNNING;
}
long WSDbtronThread::execCallback(void* data){
  _callback_data = data;

  W tid = get_tid();
  MESSAGE* msg;
  char buffer[128];
  msg = (MESSAGE*)buffer;
  msg->msg_type = MS_TYPE4;
  msg->msg_size = sizeof(W)*2;
  memcpy(msg->msg_body.ANYMSG.msg_str,this,sizeof(W));
  memcpy(&(msg->msg_body.ANYMSG.msg_str[4]),&tid,sizeof(W));
  W ret = snd_msg(0,msg,WAIT);

  return WS_NO_ERR;
}

