//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCRLIST_H
#define WSCRLIST_H

#include <WScom.h>
#include <WSCRscrForm.h>
#include <WSCstring.h>
#include <WSDserialize.h>
#include <WSCconductor.h>

class WSCRlist :public WSCRscrForm{

 protected:
 public:
  WSDLEX32 WSCRlist();
  WSDLEX32 virtual ~WSCRlist();

  WSDLEX32 void onSort();
  WSDLEX32 void onItemSelected();

  WSDLEX32 void setLabelHeight(WSCushort h);
  WSDLEX32 void delAll();
  WSDLEX32 long getNum();
  WSDLEX32 WSCstring getItem(long pos);
  WSDLEX32 void addItem(char* item,long pos = -1); 
  WSDLEX32 void replaceItem(char* item,long pos);
  WSDLEX32 void replaceItem(char* item,long pos,long column);
  WSDLEX32 void delPos(long pos);
  WSDLEX32 long getSelectedPos();
  WSDLEX32 long setSelectPos(long);
  WSDLEX32 WSCstring getSelectedItem();
  WSDLEX32 void setTopPos(long);
  WSDLEX32 void setBottomPos(long);
  WSDLEX32 long getTopPos();
  WSDLEX32 long getBottomPos();
  WSDLEX32 void updateList();

  WSDLEX32 WSCbool   getSelectItemChanged();
  WSDLEX32 void      setSelectItemChanged(WSCbool);
  WSDLEX32 void      setEnableActivate(WSCbool);
  WSDLEX32 WSCbool   getEnableActivate();
  WSDLEX32 void      setAbsoluteChangeSelectFlag(WSCbool);
  WSDLEX32 WSCbool   getAbsoluteChangeSelectFlag();

  WSDLEX32 long      setItemVisible(long pos,WSCbool fl);

  WSDLEX32 long      setItemValue(long pos,long kind,long val);
  WSDLEX32 long      getItemValue(long pos,long kind,long* val);

  WSMFclassDef(WSCRlist,WSCRscrForm);
};
#endif
