//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#ifndef WSCBASELIST_H
#define WSCBASELIST_H

#include <WScom.h>
#include <WSCstring.h>
#include <WSClistData.h>
#include <WSCRroot.h>
#include <WSCRbase.h>

class WSCbase;
//class WSClistData;
class WSCremoteInstanceData{
  public:
    WSCstring _addr;
    WSCushort _port;
    WSCstring _public_instance_name;
    WSCstring _instance_name;
    WSCstring _class_name;

    WSDLEX32 WSCremoteInstanceData();
    WSDLEX32 ~WSCremoteInstanceData();

    WSDLEX32 void setPublicInstanceName(char*);
    WSDLEX32 void setInstanceName(char*);
    WSDLEX32 void setClassName(char*);
    WSDLEX32 void setAddr(char*);
    WSDLEX32 void setPort(WSCushort);

    WSDLEX32 WSCstring getPublicInstanceName();
    WSDLEX32 WSCstring getInstanceName();
    WSDLEX32 WSCstring getClassName();
    WSDLEX32 WSCstring getAddr();
    WSDLEX32 WSCushort getPort();

};

class WSCbaseList{

 private:
  void*         _search_handler;
  WSClistData*  _base_list;
  WSClistData*  _need_update;
  WSClistData*  _need_init;
  WSClistData   _event_list;
  WSClistData   _event_client_list;
  WSClistData   _remote_instance_list;
  WSClistData   _export_instance_list;
  WSClistData   _export_instance_update_list;
  WSClistData   _export_instance_delete_list;
  WSCbool       _remote_data_list_updated;

 public:
  WSDLEX32 WSCbaseList();
  WSDLEX32 virtual ~WSCbaseList();

  WSDLEX32 WSCbase* getInstance(char* class_name,char* objname);
  WSDLEX32 WSClistData* getClassList();

  WSDLEX32 void addClient(WSCbase*,void* bases = NULL);
  WSDLEX32 void delClient(WSCbase* ,void* bases = NULL);

  WSDLEX32 long countObject(char* );
  WSDLEX32 void addNeedUpdate(WSCbase*);
  WSDLEX32 void addNeedInitialize(WSCbase*);
  WSDLEX32 void execUpdate();
  WSDLEX32 void execInitialize();
  WSDLEX32 void  setUserData(char*,void *);
  WSDLEX32 void* getUserData(char*);

  WSDLEX32 WSClistData* getInstanceList(char*);
  WSDLEX32 WSCRbase*    getRemoteInstance(char*);

  WSDLEX32 void         setSearchInstanceHandler(void*);
  WSDLEX32 WSCbase*     searchInstance(char* class_name,char* objname);
  WSDLEX32 WSCbool      existInstance(WSCbase*);
  WSDLEX32 void     addEvent(WSCbase*,long ev = WSEV_NONE);
  WSDLEX32 void     delEvent(WSCbase*,long ev = WSEV_NONE);
  WSDLEX32 void     execEvent(long,void*);
  WSDLEX32 void     execEvent(long);
  WSDLEX32 void     execEvent(char*);

  WSDLEX32 long     addRemoteInstanceData(WSCremoteInstanceData* idata);
  WSDLEX32 long     delRemoteInstanceData(WSCremoteInstanceData* idata);
  WSDLEX32 WSCbool  getRemoteInstanceListUpdated();
  WSDLEX32 void     setRemoteInstanceListUpdated(WSCbool);


  WSDLEX32 long     addExportInstanceList(WSCbase* inst);
  WSDLEX32 long     delExportInstanceList(WSCbase* inst);
  WSDLEX32 long     addExportInstanceUpdateList(WSCbase* inst);
  WSDLEX32 long     delExportInstanceUpdateList(WSCbase* inst);

  WSDLEX32 long     addExportInstanceDeleteList(WSCbase* inst);
  WSDLEX32 long     delExportInstanceDeleteList(WSCbase* inst);


  WSDLEX32 WSClistData* getExportInstanceDeleteList();
  WSDLEX32 WSClistData* getExportInstanceUpdateList();
  WSDLEX32 WSClistData* getExportInstanceList();

  WSDLEX32 WSCremoteInstanceData*  getRemoteInstanceData(char* pname);
  WSDLEX32 WSClistData* getRemoteInstanceList();

};

extern WSDLEX WSCbaseList* WSGIappObjectList();
#endif
