//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCDIRTREE_H
#define WSCDIRTREE_H

#include <WScom.h>
#include <WSCtreeList.h>
#include <WSCindexData.h>
#define WSCdirTree_VER	1000

class WSCdirTree :public WSCtreeList{
  protected:
    WSCindexData _dir_inf;
    char* _dir_name;
    char* _file_name;
    char* _mask_name;
    unsigned     _select_dir:1;

    WSMFpropertyDef(WSNdirName,     char*, _dir_name);
    WSMFpropertyDef(WSNfileName,    char*, _file_name);
    WSMFpropertyDef(WSNmaskFileName,char*, _mask_name);
    WSMFpropertyDef(WSNselectDir,   WSCbool, _select_dir);

    WSDLEX32 virtual void _lb_adjust();
    WSDLEX32 virtual void _adjust();
    WSDLEX32 virtual long _adjust_dir(char* path,char* subdir,long level,long pos,long notopen,WSCbool all_update = True);


  public:
    WSDLEX32 WSCdirTree(WSCbase* base, char* name);
    WSDLEX32 virtual ~WSCdirTree();

    WSDLEX32 long setSelectedDirName(char*,WSCbool opened = False);
    WSDLEX32 char* getSelectedDirName();
    WSDLEX32 WSCstring getDirInf();
    WSDLEX32 void setDirInf(WSCstring);
    WSDLEX32 void reset();

    WSMFguiClassDef(WSCdirTree,WSCtreeList);
    WSMFversionDef  (WSCdirTree);
};
#endif
