//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCGRID_H
#define WSCGRID_H

#include <WScom.h>
#include <WSCform.h>
#include <WSCsform.h>

#define WSCgrid_VER 1010

class WSCgrid :public WSCform{

  protected:
     char*       _vline_pos;
     char*       _hline_pos;
     long*       _vline_list;
     long*       _hline_list;
     WSCvariant  **_values;
     char*       _data;
     char*       _data_source_name;
     short*      _fg_colors;
     short*      _bg_colors;
     WSCbool*    _if_status;
     WSCbase*    _ifield;

     WSCulong   _values_num;
     WSCulong   _vnum;
     WSCulong   _hnum;
     WSCulong   _vselect_pos;
     WSCulong   _hselect_pos;
     unsigned   _font:4;
     unsigned   _line_width:4;
     unsigned   _line_type:4;

     unsigned  _alignment_v:3;
     unsigned  _alignment_h:2;
     unsigned   _selected:1;
     unsigned   _need_update:1;
     unsigned   _enable_input:1;
     unsigned   _data_source_type:2;
     unsigned   _data_changed:1;
     unsigned   _need_ds_update:1;

     WSMFpropertyDef(WSNlineX, char*, _hline_pos );
     WSMFpropertyDef(WSNlineY, char*, _vline_pos );
     WSMFpropertyDef(WSNvcolumns, WSCulong, _vnum );
     WSMFpropertyDef(WSNhcolumns, WSCulong, _hnum );
     WSMFpropertyDef(WSNdata,  char*, _data  );
     WSMFpropertyDef(WSNdataSource,  WSCuchar, _data_source_type  );
     WSMFpropertyDef(WSNdataSourceName,  char*, _data_source_name  );
     WSMFpropertyDef(WSNenableInput,  WSCbool, _enable_input  );
     WSMFpropertyDef(WSNfont,  WSCuchar, _font  );
     WSMFpropertyDef(WSNalignmentH,   WSCuchar,   _alignment_h  );
     WSMFpropertyDef(WSNalignmentV,   WSCuchar,   _alignment_v  );
     WSMFpropertyDef(WSNlineWidth, WSCuchar, _line_width);
     WSMFpropertyDef(WSNlineType,  WSCuchar,  _line_type);

     WSDLEX32 virtual void _adjust();
     WSDLEX32 void _set_ds_instance();
     WSDLEX32 void _data_from_file(char* fname);
     WSDLEX32 void _adjust_line();
     WSDLEX32 void _adjust_value();
     WSDLEX32 void _value_update();
     WSDLEX32 void _create_input();

     WSDLEX32 void _mouse_press(WSCbase*);
     WSDLEX32 void _adjust_input(long x,long y,WSCbool fl);

     WSDLEX32 virtual long  _device_initialize();
     WSDLEX32 char    getAlignment();
WSDLEX32 static void _input_focus_lose(WSCbase*);
WSDLEX32 static void _input_fix_work(WSCbase*);

  public:
    WSDLEX32 WSCgrid(WSCbase*,char*);
    WSDLEX32 virtual ~WSCgrid();

    WSDLEX32 virtual long draw();
    WSDLEX32 virtual void update();

    WSDLEX32 virtual void onMousePress(WSCpoint*);
    WSDLEX32 virtual void onMouseRelease(WSCpoint*);
    WSDLEX32 virtual void onInputFixed(WSCvariant* val,long cx,long cy);
  

    WSDLEX32 long getCellGeometry(WSCulong cx,WSCulong cy,short* x,short* y,
                         WSCushort* w,WSCushort* h);

    WSDLEX32 long getCellNo(long px,long py,WSCulong* cx,WSCulong* cy);

    //for data source
    WSDLEX32 virtual void setData(WSCvariant*,long code = WS_EN_DEFAULT);
    WSDLEX32 virtual long getDataSourceType();
    WSDLEX32 virtual char* getDataSourcePropertyName();
    WSDLEX32 virtual char* getDefaultProperty();

    WSDLEX32 long getHColumns();
    WSDLEX32 long getVColumns();
    WSDLEX32 WSCvariant getItem(WSCulong hpos,WSCulong vpos);
    WSDLEX32 long setItem(WSCulong hpos,WSCulong vpos,WSCvariant);

    WSDLEX32 long getItemAlignment(WSCulong hpos,WSCulong vpos);

    WSDLEX32 long setCellForeColor(WSCulong x,WSCulong y,short color);
    WSDLEX32 long setCellBackColor(WSCulong x,WSCulong y,short color);
    WSDLEX32 long setCellForeColor(WSCulong x,WSCulong y,char* color);
    WSDLEX32 long setCellBackColor(WSCulong x,WSCulong y,char* color);

    WSDLEX32 long setCellInputStatus(WSCulong x,WSCulong y,WSCbool fl);
    WSDLEX32 long getCellInputStatus(WSCulong x,WSCulong y,WSCbool* fl);

    WSDLEX32 long getFocusedCell(WSCulong* hpos,WSCulong* vpos);
    WSDLEX32 long setFocusedCell(WSCulong hpos,WSCulong vpos);

    WSMFguiClassDef(WSCgrid,WSCform);
};
#endif
