//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCINPUTDIALOG_H
#define WSCINPUTDIALOG_H

#include <WScom.h>
#include <WSCbaseDialog.h>

class WSCvifield;
class WSCvlabel;

#define WSCinputDialog_VER 1001

class WSCinputDialog :public WSCbaseDialog{

  protected:
    WSCform*     _area1;
    WSCvifield*  _label;
    WSCvlabel*  _title;
    char* _label_string;
    short     _wbg_no;

    WSMFpropertyDef( WSNlabelString,   char*,   _label_string ); 
    WSMFpropertyDef( WSNworkBackColor,  short,      _wbg_no );
    WSDLEX32 static void _label_focus_work(WSCbase*);
    WSDLEX32 virtual void setWorkWSNforeColor(short);
    WSDLEX32 virtual void setWorkWSNtitleString(char*);

  public:
    WSDLEX32 WSCinputDialog(WSCbase*,char*);
    WSDLEX32 virtual ~WSCinputDialog();

    WSDLEX32 virtual  long initialize();
    WSDLEX32 virtual void adjustForm();

//    virtual void onResize(WSCrect* rect);
    WSDLEX32 virtual void onVisibleChange(WSCbool);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual char* getDefaultProperty();

    WSDLEX32 virtual  long popup();

    WSMFguiClassDef(WSCinputDialog,WSCbaseDialog);
    WSMFversionDef(WSCinputDialog);
};
#endif
