//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCLISTDATA_H
#define WSCLISTDATA_H

#include <WScom.h>

class WSClistData{

    void**  _data;
    unsigned _num:24;
    unsigned char _seg_size;
//    void _set_num(long);

  public:
    WSDLEX32 WSClistData();
    WSDLEX32 WSClistData(long);
    WSDLEX32 WSClistData(WSClistData&);
    WSDLEX32 WSClistData(const WSClistData&);
    WSDLEX32 virtual ~WSClistData();

    WSDLEX32 long   add(void* data,long i =-1);
//    long   add(WSClistData* list);
    WSDLEX32 void   setData(long i,void*);

    WSDLEX32 void*  getData(long i);
    WSDLEX32 long   getNum();
    WSDLEX32 void*  getTopData();
    WSDLEX32 void*  getBottomData();
    WSDLEX32 void** getBuf();

    WSDLEX32 long   del(void* data);
    WSDLEX32 long   delPos(long i);      
    WSDLEX32 void   clear();
    WSDLEX32 WSClistData& operator = (WSClistData&);
    WSDLEX32 void*  &operator[](long index);
//    const void*  &operator[](long index) const;
};
#endif
