//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCMENUAREA_H
#define WSCMENUAREA_H

#include <WScom.h>
#include <WSCform.h>

#define WSCmenuArea_VER  1001

class WSCmenuArea   :public WSCform{

  protected:
    WSCushort _w_bak;
    WSDLEX32 static void _resize_work(WSCbase*);
    WSDLEX32 virtual void setWorkWSNx(short data);
    WSDLEX32 virtual void setWorkWSNy(short data);
    WSDLEX32 virtual void setWorkWSNwidth(WSCushort data);

static void      (*_ext_draw_proc)(void*);
static WSCstring _policy_name;

  public:
    WSDLEX32 WSCmenuArea(WSCbase*,char*);
    WSDLEX32 virtual void onGuiPolicyChange(long);
    WSDLEX32 virtual ~WSCmenuArea();


    WSDLEX32 virtual long initialize();
    WSDLEX32 virtual long draw();

    WSMFguiClassDef(WSCmenuArea,WSCform);
    WSMFversionDef(WSCmenuArea);
};
struct WSCmenuArea_draw_struct{
  WSCmenuArea* _this;
  WSDdev* dev;
  short x;
  short y;
  WSCushort width;
  WSCushort height;
  WSCushort shadow_thickness;
  short fore_color;
  short back_color;
  short top_shadow_color;
  short bottom_shadow_color;
  short back_pixmap;
  long shadow_type;
  short gradation;
  short gradation_margin;
};

#endif
