//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCVARIANT_H
#define WSCVARIANT_H
#include <WScom.h>

class WSCvariant{

  protected:
    void* _data;
    char* _data2;
    char* _type_name;
    signed char _type;

  public:
    WSDLEX32 WSCvariant();
    WSDLEX32 WSCvariant(char);
    WSDLEX32 WSCvariant(WSCuchar);
    WSDLEX32 WSCvariant(short);
    WSDLEX32 WSCvariant(WSCushort);
    WSDLEX32 WSCvariant(int);
    WSDLEX32 WSCvariant(WSCuint);
    WSDLEX32 WSCvariant(long);
    WSDLEX32 WSCvariant(WSCulong);
    WSDLEX32 WSCvariant(float);
    WSDLEX32 WSCvariant(double);
    WSDLEX32 WSCvariant(void*);
    WSDLEX32 WSCvariant(void*,char* tname=NULL);
    WSDLEX32 WSCvariant(const WSCvariant&);
    WSDLEX32 WSCvariant(char*);
    WSDLEX32 WSCvariant(WSCbase*);
//    WSDLEX32 WSCvariant(WSCstring);

    WSDLEX32 virtual ~WSCvariant();

    WSDLEX32 char getChar();
    WSDLEX32 WSCuchar getUnsignedChar();
    WSDLEX32 short getShort();
    WSDLEX32 WSCushort getUnsignedShort();
    WSDLEX32 long getLong();
    WSDLEX32 WSCulong getUnsignedLong();
    WSDLEX32 int getInt();
    WSDLEX32 WSCuint getUnsignedInt();
    WSDLEX32 float getFloat();
    WSDLEX32 double getDouble();
    WSDLEX32 void* getVoidPtr();
    WSDLEX32 char* getCharPtr();
    WSDLEX32 WSCbase* getInstancePtr();

    WSDLEX32 void setValue(char);
    WSDLEX32 void setValue(WSCuchar);
    WSDLEX32 void setValue(short);
    WSDLEX32 void setValue(WSCushort);
    WSDLEX32 void setValue(long);
    WSDLEX32 void setValue(WSCulong);
    WSDLEX32 void setValue(int);
    WSDLEX32 void setValue(WSCuint);
    WSDLEX32 void setValue(char*);
    WSDLEX32 void setValue(void*,char* cname=NULL);
    WSDLEX32 void setValue(float);
    WSDLEX32 void setValue(double);
    WSDLEX32 void setValue(WSCbase*);

    WSDLEX32 long getType();
    WSDLEX32 char* getTypeName();
    WSDLEX32 void clear();

    WSDLEX32 WSCvariant& operator= (const WSCvariant&);
    WSDLEX32 WSCvariant& operator= (char);
    WSDLEX32 WSCvariant& operator= (WSCuchar);
    WSDLEX32 WSCvariant& operator= (short);
    WSDLEX32 WSCvariant& operator= (WSCushort);
    WSDLEX32 WSCvariant& operator= (long);
    WSDLEX32 WSCvariant& operator= (WSCulong);
    WSDLEX32 WSCvariant& operator= (int);
    WSDLEX32 WSCvariant& operator= (WSCuint);
    WSDLEX32 WSCvariant& operator= (void*);
    WSDLEX32 WSCvariant& operator= (char*);
    WSDLEX32 WSCvariant& operator= (float);
    WSDLEX32 WSCvariant& operator= (double);
    WSDLEX32 WSCvariant& operator= (WSCbase*);
//    WSDLEX32 WSCvariant& operator= (WSCstring);

    WSDLEX32 operator char();
    WSDLEX32 operator WSCuchar();
    WSDLEX32 operator short();
    WSDLEX32 operator WSCushort();
    WSDLEX32 operator long();
    WSDLEX32 operator WSCulong();
    WSDLEX32 operator int();
    WSDLEX32 operator WSCuint();
    WSDLEX32 operator void*();
    WSDLEX32 operator char*();
    WSDLEX32 operator float();
    WSDLEX32 operator double();
    WSDLEX32 operator WSCbase*();
//    WSDLEX32 operator WSCstring();
};
#endif
