//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCVDRAWINGAREA_H
#define WSCVDRAWINGAREA_H

#include <WScom.h>
#include <WSCnwbase.h>
#include <WSDimage.h>
#include <WSCvarc.h>
#define WSCvdrawingArea_VER  1000

#define WS_VDRAWINGAREA_MAXLEN_DEFAULT 64

class WSCvdrawingArea   :public WSCnwbase{

  protected:
    unsigned  _begin_draw_fl:1;
    unsigned  _use_pixmap:1;
    WSMFpropertyDef(WSNusePixmap,         WSCbool,  _use_pixmap);

    WSDLEX32 virtual long _device_initialize();

  public:

    WSDLEX32 WSCvdrawingArea(WSCbase* base, char* name);

    WSDLEX32 virtual ~WSCvdrawingArea();
    WSDLEX32 virtual long draw();
    WSDLEX32 virtual void update();
    WSDLEX32 virtual long execEventProc(long,void*);

    WSDLEX32 virtual long beginDraw();
    WSDLEX32 virtual long endDraw();

    WSDLEX32 long setForeColor(char* cname);
    WSDLEX32 long setBackColor(char* cname);
    WSDLEX32 long setLineWidth(short);
    WSDLEX32 long setLineDashType(char no);
    WSDLEX32 long setHatchPattern(char no);

    WSDLEX32 long setRegion(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 long drawArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2);
    WSDLEX32 long drawFillArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2,char kind);
    WSDLEX32 long drawLine(short x1,short y1,short x2,short y2);
    WSDLEX32 long drawLines(WSCpoint*,long num);
    WSDLEX32 long drawRect(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 long drawRects(WSCrect*,long num);
    WSDLEX32 long drawFillRects(WSCrect*,long num);
    WSDLEX32 long drawPoly(WSCpoint*,long num);
    WSDLEX32 long drawFillPoly(WSCpoint*,long num);
    WSDLEX32 long drawGradation(long type,short col1,short col2,short col3,
              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);
    WSDLEX32 long drawGradation(long type,char* col1,char* col2,char* col3,
              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);

    WSDLEX32 long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    WSDLEX32 long drawImage(short x,short y,WSCushort,WSCushort,char*,char align);
    WSDLEX32 long drawStretchedImage(short x,short y,WSCushort,WSCushort,WSDimage*);
    WSDLEX32 long drawStretchedImage(short x,short y,WSCushort,WSCushort,char*);

    WSDLEX32 long drawString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                            char*,long encoding = WS_EN_DEFAULT);

    WSDLEX32 long drawFillString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                        char*,long encoding = WS_EN_DEFAULT);

    WSMFguiClassDef(WSCvdrawingArea,WSCnwbase);
    WSMFversionDef(WSCvdrawingArea);
};

#endif //WSCVDRAWINGAREA_H
