//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCVKLABEL_H
#define WSCVKLABEL_H

#include <WScom.h>
#include <WSCvlabel.h>
#define WSCvklabel_VER  1000

class WSDkeyboard;

class WSCvklabel  :public WSCvlabel{

  protected:
    short _select_fore_color_work;
    short _select_color_work;

    WSMFpropertyDef(WSNselectColor, short,   _select_color_work);
    WSMFpropertyDef(WSNselectForeColor, short,   _select_fore_color_work);

    WSDLEX32 virtual long _device_initialize();

    WSDLEX32 static void _key_handler(void*,WSDkeyboard*,WSCbool);


  public:
    WSDLEX32 WSCvklabel(WSCbase*,char*);
    WSDLEX32 virtual ~WSCvklabel();
    WSDLEX32 virtual long draw();

    WSDLEX32 virtual void onKey(WSDkeyboard*,WSCbool);
    WSDLEX32 virtual void onMousePress(WSCpoint*);
    WSDLEX32 virtual void onMouseDoubleClick(WSCpoint*);
    WSDLEX32 virtual void onActivate();
    WSDLEX32 virtual void onFocusChange(WSCbool fl);

    WSMFguiClassDef(WSCvklabel,WSCvlabel);
    WSMFversionDef(WSCvklabel);
};
#endif
