//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSCVUDPSOCKET_H
#define WSCVUDPSOCKET_H

#include <WScom.h>
#include <WSCngbase.h>
#define WSCvudpsocket_VER  1000
#include <WSDsocket.h>

class WSCvudpsocket   :public WSCngbase{
  protected:
    WSDsocket*  _read_socket;
    WSDsocket*  _write_socket;
    char*     _addr;
    WSCushort _port; 
    WSCulong _timeout;
    WSCbool _on;
    WSCbool _reading;
    WSCstring _bind_addr;
    WSCstring _error_str;

    WSMFpropertyDef(WSNip,        char*,      _addr);
    WSMFpropertyDef(WSNport,      WSCushort,      _port);
    WSMFpropertyDef(WSNtimeout,   WSCulong,      _timeout);
    WSMFpropertyDef(WSNrunning,   WSCbool,      _on);

    WSDLEX32 void _init();

WSDLEX32 static void _udp_read_work(WSDsocket*,void*,WSCulong);

  public:

    WSDLEX32 WSCvudpsocket(WSCbase* base, char* name);
    WSDLEX32 virtual ~WSCvudpsocket();
    WSDLEX32 virtual void onActivate();
    WSDLEX32 long read(WSCuchar* buf,long size);
    WSDLEX32 long write(WSCuchar* buf,long size);

    WSDLEX32 WSCstring getDestAddr();
//    WSCushort getDestPort();

    WSDLEX32 void setBindAddr(char* addr);
    WSDLEX32 WSCstring getBindAddr();

    WSDLEX32 long start();
    WSDLEX32 long stop();
    WSDLEX32 void getErrorMsg(char* buffer,long size);
    WSDLEX32 WSCstring getErrorMessage();

    WSMFguiClassDef(WSCvudpsocket,WSCngbase);
    WSMFversionDef(WSCvudpsocket);
};

#endif //WSCVCSOCKET_H
