//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDDEV_H
#define WSDDEV_H

#include <WScom.h>
#include <WSDEV.h>
#include <WSCroot.h>
#include <WSClistData.h>
#include <WSDcolor.h>

class WSCbase;
class WSDdraw;
class WSDimage;
class WSCstring;

class WSDdev   :public WSCroot{

  public:
    long    _event_mask;
    short   _x;            
    short   _y;
    WSDLEX32 static  WSCushort _w;
    WSDLEX32 static  WSCushort _h;
  protected:
WSDLEX32 static    WSDdraw* _draw;
WSDLEX32 static    WSDdraw* _native_draw;
    WSCbase* _client;
    double*  _scale_ptr;
    short*   _x_offset_ptr;
    short*   _y_offset_ptr;
    void (*_addr_change_handler)(WSDdev*,void*);
    void*    _handler_data;
    WSDdev*  _parent_dev;
    WSDdev*  _event_parent_dev;
    unsigned _initialized:1;
    unsigned _visible:1;
    unsigned _any_where:1;
    unsigned _registered:1;
    unsigned _absolute_draw:1;
    unsigned _no_child:1;
    unsigned _deleted:1;

    WSDLEX32 void      setInitialized(WSCbool fl);
    WSDLEX32 WSCbool   getEventRegistered();
    WSDLEX32 void      setEventRegistered(WSCbool);

  public:
    WSDLEX32 WSDdev();
    WSDLEX32 virtual ~WSDdev();

    WSDLEX32 virtual long setEventOrder(WSDdev* dev,char top_or_bottom);
    WSDLEX32 virtual long setEvent(WSDdev* dev,WSCbool on_off);
    WSDLEX32 virtual long execEvent(long ev_kind,void* data);
    WSDLEX32 virtual long cancelEvent(WSDdev* dev);
    WSDLEX32 virtual long detachClient();
    WSDLEX32 virtual long initialize();

    WSDLEX32 void setScalePtr(double*);
    WSDLEX32 void setXOffsetPtr(short*);
    WSDLEX32 void setYOffsetPtr(short*);
    WSDLEX32 double getScale();
    WSDLEX32 short  getXOffset();
    WSDLEX32 short  getYOffset();
    WSDLEX32 void getWH(WSCushort*,WSCushort*);

    WSDLEX32 long     attachClient(WSCbase*);
    WSDLEX32 WSCbool  getAttached(); 
    WSDLEX32 WSCbase* getAttachedClient();
    WSDLEX32 WSCbool  getInitialized();
WSDLEX32 static    WSDdraw* getNativeDraw();
WSDLEX32 static    WSDdraw* getDraw();
WSDLEX32 static    long setNativeDraw(WSDdraw*);
WSDLEX32 static    long setDraw(WSDdraw*);
    WSDLEX32 long setForeColor(short cid);
    WSDLEX32 long setBackColor(short cid);
    WSDLEX32 long setForeColor(WSDcolor*);
    WSDLEX32 long setBackColor(WSDcolor*);
    WSDLEX32 long setLineWidth(short);
    WSDLEX32 long setLineDashType(char no);
    WSDLEX32 long setHatchPattern(char no);

    WSDLEX32 virtual long setValue(long kind,void* value); 
    WSDLEX32 virtual long getValue(long kind, void* value); 

    WSDLEX32 virtual void setExposedArea(short x,short y,WSCushort w,WSCushort h); 
    WSDLEX32 virtual long getExposedArea(short* x,short* y,WSCushort* w,WSCushort* h,WSCbool scaling = True); 
    WSDLEX32 virtual WSCbool isExposed(short x,short y,WSCushort w,WSCushort h,WSCbool scaling = True);

    WSDLEX32 virtual long setRegion(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 virtual long beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool absolute = False,WSCbool scaling = True);
    WSDLEX32 virtual long endDraw();

    WSDLEX32 long drawArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2);
    WSDLEX32 long drawFillArc(short x,short y,WSCushort width,WSCushort height,short _a1,short _a2,char kind);
    WSDLEX32 long drawLine(short x1,short y1,short x2,short y2);
    WSDLEX32 long drawLines(WSCpoint*,long num);
    WSDLEX32 long drawRect(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 long drawRects(WSCrect*,long num);
    WSDLEX32 long drawFillRects(WSCrect*,long num);
    WSDLEX32 long drawPoly(WSCpoint*,long num);
    WSDLEX32 long drawFillPoly(WSCpoint*,long num);
    WSDLEX32 long drawGradation(long type,short col1,short col2,short col3,
              short x,short y,WSCushort w,WSCushort h,WSCuchar grad_margin);

    WSDLEX32 long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    WSDLEX32 long drawImage(short x,short y,short sx,short sy,WSCushort,WSCushort,WSDimage*);
    WSDLEX32 long drawStretchedImage(short x,short y,WSCushort w,WSCushort h,WSDimage*);

    WSDLEX32 long drawString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                    char font,char align,long cur,WSCbool inter_cur,
                    long spos1=0,long spos2=0);

    WSDLEX32 long drawString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                            char*,long encoding = WS_EN_DEFAULT);

    WSDLEX32 long drawUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                     char font,char align,long cur,WSCbool inter_cur,
                     long spos1=0,long spos2=0);

    WSDLEX32 long drawFillString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                        char font,char align,long cur,WSCbool inter_cur);

    WSDLEX32 long drawFillString(long x,long y,WSCulong w,WSCulong h,char font,char align,
                        char*,long encoding = WS_EN_DEFAULT);

    WSDLEX32 long drawFillUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                         char font,char align,long cur,WSCbool inter_cur);

    WSDLEX32 virtual long exposeArea(long x,long y,WSCulong w,WSCulong h,WSCbool scaling = True);
    WSDLEX32 virtual long clearArea(long x,long y,WSCulong w,WSCulong h,WSCbool fl,WSCbool scaling = True);

    WSDLEX32 virtual long setVisible(WSCbool);
    WSDLEX32 virtual WSCbool isAvailableEvent(long ev_kind);
    WSDLEX32 virtual long setEnableEvent(long ev_kind);
    WSDLEX32 virtual long setEnableEventBit(long ev_bit);
    WSDLEX32 virtual long setDisableEvent(long ev_kind);
    WSDLEX32 virtual long setAbsoluteAddrChangeHandler(void(*)(WSDdev*,void*),void*);

    WSDLEX32 virtual long getAvailableEventBit();
    WSDLEX32 virtual void getAbsoluteAddr(short,short,short*,short*);
    WSDLEX32 virtual void getDispAddr(short*,short*);

    WSDLEX32 virtual WSDdev* getParentDev();
    WSDLEX32 virtual WSDdev* getEventParentDev();
    WSDLEX32 virtual WSDdev* getVisibleParentDev();

    WSDLEX32 virtual long getDeviceResource() =0;
    WSDLEX32 virtual long getWindowResource() =0;
    WSDLEX32 virtual long getContextResource() =0;
    WSDLEX32 virtual long getSpecialResource() =0;
    WSDLEX32 virtual WSCbool getReady();

    WSDLEX32 virtual long copyArea(long,long,WSCulong,WSCulong,long,long);

    WSDLEX32 void setEventMaskBit(long);
    WSDLEX32 long getEventMaskBit();
    WSDLEX32 void getGeom(short* ox,short* oy,WSCushort* ow,WSCushort* oh);
    WSDLEX32 long informEventToClient(long ev_kind,void*);
    WSDLEX32 WSCbool getVisible();
    WSDLEX32 WSCbool getNoChildDev();
    WSDLEX32 void deleteInstance();
    WSDLEX32 void setParentDev(WSDdev*);
    WSDLEX32 void setEventParentDev(WSDdev*);
    WSMFclassDef(WSDdev,WSCroot);

};
#endif
