//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDPSDRAW_H
#define WSDPSDRAW_H

#include <WScom.h>
#include <WSDdraw.h>
#include <WSClistData.h>
#include <WSDdev.h>
#include <WSDfile.h>
#include <WSDcolor.h>

class WSCbase;

class WSDpsdraw :public WSDdraw{

  protected:
    WSDfile* _file;
    WSCulong _fg_cno;
    WSCulong _bg_cno;
    WSDcolor* _fg_color;
    WSDcolor* _bg_color;
    short    _line_width;
    signed char     _line_type;
    WSCbool  _clipping;
    short _work_x;
    short _work_y;
    WSCushort _work_width;
    WSCushort _work_height;
    unsigned _type:2;
    unsigned _format:4;
    unsigned _orientation:1;

  public:
    WSDLEX32 WSDpsdraw();
    WSDLEX32 virtual ~WSDpsdraw();

    WSDLEX32 virtual long setForeColor(short cid);
    WSDLEX32 virtual long setBackColor(short cid);
    WSDLEX32 virtual long setForeColor(WSDcolor* color);
    WSDLEX32 virtual long setBackColor(WSDcolor* color);
    WSDLEX32 virtual long setLineWidth(short);
    WSDLEX32 virtual long setLineDashType(char no);
    WSDLEX32 virtual long setHatchPattern(char no);
    WSDLEX32 virtual long setRegion(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 virtual long beginDraw(WSDdev*,long prm1,long prm2,long prm3);
    WSDLEX32 virtual long endDraw();
    WSDLEX32 virtual long drawArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2);
    WSDLEX32 virtual long drawFillArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2,char kind);
    WSDLEX32 virtual long drawLine(short x1,short y1,short x2,short y2);
    WSDLEX32 virtual long drawLines(WSCpoint*,long num);
    WSDLEX32 virtual long drawRect(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 virtual long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    WSDLEX32 virtual long drawRects(WSCrect*,long num);
    WSDLEX32 virtual long drawGradation(long type,short col1,short col2,short col3,
                         short x,short y,WSCushort w,WSCushort h,WSCuchar);
    WSDLEX32 virtual long drawFillRects(WSCrect*,long num);
    WSDLEX32 virtual long drawPoly(WSCpoint*,long num);
    WSDLEX32 virtual long drawFillPoly(WSCpoint*,long num);
    WSDLEX32 virtual long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    WSDLEX32 virtual long drawImage(short x,short y,short sx,short sy,WSCushort,WSCushort,WSDimage*);
    WSDLEX32 virtual long drawStretchedImage(short x,short y,WSCushort w,WSCushort h,
                                    WSDimage*);

    WSDLEX32 virtual long drawString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                            char font,char align,long cur,WSCbool inter_cur,
                            long scur1 = 0,long scur2 = 0);

    WSDLEX32 virtual long drawUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                             char font,char align,long cur,WSCbool inter_cur,
                             long scur1 = 0,long scur2 = 0);

    WSDLEX32 virtual long drawFillString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                                char font,char align,short cur,WSCbool inter_cur);

    WSDLEX32 virtual long drawFillUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                                 char font,char align,short cur,WSCbool inter_cur);

    WSDLEX32 virtual long setValue(long kind,long val);
    WSDLEX32 virtual long outputHeader();
    WSDLEX32 virtual long outputFooter();

    WSMFclassDef(WSDpsdraw,WSDdraw);
};

#endif
