//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDSERIALIZE_H
#define WSDSERIALIZE_H

#include <WSdrDef.h>
#include <WSCroot.h>
#include <WSCstring.h>
#include <WSClistData.h>

class WSCserializeData;

class WSDserialize :public WSCroot{

protected:
  WSCstring _field;
  WSCstring _path;
  WSClistData _data_list;
  WSCserializeData* _current_data;
  unsigned _need_save:1;
  unsigned _transact:1;
  unsigned _use_socket:1;

  WSDLEX32 long _write_data(WSCserializeData* dt, char* type, void* data, long items);
  WSDLEX32 long _write_sub_class(WSCserializeData*,char* type,void* data, long items); 

  WSDLEX32 long _read_data(WSCserializeData* dt, char* type, void* data, long items);
  WSDLEX32 long _read_sub_class( WSCserializeData*,char* type,void* data, long items); 

  WSDLEX32 long _save(WSClistData*,  char* type, char* name, void* ptr);
  WSDLEX32 long _load(WSCserializeData*,WSClistData*,char* type,char* name,void* ptr);
  WSDLEX32 long _load_alloc(WSCserializeData*,WSClistData*,char* type,char* name,
          void** ptr, void* cdata);
  WSDLEX32 long _search_instance(WSClistData*,char* type,char mode,char*** otype,
          char*** onames,long* num);
public:
  WSDLEX32 virtual long _open(char* name,long mode)  = 0;
  WSDLEX32 virtual long _close() = 0;
  WSDLEX32 virtual long _read(void*,long len)  = 0;
  WSDLEX32 virtual long _write(void*,long len) = 0;
  WSDLEX32 virtual long _eof() = 0;
  WSDLEX32 virtual long _seek(long addr) = 0;
  WSDLEX32 virtual long _seek_set() = 0;
  WSDLEX32 virtual long _seek_end() = 0;
  WSDLEX32 virtual long _size() = 0;
  WSDLEX32 virtual long _tell() = 0;

  WSDLEX32 WSDserialize();
  WSDLEX32 virtual ~WSDserialize();
  WSDLEX32 long size(char* type, char* name);
  WSDLEX32 long search(char* type, long mode, char*** data,long* num);

  WSDLEX32 long save(char* type, char* name, void* data);
  WSDLEX32 long load(char* type, char* name, void* ptr);
  WSDLEX32 long loadAlloc(char* type, char* name, void** ptr,void* cdata);
  //must delete type,delete names (if num != 0 )
  WSDLEX32 long searchInstance(char* type,char mode,char*** otype,char*** onames,long* num);

  WSDLEX32 long saveData(char* type, char* name, void* data);
  WSDLEX32 long loadData(char* type, char* name, void* ptr);
  WSDLEX32 long loadAllocData(char* type, char* name, void** ptr,void* cdata);

  //must delete type,delete names (if num != 0 )
  WSDLEX32 long searchInstanceData(char* type,char mode,char*** otype,char*** onames,long* num);

  WSDLEX32 virtual WSCbool type(char* ) = 0;
  WSDLEX32 virtual WSDserialize* createSerialize() = 0;

  WSDLEX32 virtual long beginTransaction(char* field);
  WSDLEX32 virtual long endTransaction();
  WSDLEX32 WSCbool underTransaction();
  WSDLEX32 void    setUnderTransaction(WSCbool);
  WSDLEX32 char*   getPath();
  WSDLEX32 void    setPath(char*);

  WSMFclassDef(WSDserialize,WSCroot);
};
#endif
