//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDRDEF_H
#define WSDRDEF_H

#include <WScom.h>
class WSDserialize;
typedef void  (*WSdr_handler)(WSDserialize*,void*);
typedef void* (*WSdr_chandler)(void*);
typedef void  (*WSdr_dhandler)(void*);

#define WS_ERR_NOOBJ          10
#define WS_ERR_NOSRL          11
#define WS_ERR_NOTYPE         12
#define WS_ERR_NOBINTYPE      13
#define WS_ERR_CNSRL          14
#define WS_ERR_CNEXEC         15
#define WS_ERR_CNSRL_SOCK     16
#define WS_ERR_INVALID_DATA   17

#define WS_DcObject   0
#define WS_DcInt      1
#define WS_DcUInt     1
#define WS_DcShort    2
#define WS_DcUShort   2
#define WS_DcLong     3
#define WS_DcULong    3
#define WS_DcChar     4
#define WS_DcUChar    4
#define WS_DcString   5
#define WS_DcDouble   6
#define WS_DcFloat    7

// "#" means default type.
#define WS_DcRInt      "#int"
#define WS_DcRUInt     "#int"
#define WS_DcRShort    "#sht"
#define WS_DcRUShort   "#sht"
#define WS_DcRLong     "#lng"
#define WS_DcRULong    "#lng"
#define WS_DcRChar     "#chr"
#define WS_DcRUChar    "#chr"
#define WS_DcRString   "#str"
#define WS_DcRFloat    "#flt"
#define WS_DcRDouble   "#dbl"

//search modes
#define WS_SEARCH_STANDARD  0
#define WS_SEARCH_INHERIT   1

#define WS_DcByte1         1
#define WS_DcByte2         2
#define WS_DcByteString    3
#define WS_DcByte4         4
#define WS_DcByte8         8
#define WS_DcByte16       16
#define WS_DcByte32       32

#endif
