//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#if !defined(_jrlcode_h)
#define _jrlcode_h

#ifdef FREEBSD
#include <sys/types.h>
#endif

#ifdef AIX
#include <sys/machine.h>
#endif

#ifdef LINUX
#include <endian.h>
#endif

#ifdef SOLARIS
#include <sys/types.h>
#ifdef _BIG_ENDIAN
#define BIG_ENDIAN 4321
#define BYTE_ORDER BIG_ENDIAN
#else
#define LITTLE_ENDIAN 1234
#define BYTE_ORDER LITTLE_ENDIAN
#endif
#endif

class cCode {
    long * code;
    int codeSize;
    int endpos;
#if BYTE_ORDER == BIG_ENDIAN
    char s[128];
#endif

  public:
    cCode(int size) : codeSize(size), endpos(0) {
        code = new long [codeSize];
    };
    ~cCode() { delete [] code; };
    int  LoadObjFile(char* FileName);
    int  SaveObjFile(char* FileName);
    int  Size() { return codeSize; }
    int  Pos() { return endpos; }
    long fetch(const int p) { return code[p] ; }
    char* GetStr(int p) {
#if BYTE_ORDER == BIG_ENDIAN
        int i = -1;
        do {
            i++;
            s[i] = char(code[p + i/4] >> (8 * (i%4)));
        } while (s[i]!=0);
        return s;
#else
        return (char*)(&code[p]) ;
#endif
    }
    void set_code_at(const int p, const long n) { code[p] = n; }
    void set_code(const long n) { code[endpos++] = n; }
    void clear_code();
};

#endif

