//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.


#ifndef WSDWINFORMDEV_H
#define WSDWINFORMDEV_H

#include <WSDwindowDev.h>
#include <win/WSwincom.h>
#include <windows.h>

class WSDwinformDev               :public WSDwindowDev {
  private:
  protected:
    HDC       _dc;
    HDC       _mdc;
    HBITMAP   _pixmap;
    HWND      _wnd;
    HWND      _pwnd;
    COLORREF  _bg_cref;
    HBITMAP   _bg_image;
    HCURSOR   _mouse_val;
//    WSClistData _depend_children;
    short    _back_cno;
    short    _back_pixno;
    short  _abs_x;
    short  _abs_y;
    WSCbool _exposed;
    WSCbool _moved;
    WSCbool _resized;
    WSCbool _grabed;
    WSCushort _w_now;
    WSCushort _h_now;
    WSCushort _mouse_no;
    long      _click_time;
    HBITMAP   _pixmap_mdc;
    unsigned _resize_sequence:1;

WSDLEX32 virtual  void _evh_expose(WinEvent*);
WSDLEX32 virtual  void _evh_btn_press(WinEvent*,int);
WSDLEX32 virtual  void _evh_btn_release(WinEvent*,int);
WSDLEX32 virtual  void _evh_mouse_move(WinEvent*);
WSDLEX32 virtual  void _evh_mouse_in(WinEvent*);
WSDLEX32 virtual  void _evh_mouse_out(WinEvent*);
WSDLEX32 virtual  void _evh_resize(WinEvent*);
WSDLEX32 virtual  void _evh_move(WinEvent*);
WSDLEX32 virtual  void _evh_dummy(WinEvent*);
WSDLEX32 virtual  void _evh_delete(WinEvent*);
WSDLEX32 virtual  void _evh_delete2(void*);


WSDLEX32 virtual long createWindow();
WSDLEX32 virtual long createPixmap(); //call for Expose only...
//virtual long createContext();
WSDLEX32 virtual long destroyWindow();
WSDLEX32 virtual long destroyPixmap();
//virtual long destroyContext();

    WSDLEX32 long    setPixmap(HBITMAP);
    WSDLEX32 void    setHWND(HWND);

WSDLEX32 virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
WSDLEX32 virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
WSDLEX32 virtual void _clear_area(long x,long y,WSCulong w,WSCulong h);

   WSDLEX32 WSDwinformDev* getParentAreaDev();
   WSDLEX32 void _expose_children(int x,int y,WSCulong w, WSCulong h);
  public:
    WSDLEX32 WSDwinformDev();
    WSDLEX32 virtual ~WSDwinformDev();
    WSDLEX32 virtual long setVisible(WSCbool fl);
    WSDLEX32 virtual long setValue(long kind,void*);
    WSDLEX32 virtual long getDeviceResource();
    WSDLEX32 virtual long getWindowResource();
    WSDLEX32 virtual long getContextResource();
    WSDLEX32 virtual long getSpecialResource();
    WSDLEX32 virtual WSDdev* getEventParentDev();
    WSDLEX32 virtual long dispatchEvent(WinEvent*);
    WSDLEX32 virtual long beginDraw(short x,short y,WSCushort w,WSCushort h,WSCbool,WSCbool scaling = True);
    WSDLEX32 virtual long endDraw();
    WSDLEX32 HWND  getHWND();
    WSDLEX32 HWND  getWindow();
    WSDLEX32 HBITMAP  getPixmap();
    WSDLEX32 WSCushort  getMouseNo();
    WSDLEX32 short getAbsoluteX();
    WSDLEX32 short getAbsoluteY();
    WSDLEX32 void invalidate(WSCbool);
    WSDLEX32 void setExposed(WSCbool);
WSDLEX32 virtual  void _clear_and_expose();
//    Window  getWindow();
//    GC      getGC();
//    virtual void     setDependDev(WSDdev*);
//    void    addDependChild(WSDwinformDev*);
//    void    delDependChild(WSDwinformDev*);
//    void    destroyAllDependChildren();

    WSDLEX32 virtual long raise();
    WSDLEX32 virtual long lower();

    WSMFclassDef(WSDwinformDev,WSDwindowDev);
};
#endif
 
