//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDXFORMDEV_H
#define WSDXFORMDEV_H

#include <WSDwindowDev.h>
#include <X11/Intrinsic.h>

class WSDxformDev               :public WSDwindowDev {
  private:
  protected:
    GC       _gc;
    Pixmap   _pixmap;
    Widget   _widget;
    Widget   _pwidget;
    short    _bg;
    short    _bg_pix;
    WSCushort _mno;
    long     _click_time;

virtual long createWindow();
virtual long createPixmap(); //call for Expose only...
virtual long createContext();
virtual long destroyWindow();
virtual long destroyPixmap();
virtual long destroyContext();

static  void _evh_expose(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_resize(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_btn_press(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_btn_release(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_mouse_move(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_mouse_in(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_mouse_out(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_delete(Widget,XtPointer,XEvent*,WSCbool*);
static  void _evh_delete2(Widget,void*,void*);
static  void _evh_dummy(Widget,XtPointer,XEvent*,WSCbool*);

    long    setPixmap(Pixmap);
    void    setWidget(Widget);
    long    setGC(GC);

virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
virtual void _clear_area( long x,long y,WSCulong w,WSCulong h);

   WSDxformDev* getParentAreaDev();

  public:
    WSDxformDev();
    virtual ~WSDxformDev();
    virtual long setVisible(WSCbool fl);
    virtual long setValue(long kind,void*);
    virtual long getDeviceResource();
    virtual long getWindowResource();
    virtual long getContextResource();
    virtual long getSpecialResource();
    virtual WSDdev* getEventParentDev();

    Widget  getWidget();
    Pixmap  getPixmap();
    Window  getWindow();
    GC      getGC();
    WSCushort getMouseNo();

  virtual long raise();
  virtual long lower();
    void clearChildWidgets();
  virtual void _clear_widget();
    WSMFclassDef(WSDxformDev,WSDwindowDev);
};
#endif
 
