//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCngbase.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCngbase, WSCnwbase);
WSMFversion(WSCngbase, WSCnwbase);

WSCngbase::WSCngbase(WSCbase* base, char* objname):
			WSCnwbase(base, objname){

  _title_string.setString("Non GUI");
  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCngbase);
    WSMFpropertyVisibleOff(WSNblinkColor);
    WSMFpropertyVisibleOff(WSNblinkRate);
    WSMFpropertyVisibleOff(WSNtwinBlink);
    WSMFpropertyVisibleOff(WSNblinkFlag);
    WSMFpropertyVisibleOff(WSNblinkRefreshing);
    WSMFpropertyVisibleOff(WSNforeColor);
    WSMFpropertyVisibleOff(WSNvis);
    WSMFpropertyVisibleOff(WSNdet);
    WSMFpropertyVisibleOff(WSNanchorTop);
    WSMFpropertyVisibleOff(WSNanchorBottom);
    WSMFpropertyVisibleOff(WSNanchorLeft);
    WSMFpropertyVisibleOff(WSNanchorRight);
    WSMFpropertyVisibleOff(WSNanchorTopFlag);
    WSMFpropertyVisibleOff(WSNanchorBottomFlag);
    WSMFpropertyVisibleOff(WSNanchorLeftFlag);
    WSMFpropertyVisibleOff(WSNanchorRightFlag);
  WSMFpropertyCreateEnd

}

WSCngbase::~WSCngbase() {
}
void WSCngbase::update(){
  if (isNeedUpdate() == True){
    redraw();
    WSCbase::update();
  }
}

void WSCngbase::_set_title_string(char* str){
  _title_string.setString(str);
}

long WSCngbase::_device_initialize(){
  WSCnwbase::_device_initialize();
#if 0
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
#endif  
  return WS_NO_ERR;
}

long WSCngbase::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;

  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbase::update();
  setAbsoluteDraw(False);
  if (getPropertyEditMode() != False){
    long err = dev->beginDraw(x, y, w, h, absolute);
    if (err != WS_NO_ERR){
       return WS_NO_ERR;
    }
    dev->setForeColor(WSGIappColorSet()->getColorNo("gray55"));
    dev->setLineWidth(1);
    dev->drawRect(0,0,w,h);
    dev->drawString(0,0,w,h,&_title_string,WS_DEFAULT_FONT_NO,WS_CENTER,-1,False);
    dev->endDraw();
  }
  return WS_NO_ERR;
}
