//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCtypeServer.h>
#include <WSCconductor.h>

WSCtypeServer::WSCtypeServer(){
  _save_handler = NULL;
  _load_handler = NULL;
  _create_handler = NULL;
  _delete_handler = NULL;
  WSGIconductor()->add(this);
}

WSCtypeServer::~WSCtypeServer(){
}

long WSCtypeServer::getParentClassNum(){
  return _parent_name_list.getNum();
}

WSCtypeServer* WSCtypeServer::getParentClassServer(long n,char** cname){
  long num = _parent_name_list.getNum();
  if (n >= num){
    return NULL; //Error...
  }
  if ( _parent_type_server_list.getNum() == 0){
    long i;
    for(i=0; i< num; i++){
      _parent_type_server_list.add((void*)0);
    }
  }
  *cname = (char*)_parent_name_list.getData(n);
  WSCtypeServer* sv = (WSCtypeServer*)_parent_type_server_list.getData(n);
  if (sv == 0){
    sv = WSGIconductor()->searchTypeServer(*cname);
    _parent_type_server_list.setData(n,(void*)sv);
  }
  return sv;
}

WSCbool WSCtypeServer::isParentClass(char* pname){
  long num = getParentClassNum();
  if (num == 0){
    return False;
  }
  long i;
  for(i=0; i < num; i++){
    if (!strcmp(pname,(char*)_parent_name_list.getData(i))){
      return True;
    }
  }
  for(i=0; i < num; i++){
    char* pcname;
    WSCtypeServer* sv = getParentClassServer(i,&pcname);
    if (sv != NULL && sv->isParentClass(pname) != False){
      return True;
    }
  }
  return False;
}
void WSCtypeServer::setType(char* cname){
  _type_name.setString(cname,WS_EN_ISO8859_1);
}

WSCbool WSCtypeServer::isHit(char* cname){
  if (!strcmp(_type_name.getString(),cname)){
    return True;
  }else{
    return False;
  }
}

void WSCtypeServer::setCreateHandler(void* (*cvh)(void*)){
  _create_handler = cvh;
}

void WSCtypeServer::setDeleteHandler(void (*dvh)(void*)){
  _delete_handler = dvh;
}

void WSCtypeServer::setSaveHandler(void (*svh)(WSDserialize*,void*)){
  _save_handler = svh;
}

void WSCtypeServer::setLoadHandler(void (*lvh)(WSDserialize*,void*)){
  _load_handler = lvh;
}

void* WSCtypeServer::getSaveHandler(){
  return (void*)_save_handler;
}

void* WSCtypeServer::getLoadHandler(){
  return (void*)_load_handler;
}

void* WSCtypeServer::createInstance(void* cdata){
  if (_create_handler == NULL){
    return NULL;
  }
  return _create_handler(cdata);
}
void WSCtypeServer::deleteInstance(void* inst){
  if (_delete_handler == NULL){
    delete (char*)inst;
    return;
  }
  _delete_handler(inst);
}

char* WSCtypeServer::getParentClassName(long i){
  return (char*)_parent_name_list.getData(i);
}
