//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSDtimer.h>

WSMFclassInit(WSDtimer,WSCroot);

static WSDtimer* (*_chandler)() = NULL;
void WSDtimer::setCreateInstanceHandler( WSDtimer* (*hd)()){
  _chandler = hd;
}
static WSDtimer* _the_app_timer = NULL;
WSDtimer* WSGIappTimer(){
  if (_the_app_timer == NULL){
    if (_chandler == NULL){
      return NULL;
WSMFtrace("WSGIappTimer() ERROR. cannot create WSDtimer class instance.\n");
    }
    _the_app_timer = _chandler();
  }
  return _the_app_timer;
}

WSDtimer::WSDtimer(){
  _clock = 0;
}
WSDtimer::~WSDtimer(){
  long i;
  long num =  _cproc_list.getNum();
  for(i=0; i < num; i++){
    timerProcRec* proc = (timerProcRec*)_cproc_list.getData(i);
    delete proc;
  }
  num =  _proc_list.getNum();
  for(i=0; i < num; i++){
    triggerProcRec* proc = (triggerProcRec*)_proc_list.getData(i);
    delete proc;
  }
}
long WSDtimer::addTriggerProc(WStimerProc fn,WSCuchar rate,void* data){
  triggerProcRec* proc = new triggerProcRec;
  proc->proc = fn;
  proc->rate = rate;
  proc->data = data;
  proc->fclock = ((WSCuchar)(_clock-1)) % rate;
  proc->executed = False;

  _proc_list.add(proc);

  return (long)proc;
}
void WSDtimer::delTriggerProc(long id){
  long num = _proc_list.getNum();
  _proc_list.del((void*)id);
  long num2 = _proc_list.getNum();
  if (num != num2){
    triggerProcRec* proc = (triggerProcRec*)id;
    delete proc;
  }
}
long WSDtimer::addTimerProc(WStimerProc fn,WSCuchar rate,void* data){
  timerProcRec* proc = new timerProcRec;
  proc->proc = fn;
  proc->rate = rate;
  proc->data = data;
  proc->fclock = ((WSCuchar)(_clock-1)) % rate;
  _cproc_list.add(proc);
  return (long)proc;
}
void WSDtimer::delTimerProc(long id){
  long num = _cproc_list.getNum();
  _cproc_list.del((void*)id);
  long num2 = _cproc_list.getNum();
  if (num != num2){
    timerProcRec* proc = (timerProcRec*)id;
    delete proc;
  }
}

