//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCwizardDialog.h>
#include <WSCclassInformation.h>
#include <WSDdev.h>
#include <WSCdevice.h>
#include <WSCindexForm.h>
#include <WSCvlabel.h>
#include <WSCvbtn.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCwizardDialog,WSCbaseDialog);
WSMFversion(WSCwizardDialog,WSCbaseDialog);

#define D_BTN_WIDTH 80
//WSMFpropertyValueChange(WSCwizardDialog,WSNno,WSCbool,False);

WSCwizardDialog::WSCwizardDialog(WSCbase* base,char* objname):
                WSCbaseDialog(base,objname){
  _label_string = WSGFstrdup( WSGFgettext("c:WSSTR < Back,Next >,Finish") );
  _left << WSGFgettext("d:WSSTR < Back");
  _right << WSGFgettext("e:WSSTR Next >");
  _done << WSGFgettext("f:WSSTR Finish");
  _index_form = NULL;
  _area1 = NULL;
  _items = 2;
  _dev_is_public_dev = True;
  _value = 0;
  _wbg_no = WS_DF_DARKBACKCOLOR;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCwizardDialog);
    WSMFpropertyCreate(WSNlabelString,   char*, _label_string,WSSlabelString);
    WSMFpropertyCreate(WSNmenuItems,     WSCuchar, _items,WSSmenuItems);
    WSMFpropertyCreate(WSNvalue,     WSCuchar, _value,WSSvalue);
//    WSMFpropertyValueChangeDef(WSCwizardDialog,WSNno,WSCbool);
    WSMFpropertyVisibleOff(WSNokString);
    WSMFpropertyVisibleOff(WSNnoString);
    WSMFpropertyCreate(WSNworkBackColor,  short, _wbg_no,WSSworkBackColor );
    WSMFpropertyDelete(WSNshadowThickness);

  WSMFpropertyCreateEnd
}

WSCwizardDialog::~WSCwizardDialog(){
  if (_label_string != NULL){
    delete _label_string;
    _label_string = NULL;
  }
}

WSMFproperty( WSCwizardDialog, WSNlabelString, char*, _label_string,WSGFstrdup("") );
WSMFproperty( WSCwizardDialog, WSNmenuItems, WSCuchar, _items,2);
WSMFproperty( WSCwizardDialog, WSNvalue, WSCuchar, _value,0);
WSMFproperty( WSCwizardDialog, WSNworkBackColor,short, _wbg_no ,WS_DF_DARKBACKCOLOR);

void WSCwizardDialog::setWorkWSNlabelString(char* str){
  WSCstring str1(str);
  _left = str1.getWord(0,",");
  _right = str1.getWord(1,",");
  _done = str1.getWord(2,",");
  _btn_adjust();
}
void WSCwizardDialog::getWorkWSNlabelString(char** str){}

void WSCwizardDialog::_btn_adjust(){
  getLeftBtn()->setPropertyV(WSNlabelString,(char*)_left);
//printf("WSCwizardDialog::_btn_adjust value=%d\n",_value);
  if (_value == _items-1){
    getRightBtn()->setPropertyV(WSNlabelString,(char*)_done);
  }else{
    getRightBtn()->setPropertyV(WSNlabelString,(char*)_right);
  }
  if (_value == 0){
    getLeftBtn()->setSensitive(False);
  }else{
    getLeftBtn()->setSensitive(True);
  }
  getLeftBtn()->redraw();
  getRightBtn()->redraw();
  _index_form->setPropertyV(WSNvalue,(WSCuchar)_value);
  _index_form->redraw();
}

void WSCwizardDialog::setWorkWSNmenuItems(WSCuchar items){
  if (items == 0){
    _items = 1;
  }
  WSCstring str;
  long i;
  for(i=0; i<_items;i++){
    str << "a";
    if (i< _items-1){
      str << ",";
    }
  }
  _index_form->setPropertyV(WSNmenuItems,(char*)str);
}
void WSCwizardDialog::getWorkWSNmenuItems(WSCuchar*){};

void WSCwizardDialog::setWorkWSNvalue(WSCuchar data){
  if (data > _items -1){
    _value = _items -1;
  }
  _btn_adjust();
}
void WSCwizardDialog::getWorkWSNvalue(WSCuchar*){}
void WSCwizardDialog::setWorkWSNworkBackColor(short no){
  if (_area1 != NULL){
    _area1->setProperty(WSNbackColor,no);
  }
  if (_index_form != NULL){
    _index_form->setProperty(WSNbackColor,no);
  }
}
void WSCwizardDialog::getWorkWSNworkBackColor(short* ){}

long WSCwizardDialog::initialize(){
  WSCbaseDialog::initialize();
  _area1 = new WSCform(this,"md-label");
  _area1->setInternalObject(True);
  _area1->setUseParentBaseDev(True);
  _area1->initialize();
  _area1->setInternalObject(True);
  _area1->setPropertyV(WSNx,     (short)0 );
  _area1->setPropertyV(WSNy,     (short)5 );
  _area1->setProperty(WSNbackColor,_wbg_no);
  _area1->setVisible(True);

  _index_form = new WSCindexForm(_area1,"wd-idx");
  _index_form->setInternalObject(True);
  _index_form->initialize();
  _index_form->setPropertyV(WSNx,     (short)1);
  _index_form->setPropertyV(WSNy,     (short)1);
  _index_form->setProperty(WSNbackColor,_wbg_no);
  _index_form->setPropertyV(WSNbarThickness,(WSCushort)0);
  _index_form->setPropertyV(WSNshadowThickness,(WSCuchar)0);
  _index_form->setVisible(True);
  _dev_public = _index_form;
  setPropertyV(WSNokString,WSGFgettext("d:WSSTR < Back"));
  setPropertyV(WSNnoString,WSGFgettext("e:WSSTR Next >"));
  onGuiPolicyChange(WSGIappDev()->getGuiPolicy());
  return WS_NO_ERR;
}

void WSCwizardDialog::adjustForm(){
  WSCbaseDialog::adjustForm();
  if(_area1 != NULL){
    long diff = 0;
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_ORIGINAL){
      diff = 0;
    }else
    if (WSGIappDev()->getGuiPolicy() & WS_POLICY_WINDOWS){
      diff = 5;
    }
    if (_w > 1){
      _area1->setPropertyV(WSNwidth, (WSCushort)(_w));
    }else{
      _area1->setPropertyV(WSNwidth, (WSCushort)(1));
    }
    if (_h +diff > 45){
      _area1->setPropertyV(WSNheight,(WSCushort)(_h +diff - 45));
    }else{
      _area1->setPropertyV(WSNheight,(WSCushort)(1));
    }
    if (_w > 4){
      _index_form->setPropertyV(WSNwidth,(WSCushort)(_w - 4));
    }else{
      _index_form->setPropertyV(WSNwidth,(WSCushort)(1));
    }
    if (_h +diff > 47){
      _index_form->setPropertyV(WSNheight,(WSCushort)(_h +diff - 47));
    }else{
      _index_form->setPropertyV(WSNheight,(WSCushort)(1));
    }

  }  
}
void WSCwizardDialog::onActivate(){
  long vis = 1;
  if (getStatus() == WS_DIALOG_OK){
    if (_value >0){
      _value--;
    }
    _btn_adjust();
  }else
  if (getStatus() == WS_DIALOG_NO){
    _value++;
    if (_value > _items-1){
      _value = _items-1;
      vis = 0;
    }
    _btn_adjust();
  }
  WSCbaseDialog::onActivate();
  if (vis == 0){
    _status = WS_DIALOG_DONE;
    setVisible(False);
  }
}

WSCbase* WSCwizardDialog::getRightBtn(){
  return _no_btn;
}
WSCbase* WSCwizardDialog::getLeftBtn(){
  return _ok_btn;
}

void WSCwizardDialog::onGuiPolicyChange(long policy){
  if (_area1 != NULL){
    WSCbaseDialog::onGuiPolicyChange(policy);
    if (policy & WS_POLICY_ORIGINAL){
      _area1->setProperty(WSNy,5);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)1);
    }else{
      _area1->setProperty(WSNy,0);
      _area1->setPropertyV(WSNshadowThickness,(WSCuchar)0);
    }
    adjustForm();
  }
}
long WSCwizardDialog::popup(){
  setVisible(True);

  if (getVisible() == False){
    return WS_ERR;
  }
  _popuped = 1;
  if (_ok != False){
    if (_value == 0){
      _ok_btn->setSensitive(False);
    }
  }
  if (_no != False){
    _no_btn->setFocus();
  }else{
    _end_btn->setFocus();
  }
  WSGIappDev()->setFocusDialog(this,True);
  while(1){
    if (_popuped == 0){
      break;
    }
    WSGIappDev()->setFocusDialog(this,True);
    WSGIappDev()->dispatchEvent();
  }
  setVisible(False);
  return _status;
}

