//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCvbarGraph.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>
#include <WSCbaseList.h>

WSMFguiClassInitialize(WSCvbarGraph, WSCnwbase);
WSMFversion(WSCvbarGraph, WSCnwbase);

WSCvbarGraph::WSCvbarGraph(WSCbase* base, char* objname):
			WSCnwbase(base, objname){
  _values = WSGFstrdup("0,20,40,60,80,100");
  _barw = 10;
  _orientation  = WS_VERTICAL;
  _rev = False;
  _num = 10;
  _lw = 2;
  _lt = 0;
  _stippled = False;
  _hatch_pattern = 0;
  _hatch_color = WS_DF_NWBACKCOLOR;
  _data_source_name = WSGFstrdup("");
  _data_source_type = WS_DATA_SOURCE_NONE;
  _need_ds_update = False;
  _bg_blink_color = WS_DF_NWBACKCOLOR;
 
  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvbarGraph);

    WSMFpropertyCreate(WSNvalue,  char*,   _values,WSSvalue);
    WSMFpropertyCreate(WSNcolumns, WSCushort, _num,WSScolumns);
    WSMFpropertyCreate(WSNbarThickness,  WSCuchar, _barw,WSSbarThickness);
    WSMFpropertyCreate(WSNorientation,  WSCuchar, _orientation,WSSorientation);
      WSMFpropertySetSelection(WSRorientation, WSRorientationD);
    WSMFpropertyCreate(WSNreverseFlag,  WSCbool, _rev,WSSreverseFlag);
      WSMFpropertySetSelection(WSRbool, WSRboolD);
    WSMFpropertyCreate(WSNlineWidth, WSCuchar, _lw,WSSlineWidth);
    WSMFpropertyCreate(WSNlineType,  WSCuchar, _lt,WSSlineType);
      WSMFpropertySetSelection(WSRlineType, WSRlineTypeD);
    WSMFpropertyCreate(WSNstippled,WSCbool,_stippled,WSSstippled );
      WSMFpropertySetSelection(WSRbool4, WSRbool4D);
    WSMFpropertyCreate(WSNhatchPattern,WSCuchar,_hatch_pattern,WSShatchPattern);
      WSMFpropertySetSelection(WSRhatchPattern, WSRhatchPatternD);
    WSMFpropertyCreate(WSNhatchColor,short,_hatch_color,WSShatchColor);
    WSMFpropertyCreate(WSNdataSource, WSCuchar, _data_source_type,WSSdataSource );
      WSMFpropertySetSelection(WSRdataSource,WSRdataSourceD);
    WSMFpropertyCreate(WSNdataSourceName, char*, _data_source_name,WSSdataSourceName );
    WSMFpropertyCreate(WSNbackBlinkColor, short,   _bg_blink_color,WSSbackBlinkColor);

  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvbarGraph, WSNvalue, char*, _values ,WSGFstrdup("0,20,40,60,80,100"));
WSMFproperty( WSCvbarGraph, WSNcolumns, WSCushort, _num ,10);
WSMFproperty( WSCvbarGraph, WSNbarThickness, WSCuchar, _barw ,10);
WSMFproperty( WSCvbarGraph, WSNorientation, WSCuchar, _orientation ,WS_VERTICAL);
WSMFproperty( WSCvbarGraph, WSNreverseFlag, WSCbool, _rev ,False);
WSMFproperty( WSCvbarGraph, WSNlineWidth, WSCuchar, _lw, 2);
WSMFproperty( WSCvbarGraph, WSNlineType,  WSCuchar,      _lt, 0);
WSMFproperty( WSCvbarGraph, WSNstippled,  WSCbool,_stippled,     False);
WSMFproperty( WSCvbarGraph, WSNhatchPattern, WSCuchar,   _hatch_pattern,0    );
WSMFproperty( WSCvbarGraph, WSNhatchColor,  short,  _hatch_color,WS_DF_NWBACKCOLOR);
WSMFproperty( WSCvbarGraph, WSNdataSource,  WSCuchar, _data_source_type,WS_DATA_SOURCE_NONE);
WSMFproperty( WSCvbarGraph, WSNdataSourceName,  char*, _data_source_name,WSGFstrdup(""));
WSMFproperty( WSCvbarGraph, WSNbackBlinkColor, short,_bg_blink_color, WS_DF_NWBACKCOLOR);



void WSCvbarGraph::setWorkWSNvalue(char*){};
void WSCvbarGraph::getWorkWSNvalue(char**){};
void WSCvbarGraph::setWorkWSNcolumns(WSCushort){};
void WSCvbarGraph::getWorkWSNcolumns(WSCushort*){};
void WSCvbarGraph::setWorkWSNbarThickness(WSCuchar){};
void WSCvbarGraph::getWorkWSNbarThickness(WSCuchar*){};
void WSCvbarGraph::setWorkWSNorientation(WSCuchar){};
void WSCvbarGraph::getWorkWSNorientation(WSCuchar*){};
void WSCvbarGraph::setWorkWSNreverseFlag(WSCbool){};
void WSCvbarGraph::getWorkWSNreverseFlag(WSCbool*){};
void WSCvbarGraph::setWorkWSNlineWidth(WSCuchar){ }
void WSCvbarGraph::getWorkWSNlineWidth(WSCuchar*){ }
void WSCvbarGraph::setWorkWSNlineType(WSCuchar){ }
void WSCvbarGraph::getWorkWSNlineType(WSCuchar*){ }
void WSCvbarGraph::setWorkWSNstippled(WSCbool){ }
void WSCvbarGraph::getWorkWSNstippled(WSCbool*){ }
void WSCvbarGraph::setWorkWSNhatchPattern(WSCuchar){ }
void WSCvbarGraph::getWorkWSNhatchPattern(WSCuchar*){ }
void WSCvbarGraph::setWorkWSNhatchColor(short){ }
void WSCvbarGraph::getWorkWSNhatchColor(short*){ }
void WSCvbarGraph::setWorkWSNbackBlinkColor(short){ }
void WSCvbarGraph::getWorkWSNbackBlinkColor(short*){ }
void WSCvbarGraph::_set_ds_instance(){
  WSCbase* serv = WSGIappObjectList()->searchInstance("WSCbase", _data_source_name);
  if (serv != NULL){
    setDataSourceServer(serv);
    serv->addDataSourceClient(this);
    WSCstring val;
    val = serv->getProperty(serv->getDefaultProperty());
    setProperty(WSNvalue,val);
  }else{
    _need_ds_update = True;
  }
}

void WSCvbarGraph::setWorkWSNdataSource(WSCuchar){
  if (_data_source_name != NULL && _data_source_name[0] != 0){
    if (_data_source_type == WS_DATA_SOURCE_FILE){
      WSCstring* str = WSGFreadTextFile(_data_source_name);
      if (str != NULL){
        setProperty(WSNvalue,str->getString());
        delete str;
      }
    }else
    if (_data_source_type == WS_DATA_SOURCE_INSTANCE){
      _set_ds_instance();
    }
    if (_data_source_type != WS_DATA_SOURCE_INSTANCE){
      WSCbase* ds = getDataSourceServer();
      if (ds != NULL){
        ds->delDataSourceClient(this);
        setDataSourceServer(NULL);
      }
    }
  }
}
void WSCvbarGraph::getWorkWSNdataSource(WSCuchar*){}
void WSCvbarGraph::setWorkWSNdataSourceName(char* sname){
  if (_data_source_type == WS_DATA_SOURCE_INSTANCE){
    _set_ds_instance();
  }else
  if (_data_source_type == WS_DATA_SOURCE_FILE){
    WSCstring* str = WSGFreadTextFile(sname);
    if (str != NULL){
      setProperty(WSNvalue,str->getString());
      delete str;
    }
  }
}
void WSCvbarGraph::getWorkWSNdataSourceName(char**){}


WSCvbarGraph::~WSCvbarGraph() {
  if (_values != NULL){
    delete _values;
    _values = NULL;
  }
  if (_data_source_name != NULL){
    delete _data_source_name;
  }
}

long WSCvbarGraph::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (_num == 0){
    return WS_NO_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;
  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbool blinkfore = WSGIappBlink()->getBlinkFore(_blink_rate);

  if (_bl_fl == True &&
      blinkfore == True &&
      _tw_fl == False) {
    return WS_NO_ERR;
  }

  WSCbase::update();
  setAbsoluteDraw(False);
  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
     return WS_NO_ERR;
  }
  if (_orientation == WS_VERTICAL){
    h -= _lw;
  }else{
    w -= _lw;
  }
  long i;
  double interval = (double)w/_num;
  if (_orientation != WS_VERTICAL){
    interval = (double)h/_num;
  }

  WSCstring vlist(_values);
  long lnum = vlist.getWords(",");
  long num = _num;
  if (lnum < _num){
    num = lnum;
  }
  WSCbool not_draw = False;

  if (_stippled != False){
    dev->setLineWidth(0);
    dev->setHatchPattern(_hatch_pattern);
//    dev->setForeColor(_hatch_color);
    if (_bl_fl != False){
      if (_tw_fl == False){
        if (blinkfore == False){
          dev->setForeColor(_hatch_color);
        }else{
          not_draw = True;
        }
      }else{
        if (blinkfore == False){
          dev->setForeColor(_hatch_color);
        }else{
          dev->setForeColor(_bg_blink_color);
        }
      }
    }else{
      dev->setForeColor(_hatch_color);
    }
    if (not_draw == False){
      if (_orientation == WS_VERTICAL){
        for(i=0; i<num; i++){
          WSCstring tmp = vlist.getWord(i,",");
          long val = atoi(tmp);
          if (val == 0){
            continue;
          }
          if (_rev == False){
            dev->drawFillRect((short)(interval/2 + interval*i - _barw/2),
                            h - h*val/100 +_lw/2,
                            _barw,h*val/100);
          }else{
            dev->drawFillRect((short)(interval/2 + interval*i - _barw/2),
                            _lw/2,
                            _barw,h*val/100);
          }
        }
      }else{
        for(i=0; i<num; i++){
          WSCstring tmp = vlist.getWord(i,",");
          long val = atoi(tmp);
          if (val == 0){
            continue;
          }
          if (_rev == False){
            dev->drawFillRect( w - w*val/100 + _lw/2,
                              (short)(interval/2 + interval*i - _barw/2),
                              w*val/100,_barw);
          }else{
            dev->drawFillRect( _lw/2,
                               (short)(interval/2 + interval*i - _barw/2),
                               w*val/100,_barw);
          }
        }
      }
    }
  }
  dev->setLineWidth(_lw);
  dev->setLineDashType(_lt);
//  dev->setForeColor(_fore_color);
  not_draw = False;
  if (_bl_fl != False){
    if (_tw_fl == False){
      if (blinkfore == False){
        dev->setForeColor(_fore_color);
      }else{
        not_draw = True;
      }
    }else{
      if (blinkfore == False){
        dev->setForeColor(_fore_color);
      }else{
        dev->setForeColor(_blink_color);
      }
    }
  }else{
    dev->setForeColor(_fore_color);
  }

  dev->setHatchPattern(0);
  if (not_draw == False){
    if (_orientation == WS_VERTICAL){
      for(i=0; i<num; i++){
        WSCstring tmp = vlist.getWord(i,",");
        long val = atoi(tmp);
        if (val == 0){
          continue;
        }
        if (_rev == False){
          dev->drawRect((short)(interval/2 + interval*i - _barw/2),
                          h - h*val/100 +_lw/2,
                          _barw,h*val/100);
        }else{
          dev->drawRect((short)(interval/2 + interval*i - _barw/2),
                          _lw/2,
                          _barw,h*val/100);
        }
      }
    }else{
      for(i=0; i<num; i++){
        WSCstring tmp = vlist.getWord(i,",");
        long val = atoi(tmp);
        if (val == 0){
          continue;
        }
        if (_rev == False){
          dev->drawRect( w - w*val/100 + _lw/2,
                            (short)(interval/2 + interval*i - _barw/2),
                            w*val/100,_barw);
        }else{
          dev->drawRect( _lw/2, (short)(interval/2 + interval*i - _barw/2),
                            w*val/100,_barw);
        }
      }
    }
  }

  dev->endDraw();
  return WS_NO_ERR;
}

void WSCvbarGraph::setData(WSCvariant* val,long code){
  if (code == WS_EN_DEFAULT){
    WSCstring str;
    str.setString(val->getCharPtr(),code);
    setProperty(WSNvalue,str.getString());
  }else{
    setProperty(WSNvalue,val->getCharPtr());
  }
}

long WSCvbarGraph::getDataSourceType(){
  return _data_source_type;
}
char* WSCvbarGraph::getDataSourcePropertyName(){
  return WSNvalue;
}
void WSCvbarGraph::update(){
  if (_need_ds_update != False){
    _need_ds_update = False;
    _set_ds_instance();
  } 
  WSCnwbase::update();
}
char* WSCvbarGraph::getDefaultProperty(){
  return WSNvalue;
}
