//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <WSCvgraphMatrix.h>
#include <WSCclassInformation.h>
#include <WSCdevice.h>
#include <WSCblink.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSDdev.h>
#include <WSDcolor.h>
#include <WSCfontSet.h>
#include <WSDappDev.h>

WSMFguiClassInitialize(WSCvgraphMatrix, WSCnwbase);
WSMFversion(WSCvgraphMatrix, WSCnwbase);

WSCvgraphMatrix::WSCvgraphMatrix(WSCbase* base, char* objname):
			WSCnwbase(base, objname){
  _orientation  = WS_HORIZONTAL;
  _num = 11;
  _lw = 2;
  _lt = 0;

  WSMFpropertyCreateStart
    WSMFparentCheckVerSrc(WSCvgraphMatrix);

    WSMFpropertyCreate(WSNcolumns, WSCushort, _num,WSScolumns);
    WSMFpropertyCreate(WSNorientation,  WSCuchar, _orientation,WSSorientation);
      WSMFpropertySetSelection(WSRorientation, WSRorientationD);
    WSMFpropertyCreate(WSNlineWidth, WSCuchar, _lw,WSSlineWidth);
    WSMFpropertyCreate(WSNlineType,  WSCuchar, _lt,WSSlineType);
      WSMFpropertySetSelection(WSRlineType, WSRlineTypeD);
 
  WSMFpropertyCreateEnd

}
WSMFproperty( WSCvgraphMatrix, WSNcolumns, WSCushort, _num ,11);
WSMFproperty( WSCvgraphMatrix, WSNorientation, WSCuchar, _orientation ,WS_HORIZONTAL);
WSMFproperty( WSCvgraphMatrix, WSNlineWidth, WSCuchar, _lw, 2);
WSMFproperty( WSCvgraphMatrix, WSNlineType,  WSCuchar,      _lt, 0);



void WSCvgraphMatrix::setWorkWSNcolumns(WSCushort){};
void WSCvgraphMatrix::getWorkWSNcolumns(WSCushort*){};
void WSCvgraphMatrix::setWorkWSNorientation(WSCuchar){};
void WSCvgraphMatrix::getWorkWSNorientation(WSCuchar*){};
void WSCvgraphMatrix::setWorkWSNlineWidth(WSCuchar){ }
void WSCvgraphMatrix::getWorkWSNlineWidth(WSCuchar*){ }
void WSCvgraphMatrix::setWorkWSNlineType(WSCuchar){ }
void WSCvgraphMatrix::getWorkWSNlineType(WSCuchar*){ }

WSCvgraphMatrix::~WSCvgraphMatrix() {
}

long WSCvgraphMatrix::draw(){
  if (getVisible() == False){
    return WS_NO_ERR;
  }
  WSDdev* dev = getowndev();
  if (dev == NULL){
    return WS_ERR;
  }
  if (_num == 0){
    return WS_NO_ERR;
  }

  short x = _x;
  short y = _y;
  WSCushort w = _w;
  WSCushort h = _h;
  WSCbool absolute = getAbsoluteDraw();
  if (absolute == False && dev->isExposed(x, y, w, h) == False){
    return WS_NO_ERR;
  }
  WSCbase::update();
  setAbsoluteDraw(False);
  long err = dev->beginDraw(x, y, w, h, absolute);
  if (err != WS_NO_ERR){
     return WS_NO_ERR;
  }
  if (_orientation != WS_VERTICAL){
    h -= _lw;
  }else{
    w -= _lw;
  }
  long i;
  double interval = (double)h/_num;
  if (_orientation == WS_VERTICAL){
    interval = (double)w/_num;
  }

  dev->setLineWidth(_lw);
  dev->setHatchPattern(0);
  dev->setForeColor(_fore_color);
  dev->setLineDashType(_lt);

  for(i=0; i<_num; i++){  
    if (_orientation == WS_VERTICAL){
      dev->drawLine((short)(interval/2 + interval*(i)+_lw/2),0,
                    (short)(interval/2 + interval*(i)+_lw/2),h);
    }else{
      dev->drawLine(0,(short)(interval/2 + interval*(i)+_lw/2),
                    w,(short)(interval/2 + interval*(i)+_lw/2));
    }
  }

  dev->endDraw();
  return WS_NO_ERR;
}



