//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <basic.h>
#include <WScom.h>
#ifndef NO_WSDSEMAPHORE
#include <WStcpcom.h>
#include <btron/WSDbtronSemaphore.h>
#include <stdio.h>
#include <WSClocaleSet.h>
#include <btron/proctask.h>
#include <btron/taskcomm.h>

WSMFclassInit(WSDbtronSemaphore,WSDsemaphore);

WSDsemaphore* _btron_sem_chandler(){
  return new WSDbtronSemaphore;
}

void WSGFinitializeUnixSemaphore(){
    WSDsemaphore::setCreateInstanceHandler((void*)_btron_sem_chandler);
}

class _btron_sem_init {
  public: _btron_sem_init(){
    WSDsemaphore::setCreateInstanceHandler((void*)_btron_sem_chandler);
  };
};
_btron_sem_init  _btron_sem_init_execute;

WSDbtronSemaphore::WSDbtronSemaphore(){
}

WSDbtronSemaphore::~WSDbtronSemaphore(){
}

long WSDbtronSemaphore::initialize(){
  WERR sem = cre_sem(1,SEM_SYNC|DELEXIT );
  if (sem < 0){
    return WS_ERR;
  }
  _sem = sem;
  return WS_NO_ERR;
}
long WSDbtronSemaphore::lock(){
  if (_sem == 0){
    return WS_ERR;
  }
  int ret = wai_sem(_sem,T_FOREVER);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDbtronSemaphore::unlock(){
  if (_sem == 0){
    return WS_ERR;
  }
  int ret = sig_sem(_sem);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}

long WSDbtronSemaphore::destroy(){
  if (_sem == 0){
    return WS_ERR;
  }
  int ret = del_sem(_sem);
  if (ret == 0){
    return WS_NO_ERR;
  }
  return WS_ERR;
}



#endif
