//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <basic.h>
#include <btron/hmi.h>
#include <WScom.h>
#ifndef NO_MWINDEV
#include <WSCdevice.h>
#include <WSCcolorSet.h>
#include <WSCimageSet.h>
#include <WSCbase.h>
#include <WSDmouse.h>
#include <WSCbaseList.h>
#include <btron/WSDbtronmwinDev.h>
#include <btron/WSDbtronAppDev.h>
#include <btron/WSDbtronDraw.h>

WSMFclassInit(WSDbtronmwinDev,WSDmwindowDev);

WSDdev* _wsdbtronmwindev_init_(){
  return new WSDbtronmwinDev();
}

class _WSDbtronmwinDev_init_ {
  public:_WSDbtronmwinDev_init_(){
     WSGIappDevice()->setCreateHandler("mwindowDev",_wsdbtronmwindev_init_);
  };
};
static _WSDbtronmwinDev_init_ _init_to_run_WSDbtronmwinDev_;

//static WSDxdraw* draw_of_btronmwin = NULL;

//int red_mask, green_mask, blue_mask;
//int red_shift, green_shift, blue_shift;
//int start_shift;
//unsigned int start_mask;
//char mask_initialized = 0;
//long msb_flag = 0;

WSDbtronmwinDev::WSDbtronmwinDev(){
  _mem_gid = 0;
  _mem_gid_buf = NULL;
  _bit = 0; 
  _buf = NULL;
//  if (draw_of_btronmwin == NULL){
//      draw_of_btronmwin = new WSDxdraw();
//  }
//  setDraw(draw_of_btronmwin);
}

WSDbtronmwinDev::~WSDbtronmwinDev(){
  destroyContext();
  destroyPixmap();
}

long WSDbtronmwinDev::copyToWindow(WSDdev* dest,short x,short y,WSCushort w,WSCushort h,short dx,short dy){
  if (dest->cast("WSDnwDev") != NULL){
    int vx = 0;
    int vy = 0;
    if (dest->getAttachedClient() != NULL){
      vx = dest->getAttachedClient()->getProperty(WSNx);
      vy = dest->getAttachedClient()->getProperty(WSNy);
    }
    WSDdev* pdev = dest->getParentDev();
    WSDbtronFormDev* xdev = NULL;
    if (pdev != NULL){
      xdev = (WSDbtronFormDev*)dest->getParentDev()->cast("WSDbtronFormDev");
    }
    if (xdev != NULL ){
      short px,py;
      xdev->getAbstPos(&px,&py);
      RECT from;
//      from.c.left = x;
//      from.c.top = y;
//      from.c.right = w +x;
//      from.c.bottom = h +y;

      short cx,cy;
      WSCushort cw,ch;
      xdev->getAbstSize(&cx,&cy,&cw,&ch);
      long ax,ay;
      WSCulong aw,ah;
      WSGFandArea(cx,cy,cw,ch, dx+px+vx,dy+py+vy, w,h,&ax,&ay,&aw,&ah); 

      RECT to;
//      to.c.left = dx + px + vx;
//      to.c.top = dy + py + vy;
//      to.c.right = w +dx + px + vx;
//      to.c.bottom = h +dy + py + vy;
      to.c.left = ax;
      to.c.top = ay;
      to.c.right = ax + aw;
      to.c.bottom = ay + ah;

      from.c.left = x + ax -(dx+px+vx);
      from.c.top = y + ay - (dy+py+vy);
      from.c.right = from.c.left + aw;
      from.c.bottom = from.c.top + ah;


      gset_for(_mem_gid,NULL);
      gset_vis(_mem_gid,from);
//      gset_for(xdev->getParentGID(),NULL);
//      gset_vis(xdev->getParentGID(),to);

      if (xdev->getParentGID() != 0){
        gset_for(xdev->getParentGID(),NULL);
        xdev->setDefaultRegion();
        gset_vis(xdev->getParentGID(),to);
        gcop_bmp(_mem_gid,&from,xdev->getParentGID(),&to,NULL,G_STORE);
      }
      if (xdev->getParentMemGID() != 0){
        gset_for(xdev->getParentMemGID(),NULL);
        xdev->setDefaultRegion();
        gset_vis(xdev->getParentMemGID(),to);
        gcop_bmp(_mem_gid,&from,xdev->getParentMemGID(),&to,NULL,G_STORE);
      }
    }
  }else{
    WSDbtronFormDev* xdev = (WSDbtronFormDev*)dest->cast("WSDbtronFormDev");
    if (xdev != NULL ){
      short px,py;
      xdev->getAbstPos(&px,&py);
      RECT from;
//      from.c.left = x;
//      from.c.top = y;
//      from.c.right = w +x;
//      from.c.bottom = h +y;

      short cx,cy;
      WSCushort cw,ch;
      xdev->getAbstSize(&cx,&cy,&cw,&ch);
      long ax,ay;
      WSCulong aw,ah;
      WSGFandArea(cx,cy,cw,ch, dx+px,dy+py, w,h,&ax,&ay,&aw,&ah); 

      from.c.left = x + ax -(dx+px);
      from.c.top = y + ay - (dy+py);
      from.c.right = from.c.left + aw;
      from.c.bottom = from.c.top + ah;

      RECT to;
//      to.c.left = dx + px;
//      to.c.top = dy + py;
//      to.c.right = w +dx + px;
//      to.c.bottom = h +dy + py;
      to.c.left = ax;
      to.c.top = ay;
      to.c.right = ax + aw;
      to.c.bottom = ay + ah;

      gset_for(_mem_gid,NULL);
      gset_vis(_mem_gid,from);
//      gset_for(xdev->getParentGID(),NULL);
      
      if (xdev->getParentGID() != 0){
        gset_for(xdev->getParentGID(),NULL);
        xdev->setDefaultRegion();
        gset_vis(xdev->getParentGID(),to);
        gcop_bmp(_mem_gid,&from,xdev->getParentGID(),&to,NULL,G_STORE);
      }
      if (xdev->getParentMemGID() != 0){
        gset_for(xdev->getParentMemGID(),NULL);
        xdev->setDefaultRegion();
        gset_vis(xdev->getParentMemGID(),to);
        gcop_bmp(_mem_gid,&from,xdev->getParentMemGID(),&to,NULL,G_STORE);
      }
    }
  }
  return WS_NO_ERR;
}
long WSDbtronmwinDev::copyToWindowWithMask(WSDdev* dest,short x,short y,
                                       WSCushort w,WSCushort h,short dx,short dy,
                                       WSDimage* image){
  if (image == NULL){
    return WS_ERR;
  }

  W mask = (W)image->getValue1();
  return _copyToWindowWithMask(dest,x,y,w,h,dx,dy,mask);

}
long WSDbtronmwinDev::_copyToWindowWithMask(WSDdev* dest,short x,short y,
                                       WSCushort w,WSCushort h,short dx,short dy,
                                       W mask){
  //TODO ...
  return WS_NO_ERR;
}
long WSDbtronmwinDev::copyToWindowWithMask(WSDdev* dest,short x,short y,
                                       WSCushort w,WSCushort h,short dx,short dy,
                                       WSDmwindowDev* image){
  if (image == NULL){
    return WS_ERR;
  }
  WSDbtronmwinDev* mimage = (WSDbtronmwinDev*)image->cast("WSDbtronmwinDev");
  if (mimage == NULL){
    return WS_ERR;
  }
  W mask = mimage->_mem_gid;
  return _copyToWindowWithMask(dest,x,y,w,h,dx,dy,mask);

}

long WSDbtronmwinDev::copyFromWindow(WSDdev* dest,short x,short y,WSCushort w,WSCushort h,short dx,short dy){
  if (_mem_gid == NULL){
    return WS_ERR;
  }
  if (dest->cast("WSDnwDev") != NULL){
    int vx = 0;
    int vy = 0;
    if (dest->getAttachedClient() != NULL){
      vx = dest->getAttachedClient()->getProperty(WSNx);
      vy = dest->getAttachedClient()->getProperty(WSNy);
    }
    WSDdev* pdev = dest->getParentDev();
    WSDbtronFormDev* xdev = NULL;
    if (pdev != NULL){
      xdev = (WSDbtronFormDev*)dest->getParentDev()->cast("WSDbtronFormDev");
    }
    if (xdev != NULL ){
      short px,py;
      xdev->getAbstPos(&px,&py);
      RECT to;
      to.c.left = x;
      to.c.top = y;
      to.c.right = w +x;
      to.c.bottom = h +y;

      RECT from;
      from.c.left = dx + px + vx;
      from.c.top = dy + py + vy;
      from.c.right = w +dx + px + vx;
      from.c.bottom = h +dy + py + vy;

      gset_for(_mem_gid,NULL);
      gset_vis(_mem_gid,to);
      gset_for(xdev->getParentGID(),NULL);
      gset_vis(xdev->getParentGID(),from);
      xdev->setDefaultRegion();

      gcop_bmp(xdev->getParentGID(),&from,_mem_gid,&to,NULL,G_STORE);
    }
  }else{
    WSDbtronFormDev* xdev = (WSDbtronFormDev*)dest->cast("WSDbtronFormDev");
    if (xdev != NULL ){
      short px,py;
      xdev->getAbstPos(&px,&py);
      RECT to;
      to.c.left = x;
      to.c.top = y;
      to.c.right = w +x;
      to.c.bottom = h +y;

      RECT from;
      from.c.left = dx + px;
      from.c.top = dy + py;
      from.c.right = w +dx + px;
      from.c.bottom = h +dy + py;
      gset_for(_mem_gid,NULL);
      gset_vis(_mem_gid,to);
      gset_for(xdev->getParentGID(),NULL);
      gset_vis(xdev->getParentGID(),from);
      xdev->setDefaultRegion();

      gcop_bmp(xdev->getParentGID(),&from,_mem_gid,&to,NULL,G_STORE);
    }
  }
  return WS_NO_ERR;
}

long WSDbtronmwinDev::createPixmap(WSCushort w,WSCushort h){
  _w = w;
  _h = h;
  if (_w == 0 || _h == 0){
    return WS_ERR;
  }

  if (_buf != 0){
    destroyPixmap();
  }
  _buf = new WSCushort [ w * h * 3];
  createContext();
  return WS_NO_ERR;
}
long WSDbtronmwinDev::destroyPixmap(){
  if ( _buf == NULL){
    delete _buf;
    _buf = NULL;
  }
  destroyContext();
  return WS_NO_ERR;
}

long WSDbtronmwinDev::getDeviceResource(){
  return (long)0;
}


long WSDbtronmwinDev::getContextResource(){
  if (_mem_gid == 0){
    return -1;
  }
  return (long)_mem_gid;
}

long WSDbtronmwinDev::getSpecialResource(){
   return (long)0;
}

long WSDbtronmwinDev::createContext(){
  if (_mem_gid != NULL){
    destroyContext();
  }
  if (_w == 0 || _h == 0){
    return WS_ERR;
  } 
  _mem_gid =  WSGIbtronAppDev()->getNewMemGid(_w,_h,&_mem_gid_buf);
  return WS_NO_ERR;
}

long WSDbtronmwinDev::getWindowResource(){
  return (long)0;
}

long WSDbtronmwinDev::destroyContext(){
  if (_mem_gid != 0){
    delete _mem_gid_buf;
    _mem_gid_buf = NULL;
    gcls_env(_mem_gid);
    _mem_gid = 0;
  }
  return WS_NO_ERR;
}

long WSDbtronmwinDev::initBuffer(){
  if (_buf == NULL){
    return WS_ERR;
  }
  long x,y;
  UB* buf2 = new UB [_w * _h * 2];

  DEV_SPEC* dspec = WSGIbtronAppDev()->getDevSpec();
//printf("0x%x 0x%x 0x%x\n",dspec->color[0],dspec->color[1],dspec->color[2]);


  BMP bmp;
  bmp.planes = 1;
  bmp.pixbits = 0x1010;
  bmp.rowbytes = _w*2;
  bmp.bounds.c.left = 0;
  bmp.bounds.c.top = 0;
  bmp.bounds.c.right = _w;
  bmp.bounds.c.bottom = _h;
  bmp.baseaddr[0] = buf2;

  CSPEC   csp;
  csp.attr = DA_COLOR_RGB;
  csp.info[0] = 0x0b05;
  csp.info[1] = 0x0506;
  csp.info[2] = 0x0005;
  csp.info[3] = 0;
  csp.colmap = NULL;

  W bgid = gopn_mem(NULL,&bmp,(B*)(&csp));
  RECT r;
  RECT r2;
  r.c.left = 0;
  r.c.top = 0;
  r.c.right = _w;
  r.c.bottom = _h;
  r2.c.left = 0;
  r2.c.top = 0;
  r2.c.right = _w;
  r2.c.bottom = _h;

  W ret = gcop_bmp(_mem_gid,&r2,bgid,&r,NULL,G_CVCOLOR | G_CVFORM | G_STORE);

  long pt = 0;
  long pt2 = 0;
  for(x=0; x<_w; x++){
    for(y=0; y<_h; y++){
      UB v1 = buf2[pt++];
      UB v2 = buf2[pt++];
      WSCushort val = v2 << 8 | v1;
#if 0
      double r = (double)((val >> 11) & 0x1f)*255/31;
      double g = (double)((val >> 5) & 0x3f)*255/63;
      double b = (double)((val) & 0x1f)*255/31;
      _buf[pt2++] = WSCuchar(r);
      _buf[pt2++] = WSCuchar(g);
      _buf[pt2++] = WSCuchar(b);
#endif
      _buf[pt2++] = ((val >> 11) & 0x1f) << 3;
      _buf[pt2++] = ((val >> 5) & 0x3f) << 2;
      _buf[pt2++] = ((val ) & 0x1f) << 3;
    }
  }
  delete buf2;
  gcls_env(bgid);

#if 0
  PIXVAL val;
  PNT pnt;
  long pt = 0;
  for(x=0; x<_w; x++){
    for(y=0; y<_h; y++){
      pnt.x = x;
      pnt.y = y;
      gtst_pnt(_mem_gid,pnt,&val);
      _buf[pt++] = (WSCushort)((0xff0000 & val) >> 16);
      _buf[pt++] = (WSCushort)((0xff00 & val) >> 8);
      _buf[pt++] = (WSCushort)(0xff & val);
    }
  }
#endif
  return WS_ERR;
}
long WSDbtronmwinDev::setBufferRGB(WSCushort x,WSCushort y,WSCuchar r,WSCuchar g,WSCuchar b){
  if (x < _w && y < _h){
    long pnt = (x + y * _w)*3;
    _buf[pnt] = r;
    _buf[pnt+1] = g;
    _buf[pnt+2] = b;
    return WS_NO_ERR;
  }
  return WS_ERR;
}
long WSDbtronmwinDev::getBufferRGB(WSCushort x,WSCushort y, WSCuchar* r, WSCuchar* g,WSCuchar* b){
  if (x < _w && y < _h){
    long pnt = (x + y * _w)*3;
    *r = _buf[pnt];
    *g = _buf[pnt+1];
    *b = _buf[pnt+2];
    return WS_NO_ERR;
  }

  return WS_ERR;
}
long WSDbtronmwinDev::putBufferToPixmap(){
  if (_mem_gid == NULL){
    return WS_ERR;
  }
  if (_w > 0 && _h > 0){
#if 0
    long pt = 0;
    long x,y;
    long val = 0x10000000;
    for(x=0; x<_w; x++){
      for(y=0; y<_h; y++){
        val = 0x10000000;
        val |= _buf[pt++]<<16;
        val |= _buf[pt++]<<8;
        val |= _buf[pt++];
        PNT pnt;
        pnt.x = x;
        pnt.y = y;
        gdra_pnt(_mem_gid,pnt,val,G_STORE);
      }
    }
#endif
    UB* buf2 = new UB[_w * _h * 2];
    long cnt = 0;
    int i,j,ptr;
    for(i=0; i<_h; i++){
      ptr = _w*3*i;
      for(j=0; j<_w; j++){
        UB r = _buf[ptr++];
        UB g = _buf[ptr++];
        UB b = _buf[ptr++];
//        r = 0x20;
//        g = 0x20;
//        b = 0x20;
//        r = (UB)((double)r *31/255) << 3;
//        g = (UB)((double)g *63/255) << 2;
//        b = (UB)((double)b *31/255) << 3;
        buf2[cnt++] = ((g & 0x1c) << 3 )| (b & 0xf8) >> 3;
        buf2[cnt++] = (r & 0xf8) | ((g & 0xe0) >> 5);
      }
    }
    BMP bmp;
    bmp.planes = 1;
    bmp.pixbits = 0x1010;
    bmp.rowbytes = _w*2;
    bmp.bounds.c.left = 0;
    bmp.bounds.c.top = 0;
    bmp.bounds.c.right = _w;
    bmp.bounds.c.bottom = _h;
    bmp.baseaddr[0] = buf2;

    CSPEC   csp;
    csp.attr = DA_COLOR_RGB;
    csp.info[0] = 0x0b05;
    csp.info[1] = 0x0506;
    csp.info[2] = 0x0005;
    csp.info[3] = 0;
    csp.colmap = NULL;

    W bgid = gopn_mem(NULL,&bmp,(B*)(&csp));
//printf("bgid=0x%x\n",bgid);
    RECT r;
    RECT r2;
    r.c.left = 0;
    r.c.top = 0;
    r.c.right = _w;
    r.c.bottom = _h;
    r2.c.left = 0;
    r2.c.top = 0;
    r2.c.right = _w;
    r2.c.bottom = _h;

    W ret = gcop_bmp(bgid,&r2,_mem_gid,&r,NULL,G_CVCOLOR | G_CVFORM | G_STORE);
    delete buf2;
    gcls_env(bgid);

  }
  return WS_NO_ERR;
}

#endif
