//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <devfb/devfb.h>
#include <WScom.h>
#include <WSDenv.h>
#include <WSCcolorSet.h>
#include <devfb/WSDdevfbColor.h>
#include <devfb/WSDdevfbAppDev.h>
#include <x11/WSDunixFile.h>
#include <x11/WSDunixFS.h>
#include <unistd.h>
#include <signal.h>

WSMFclassInit(WSDdevfbColor,WSDcolor);

WSDcolor* _devfbColor_create_handler(){
  WSDcolor* color = new WSDdevfbColor();
  return color;
};

void _devfbColor_init(){
//  extern int _ehandler(Display*,XErrorEvent*);
//  XSetErrorHandler(_ehandler);
  WSGIappColorSet()->setCreateHandler(_devfbColor_create_handler);
  WSGFinitUnixFileSystem();
dbprintf("_devfbColor_init executed..\n");
};


WSDdevfbColor::WSDdevfbColor(){
//  _private_cell = 0;
}

struct color_data {
  long r;
  long g;
  long b;
  char* cname;
};
extern struct color_data color_names[];

long WSDdevfbColor::initialize(){
  char* cname = getSrc();
  if (cname == NULL){
    cname = "black";
  }
  _a = 255;
  WSCbool alpha = False;
  long rval = 0,gval = 0,bval = 0,aval=255;
  if(cname[0] == '#'){
    long slen = strlen(cname);
    if(slen == 4){
      sscanf( cname,"#%1x%1x%1x",&rval,&gval,&bval);
      rval = rval *16;
      gval = gval *16;
      bval = bval *16;
    }else if(slen == 5){
      sscanf( cname,"#%1x%1x%1x%1x",&rval,&gval,&bval,&aval);
      rval = rval *16;
      gval = gval *16;
      bval = bval *16;
      aval = aval *16;
      alpha = True;
    }else if(slen == 7){
      sscanf( cname,"#%2x%2x%2x",&rval,&gval,&bval);
    }else if(slen == 9){
      sscanf( cname,"#%2x%2x%2x%2x",&rval,&gval,&bval,&aval);
      alpha = True;
    }else if(slen == 13){
      sscanf( cname,"#%4x%4x%4x",&rval,&gval,&bval);
      rval = rval /256;
      gval = gval /256;
      bval = bval /256;
    }else if(slen == 17){
      sscanf( cname,"#%4x%4x%4x%4x",&rval,&gval,&bval,&aval);
      rval = rval /256;
      gval = gval /256;
      bval = bval /256;
      aval = aval /256;
      alpha = True;
    }else{
      //black...
    }
  }else{
    long i;
    long len;
    char cname2[64];
                                                                                
    len = strlen(cname);
    for(i=0; i < len; i++ ){
      if(cname[i] > 'a'-1 && cname[i] < 'z'+1){
        cname2[i] = cname[i] + 'A' - 'a';
      }else{
        cname2[i] = cname[i];
      }
    }
    cname2[len] = 0;
    i = 0 ;
    while( color_names[i].cname != NULL ){
      if(color_names[i].cname[0] == cname2[0] &&
         strcmp(color_names[i].cname,cname2) == 0){
        rval = color_names[i].r;
        gval = color_names[i].g;
        bval = color_names[i].b;
        break;
      }
      i++ ;
    }
  }
  long val = 0;
  val |= rval << 16;
  val |= gval << 8;
  val |= bval;
  _r = rval;
  _g = gval;
  _b = bval;
//printf("color=%s %02x,%02x,%02x val=0x%x\n",cname,_r,_g,_b,val);
  if (alpha == False){
    val |= 0xff000000;
    setValue1((long)val);
  }else{
    val |= aval << 24;
    _a = aval;
    setValue1((long)val);
//printf("color=%s %02x,%02x,%02x,%02x val=0x%x\n",cname,_r,_g,_b,_a,val);
  }
  return WS_NO_ERR;
}
long WSDdevfbColor::getAlpha(){
  return _a;
}
//XColor* WSDdevfbColor::getXColor1(){
//  return &_xc1;
//}
long WSDdevfbColor::getRGB(long* r,long* g,long* b){
  *r = _r;
  *g = _g;
  *b = _b;
  return WS_NO_ERR;
}

struct color_data color_names[] ={
#ifndef NO_COLOR_NAME
{255,250,250,"SNOW"},
{248,248,255,"GHOST WHITE"},
{248,248,255,"GHOSTWHITE"},
{245,245,245,"WHITE SMOKE"},
{245,245,245,"WHITESMOKE"},
{220,220,220,"GAINSBORO"},
{255,250,240,"FLORAL WHITE"},
{255,250,240,"FLORALWHITE"},
{253,245,230,"OLD LACE"},
{253,245,230,"OLDLACE"},
{250,240,230,"LINEN"},
{250,235,215,"ANTIQUE WHITE"},
{250,235,215,"ANTIQUEWHITE"},
{255,239,213,"PAPAYA WHIP"},
{255,239,213,"PAPAYAWHIP"},
{255,235,205,"BLANCHED ALMOND"},
{255,235,205,"BLANCHEDALMOND"},
{255,228,196,"BISQUE"},
{255,218,185,"PEACH PUFF"},
{255,218,185,"PEACHPUFF"},
{255,222,173,"NAVAJO WHITE"},
{255,222,173,"NAVAJOWHITE"},
{255,228,181,"MOCCASIN"},
{255,248,220,"CORNSILK"},
{255,255,240,"IVORY"},
{255,250,205,"LEMON CHIFFON"},
{255,250,205,"LEMONCHIFFON"},
{255,245,238,"SEASHELL"},
{240,255,240,"HONEYDEW"},
{245,255,250,"MINT CREAM"},
{245,255,250,"MINTCREAM"},
{240,255,255,"AZURE"},
{240,248,255,"ALICE BLUE"},
{240,248,255,"ALICEBLUE"},
{230,230,250,"LAVENDER"},
{255,240,245,"LAVENDER BLUSH"},
{255,240,245,"LAVENDERBLUSH"},
{255,228,225,"MISTY ROSE"},
{255,228,225,"MISTYROSE"},
#endif
{255,255,255,"WHITE"},
#ifndef NO_COLOR_NAME
{255,250,250,"SNOW"},
{248,248,255,"GHOST WHITE"},
{248,248,255,"GHOSTWHITE"},
{245,245,245,"WHITE SMOKE"},
{245,245,245,"WHITESMOKE"},
{220,220,220,"GAINSBORO"},
{255,250,240,"FLORAL WHITE"},
{255,250,240,"FLORALWHITE"},
{253,245,230,"OLD LACE"},
{253,245,230,"OLDLACE"},
{250,240,230,"LINEN"},
{250,235,215,"ANTIQUE WHITE"},
{250,235,215,"ANTIQUEWHITE"},
{255,239,213,"PAPAYA WHIP"},
{255,239,213,"PAPAYAWHIP"},
{255,235,205,"BLANCHED ALMOND"},
{255,235,205,"BLANCHEDALMOND"},
{255,228,196,"BISQUE"},
{255,218,185,"PEACH PUFF"},
{255,218,185,"PEACHPUFF"},
{255,222,173,"NAVAJO WHITE"},
{255,222,173,"NAVAJOWHITE"},
{255,228,181,"MOCCASIN"},
{255,248,220,"CORNSILK"},
{255,255,240,"IVORY"},
{255,250,205,"LEMON CHIFFON"},
{255,250,205,"LEMONCHIFFON"},
{255,245,238,"SEASHELL"},
{240,255,240,"HONEYDEW"},
{245,255,250,"MINT CREAM"},
{245,255,250,"MINTCREAM"},
{240,255,255,"AZURE"},
{240,248,255,"ALICE BLUE"},
{240,248,255,"ALICEBLUE"},
{230,230,250,"LAVENDER"},
{255,240,245,"LAVENDER BLUSH"},
{255,240,245,"LAVENDERBLUSH"},
{255,228,225,"MISTY ROSE"},
{255,228,225,"MISTYROSE"},
{255,255,255,"WHITE"},
{  0,  0,205,"MEDIUM BLUE"},
{  0,  0,205,"MEDIUMBLUE"},
{ 65,105,225,"ROYAL BLUE"},
{ 65,105,225,"ROYALBLUE"},
{  0,  0,255,"BLUE"},
{ 30,144,255,"DODGER BLUE"},
{ 30,144,255,"DODGERBLUE"},
{  0,191,255,"DEEP SKY BLUE"},
{  0,191,255,"DEEPSKYBLUE"},
{135,206,235,"SKY BLUE"},
{135,206,235,"SKYBLUE"},
{135,206,250,"LIGHT SKY BLUE"},
{135,206,250,"LIGHTSKYBLUE"},
{ 70,130,180,"STEEL BLUE"},
{ 70,130,180,"STEELBLUE"},
{176,196,222,"LIGHT STEEL BLUE"},
{176,196,222,"LIGHTSTEELBLUE"},
{173,216,230,"LIGHT BLUE"},
{173,216,230,"LIGHTBLUE"},
{176,224,230,"POWDER BLUE"},
{176,224,230,"POWDERBLUE"},
{175,238,238,"PALE TURQUOISE"},
{175,238,238,"PALETURQUOISE"},
{  0,206,209,"DARK TURQUOISE"},
{  0,206,209,"DARKTURQUOISE"},
{ 72,209,204,"MEDIUM TURQUOISE"},
{ 72,209,204,"MEDIUMTURQUOISE"},
{ 64,224,208,"TURQUOISE"},
{  0,255,255,"CYAN"},
{224,255,255,"LIGHT CYAN"},
{224,255,255,"LIGHTCYAN"},
{ 95,158,160,"CADET BLUE"},
{ 95,158,160,"CADETBLUE"},
{102,205,170,"MEDIUM AQUAMARINE"},
{102,205,170,"MEDIUMAQUAMARINE"},
{127,255,212,"AQUAMARINE"},
{  0,100,  0,"DARK GREEN"},
{  0,100,  0,"DARKGREEN"},
{ 85,107, 47,"DARK OLIVE GREEN"},
{ 85,107, 47,"DARKOLIVEGREEN"},
{143,188,143,"DARK SEA GREEN"},
{143,188,143,"DARKSEAGREEN"},
{ 46,139, 87,"SEA GREEN"},
{ 46,139, 87,"SEAGREEN"},
{ 60,179,113,"MEDIUM SEA GREEN"},
{ 60,179,113,"MEDIUMSEAGREEN"},
{ 32,178,170,"LIGHT SEA GREEN"},
{ 32,178,170,"LIGHTSEAGREEN"},
{152,251,152,"PALE GREEN"},
{152,251,152,"PALEGREEN"},
{  0,255,127,"SPRING GREEN"},
{  0,255,127,"SPRINGGREEN"},
{124,252,  0,"LAWN GREEN"},
{124,252,  0,"LAWNGREEN"},
{  0,255,  0,"GREEN"},
{127,255,  0,"CHARTREUSE"},
{  0,250,154,"MEDIUM SPRING GREEN"},
{  0,250,154,"MEDIUMSPRINGGREEN"},
{173,255, 47,"GREEN YELLOW"},
{173,255, 47,"GREENYELLOW"},
{ 50,205, 50,"LIME GREEN"},
{ 50,205, 50,"LIMEGREEN"},
{154,205, 50,"YELLOW GREEN"},
{154,205, 50,"YELLOWGREEN"},
{ 34,139, 34,"FOREST GREEN"},
{ 34,139, 34,"FORESTGREEN"},
{107,142, 35,"OLIVE DRAB"},
{107,142, 35,"OLIVEDRAB"},
{189,183,107,"DARK KHAKI"},
{189,183,107,"DARKKHAKI"},
{240,230,140,"KHAKI"},
{238,232,170,"PALE GOLDENROD"},
{238,232,170,"PALEGOLDENROD"},
{250,250,210,"LIGHT GOLDENROD YELLOW"},
{250,250,210,"LIGHTGOLDENRODYELLOW"},
{255,255,224,"LIGHT YELLOW"},
{255,255,224,"LIGHTYELLOW"},
{255,255,  0,"YELLOW"},
{255,215,  0,"GOLD"},
{238,221,130,"LIGHT GOLDENROD"},
{238,221,130,"LIGHTGOLDENROD"},
{218,165, 32,"GOLDENROD"},
{184,134, 11,"DARK GOLDENROD"},
{184,134, 11,"DARKGOLDENROD"},
{188,143,143,"ROSY BROWN"},
{188,143,143,"ROSYBROWN"},
{205, 92, 92,"INDIAN RED"},
{205, 92, 92,"INDIANRED"},
{139, 69, 19,"SADDLE BROWN"},
{139, 69, 19,"SADDLEBROWN"},
{160, 82, 45,"SIENNA"},
{205,133, 63,"PERU"},
{222,184,135,"BURLYWOOD"},
{245,245,220,"BEIGE"},
{245,222,179,"WHEAT"},
{244,164, 96,"SANDY BROWN"},
{244,164, 96,"SANDYBROWN"},
{210,180,140,"TAN"},
{210,105, 30,"CHOCOLATE"},
{178, 34, 34,"FIREBRICK"},
{165, 42, 42,"BROWN"},
{233,150,122,"DARK SALMON"},
{233,150,122,"DARKSALMON"},
{250,128,114,"SALMON"},
{255,160,122,"LIGHT SALMON"},
{255,160,122,"LIGHTSALMON"},
{255,165,  0,"ORANGE"},
{255,140,  0,"DARK ORANGE"},
{255,140,  0,"DARKORANGE"},
{255,127, 80,"CORAL"},
{240,128,128,"LIGHT CORAL"},
{240,128,128,"LIGHTCORAL"},
{255, 99, 71,"TOMATO"},
{255, 69,  0,"ORANGE RED"},
{255, 69,  0,"ORANGERED"},
{255,  0,  0,"RED"},
{255,105,180,"HOT PINK"},
{255,105,180,"HOTPINK"},
{255, 20,147,"DEEP PINK"},
{255, 20,147,"DEEPPINK"},
{255,192,203,"PINK"},
{255,182,193,"LIGHT PINK"},
{255,182,193,"LIGHTPINK"},
{219,112,147,"PALE VIOLET RED"},
{219,112,147,"PALEVIOLETRED"},
{176, 48, 96,"MAROON"},
{199, 21,133,"MEDIUM VIOLET RED"},
{199, 21,133,"MEDIUMVIOLETRED"},
{208, 32,144,"VIOLET RED"},
{208, 32,144,"VIOLETRED"},
{255,  0,255,"MAGENTA"},
{238,130,238,"VIOLET"},
{221,160,221,"PLUM"},
{218,112,214,"ORCHID"},
{186, 85,211,"MEDIUM ORCHID"},
{186, 85,211,"MEDIUMORCHID"},
{153, 50,204,"DARK ORCHID"},
{153, 50,204,"DARKORCHID"},
{148,  0,211,"DARK VIOLET"},
{148,  0,211,"DARKVIOLET"},
{138, 43,226,"BLUE VIOLET"},
{138, 43,226,"BLUEVIOLET"},
{160, 32,240,"PURPLE"},
{147,112,219,"MEDIUM PURPLE"},
{147,112,219,"MEDIUMPURPLE"},
{216,191,216,"THISTLE"},
{255,250,250,"SNOW1"},
{238,233,233,"SNOW2"},
{205,201,201,"SNOW3"},
{139,137,137,"SNOW4"},
{255,245,238,"SEASHELL1"},
{238,229,222,"SEASHELL2"},
{205,197,191,"SEASHELL3"},
{139,134,130,"SEASHELL4"},
{255,239,219,"ANTIQUEWHITE1"},
{238,223,204,"ANTIQUEWHITE2"},
{205,192,176,"ANTIQUEWHITE3"},
{139,131,120,"ANTIQUEWHITE4"},
{255,228,196,"BISQUE1"},
{238,213,183,"BISQUE2"},
{205,183,158,"BISQUE3"},
{139,125,107,"BISQUE4"},
{255,218,185,"PEACHPUFF1"},
{238,203,173,"PEACHPUFF2"},
{205,175,149,"PEACHPUFF3"},
{139,119,101,"PEACHPUFF4"},
{255,222,173,"NAVAJOWHITE1"},
{238,207,161,"NAVAJOWHITE2"},
{205,179,139,"NAVAJOWHITE3"},
{139,121, 94,"NAVAJOWHITE4"},
{255,250,205,"LEMONCHIFFON1"},
{238,233,191,"LEMONCHIFFON2"},
{205,201,165,"LEMONCHIFFON3"},
{139,137,112,"LEMONCHIFFON4"},
{255,248,220,"CORNSILK1"},
{238,232,205,"CORNSILK2"},
{205,200,177,"CORNSILK3"},
{139,136,120,"CORNSILK4"},
{255,255,240,"IVORY1"},
{238,238,224,"IVORY2"},
{205,205,193,"IVORY3"},
{139,139,131,"IVORY4"},
{240,255,240,"HONEYDEW1"},
{224,238,224,"HONEYDEW2"},
{193,205,193,"HONEYDEW3"},
{131,139,131,"HONEYDEW4"},
{255,240,245,"LAVENDERBLUSH1"},
{238,224,229,"LAVENDERBLUSH2"},
{205,193,197,"LAVENDERBLUSH3"},
{139,131,134,"LAVENDERBLUSH4"},
{255,228,225,"MISTYROSE1"},
{238,213,210,"MISTYROSE2"},
{205,183,181,"MISTYROSE3"},
{139,125,123,"MISTYROSE4"},
{240,255,255,"AZURE1"},
{224,238,238,"AZURE2"},
{193,205,205,"AZURE3"},
{131,139,139,"AZURE4"},
{131,111,255,"SLATEBLUE1"},
{122,103,238,"SLATEBLUE2"},
{105, 89,205,"SLATEBLUE3"},
{ 71, 60,139,"SLATEBLUE4"},
{ 72,118,255,"ROYALBLUE1"},
{ 67,110,238,"ROYALBLUE2"},
{ 58, 95,205,"ROYALBLUE3"},
{ 39, 64,139,"ROYALBLUE4"},
{  0,  0,255,"BLUE1"},
{  0,  0,238,"BLUE2"},
{  0,  0,205,"BLUE3"},
{  0,  0,139,"BLUE4"},
{ 30,144,255,"DODGERBLUE1"},
{ 28,134,238,"DODGERBLUE2"},
{ 24,116,205,"DODGERBLUE3"},
{ 16, 78,139,"DODGERBLUE4"},
{ 99,184,255,"STEELBLUE1"},
{ 92,172,238,"STEELBLUE2"},
{ 79,148,205,"STEELBLUE3"},
{ 54,100,139,"STEELBLUE4"},
{  0,191,255,"DEEPSKYBLUE1"},
{  0,178,238,"DEEPSKYBLUE2"},
{  0,154,205,"DEEPSKYBLUE3"},
{  0,104,139,"DEEPSKYBLUE4"},
{135,206,255,"SKYBLUE1"},
{126,192,238,"SKYBLUE2"},
{108,166,205,"SKYBLUE3"},
{ 74,112,139,"SKYBLUE4"},
{176,226,255,"LIGHTSKYBLUE1"},
{164,211,238,"LIGHTSKYBLUE2"},
{141,182,205,"LIGHTSKYBLUE3"},
{ 96,123,139,"LIGHTSKYBLUE4"},
{198,226,255,"SLATEGRAY1"},
{185,211,238,"SLATEGRAY2"},
{159,182,205,"SLATEGRAY3"},
{108,123,139,"SLATEGRAY4"},
{202,225,255,"LIGHTSTEELBLUE1"},
{188,210,238,"LIGHTSTEELBLUE2"},
{162,181,205,"LIGHTSTEELBLUE3"},
{110,123,139,"LIGHTSTEELBLUE4"},
{191,239,255,"LIGHTBLUE1"},
{178,223,238,"LIGHTBLUE2"},
{154,192,205,"LIGHTBLUE3"},
{104,131,139,"LIGHTBLUE4"},
{224,255,255,"LIGHTCYAN1"},
{209,238,238,"LIGHTCYAN2"},
{180,205,205,"LIGHTCYAN3"},
{122,139,139,"LIGHTCYAN4"},
{187,255,255,"PALETURQUOISE1"},
{174,238,238,"PALETURQUOISE2"},
{150,205,205,"PALETURQUOISE3"},
{102,139,139,"PALETURQUOISE4"},
{152,245,255,"CADETBLUE1"},
{142,229,238,"CADETBLUE2"},
{122,197,205,"CADETBLUE3"},
{ 83,134,139,"CADETBLUE4"},
{  0,245,255,"TURQUOISE1"},
{  0,229,238,"TURQUOISE2"},
{  0,197,205,"TURQUOISE3"},
{  0,134,139,"TURQUOISE4"},
{  0,255,255,"CYAN1"},
{  0,238,238,"CYAN2"},
{  0,205,205,"CYAN3"},
{  0,139,139,"CYAN4"},
{151,255,255,"DARKSLATEGRAY1"},
{141,238,238,"DARKSLATEGRAY2"},
{121,205,205,"DARKSLATEGRAY3"},
{ 82,139,139,"DARKSLATEGRAY4"},
{127,255,212,"AQUAMARINE1"},
{118,238,198,"AQUAMARINE2"},
{102,205,170,"AQUAMARINE3"},
{ 69,139,116,"AQUAMARINE4"},
{193,255,193,"DARKSEAGREEN1"},
{180,238,180,"DARKSEAGREEN2"},
{155,205,155,"DARKSEAGREEN3"},
{105,139,105,"DARKSEAGREEN4"},
{ 84,255,159,"SEAGREEN1"},
{ 78,238,148,"SEAGREEN2"},
{ 67,205,128,"SEAGREEN3"},
{ 46,139, 87,"SEAGREEN4"},
{154,255,154,"PALEGREEN1"},
{144,238,144,"PALEGREEN2"},
{124,205,124,"PALEGREEN3"},
{ 84,139, 84,"PALEGREEN4"},
{  0,255,127,"SPRINGGREEN1"},
{  0,238,118,"SPRINGGREEN2"},
{  0,205,102,"SPRINGGREEN3"},
{  0,139, 69,"SPRINGGREEN4"},
{  0,255,  0,"GREEN1"},
{  0,238,  0,"GREEN2"},
{  0,205,  0,"GREEN3"},
{  0,139,  0,"GREEN4"},
{127,255,  0,"CHARTREUSE1"},
{118,238,  0,"CHARTREUSE2"},
{102,205,  0,"CHARTREUSE3"},
{ 69,139,  0,"CHARTREUSE4"},
{192,255, 62,"OLIVEDRAB1"},
{179,238, 58,"OLIVEDRAB2"},
{154,205, 50,"OLIVEDRAB3"},
{105,139, 34,"OLIVEDRAB4"},
{202,255,112,"DARKOLIVEGREEN1"},
{188,238,104,"DARKOLIVEGREEN2"},
{162,205, 90,"DARKOLIVEGREEN3"},
{110,139, 61,"DARKOLIVEGREEN4"},
{255,246,143,"KHAKI1"},
{238,230,133,"KHAKI2"},
{205,198,115,"KHAKI3"},
{139,134, 78,"KHAKI4"},
{255,236,139,"LIGHTGOLDENROD1"},
{238,220,130,"LIGHTGOLDENROD2"},
{205,190,112,"LIGHTGOLDENROD3"},
{139,129, 76,"LIGHTGOLDENROD4"},
{255,255,224,"LIGHTYELLOW1"},
{238,238,209,"LIGHTYELLOW2"},
{205,205,180,"LIGHTYELLOW3"},
{139,139,122,"LIGHTYELLOW4"},
{255,255,  0,"YELLOW1"},
{238,238,  0,"YELLOW2"},
{205,205,  0,"YELLOW3"},
{139,139,  0,"YELLOW4"},
{255,215,  0,"GOLD1"},
{238,201,  0,"GOLD2"},
{205,173,  0,"GOLD3"},
{139,117,  0,"GOLD4"},
{255,193, 37,"GOLDENROD1"},
{238,180, 34,"GOLDENROD2"},
{205,155, 29,"GOLDENROD3"},
{139,105, 20,"GOLDENROD4"},
{255,185, 15,"DARKGOLDENROD1"},
{238,173, 14,"DARKGOLDENROD2"},
{205,149, 12,"DARKGOLDENROD3"},
{139,101,  8,"DARKGOLDENROD4"},
{255,193,193,"ROSYBROWN1"},
{238,180,180,"ROSYBROWN2"},
{205,155,155,"ROSYBROWN3"},
{139,105,105,"ROSYBROWN4"},
{255,106,106,"INDIANRED1"},
{238, 99, 99,"INDIANRED2"},
{205, 85, 85,"INDIANRED3"},
{139, 58, 58,"INDIANRED4"},
{255,130, 71,"SIENNA1"},
{238,121, 66,"SIENNA2"},
{205,104, 57,"SIENNA3"},
{139, 71, 38,"SIENNA4"},
{255,211,155,"BURLYWOOD1"},
{238,197,145,"BURLYWOOD2"},
{205,170,125,"BURLYWOOD3"},
{139,115, 85,"BURLYWOOD4"},
{255,231,186,"WHEAT1"},
{238,216,174,"WHEAT2"},
{205,186,150,"WHEAT3"},
{139,126,102,"WHEAT4"},
{255,165, 79,"TAN1"},
{238,154, 73,"TAN2"},
{205,133, 63,"TAN3"},
{139, 90, 43,"TAN4"},
{255,127, 36,"CHOCOLATE1"},
{238,118, 33,"CHOCOLATE2"},
{205,102, 29,"CHOCOLATE3"},
{139, 69, 19,"CHOCOLATE4"},
{255, 48, 48,"FIREBRICK1"},
{238, 44, 44,"FIREBRICK2"},
{205, 38, 38,"FIREBRICK3"},
{139, 26, 26,"FIREBRICK4"},
{255, 64, 64,"BROWN1"},
{238, 59, 59,"BROWN2"},
{205, 51, 51,"BROWN3"},
{139, 35, 35,"BROWN4"},
{255,140,105,"SALMON1"},
{238,130, 98,"SALMON2"},
{205,112, 84,"SALMON3"},
{139, 76, 57,"SALMON4"},
{255,160,122,"LIGHTSALMON1"},
{238,149,114,"LIGHTSALMON2"},
{205,129, 98,"LIGHTSALMON3"},
{139, 87, 66,"LIGHTSALMON4"},
{255,165,  0,"ORANGE1"},
{238,154,  0,"ORANGE2"},
{205,133,  0,"ORANGE3"},
{139, 90,  0,"ORANGE4"},
{255,127,  0,"DARKORANGE1"},
{238,118,  0,"DARKORANGE2"},
{205,102,  0,"DARKORANGE3"},
{139, 69,  0,"DARKORANGE4"},
{255,114, 86,"CORAL1"},
{238,106, 80,"CORAL2"},
{205, 91, 69,"CORAL3"},
{139, 62, 47,"CORAL4"},
{255, 99, 71,"TOMATO1"},
{238, 92, 66,"TOMATO2"},
{205, 79, 57,"TOMATO3"},
{139, 54, 38,"TOMATO4"},
{255, 69,  0,"ORANGERED1"},
{238, 64,  0,"ORANGERED2"},
{205, 55,  0,"ORANGERED3"},
{139, 37,  0,"ORANGERED4"},
{255,  0,  0,"RED1"},
{238,  0,  0,"RED2"},
{205,  0,  0,"RED3"},
{139,  0,  0,"RED4"},
{255, 20,147,"DEEPPINK1"},
{238, 18,137,"DEEPPINK2"},
{205, 16,118,"DEEPPINK3"},
{139, 10, 80,"DEEPPINK4"},
{255,110,180,"HOTPINK1"},
{238,106,167,"HOTPINK2"},
{205, 96,144,"HOTPINK3"},
{139, 58, 98,"HOTPINK4"},
{255,181,197,"PINK1"},
{238,169,184,"PINK2"},
{205,145,158,"PINK3"},
{139, 99,108,"PINK4"},
{255,174,185,"LIGHTPINK1"},
{238,162,173,"LIGHTPINK2"},
{205,140,149,"LIGHTPINK3"},
{139, 95,101,"LIGHTPINK4"},
{255,130,171,"PALEVIOLETRED1"},
{238,121,159,"PALEVIOLETRED2"},
{205,104,137,"PALEVIOLETRED3"},
{139, 71, 93,"PALEVIOLETRED4"},
{255, 52,179,"MAROON1"},
{238, 48,167,"MAROON2"},
{205, 41,144,"MAROON3"},
{139, 28, 98,"MAROON4"},
{255, 62,150,"VIOLETRED1"},
{238, 58,140,"VIOLETRED2"},
{205, 50,120,"VIOLETRED3"},
{139, 34, 82,"VIOLETRED4"},
{255,  0,255,"MAGENTA1"},
{238,  0,238,"MAGENTA2"},
{205,  0,205,"MAGENTA3"},
{139,  0,139,"MAGENTA4"},
{255,131,250,"ORCHID1"},
{238,122,233,"ORCHID2"},
{205,105,201,"ORCHID3"},
{139, 71,137,"ORCHID4"},
{255,187,255,"PLUM1"},
{238,174,238,"PLUM2"},
{205,150,205,"PLUM3"},
{139,102,139,"PLUM4"},
{224,102,255,"MEDIUMORCHID1"},
{209, 95,238,"MEDIUMORCHID2"},
{180, 82,205,"MEDIUMORCHID3"},
{122, 55,139,"MEDIUMORCHID4"},
{191, 62,255,"DARKORCHID1"},
{178, 58,238,"DARKORCHID2"},
{154, 50,205,"DARKORCHID3"},
{104, 34,139,"DARKORCHID4"},
{155, 48,255,"PURPLE1"},
{145, 44,238,"PURPLE2"},
{125, 38,205,"PURPLE3"},
{ 85, 26,139,"PURPLE4"},
{171,130,255,"MEDIUMPURPLE1"},
{159,121,238,"MEDIUMPURPLE2"},
{137,104,205,"MEDIUMPURPLE3"},
{ 93, 71,139,"MEDIUMPURPLE4"},
{255,225,255,"THISTLE1"},
{238,210,238,"THISTLE2"},
{205,181,205,"THISTLE3"},
{139,123,139,"THISTLE4"},
#endif
{  0,  0,  0,"BLACK"},
#ifndef NO_COLOR_NAME
{  0,  0,  0,"GRAY0"},
{  0,  0,  0,"GREY0"},
{  3,  3,  3,"GRAY1"},
{  3,  3,  3,"GREY1"},
{  5,  5,  5,"GRAY2"},
{  5,  5,  5,"GREY2"},
{  8,  8,  8,"GRAY3"},
{  8,  8,  8,"GREY3"},
{ 10, 10, 10,"GRAY4"},
{ 10, 10, 10,"GREY4"},
{ 13, 13, 13,"GRAY5"},
{ 13, 13, 13,"GREY5"},
{ 15, 15, 15,"GRAY6"},
{ 15, 15, 15,"GREY6"},
{ 18, 18, 18,"GRAY7"},
{ 18, 18, 18,"GREY7"},
{ 20, 20, 20,"GRAY8"},
{ 20, 20, 20,"GREY8"},
{ 23, 23, 23,"GRAY9"},
{ 23, 23, 23,"GREY9"},
{ 26, 26, 26,"GRAY10"},
{ 26, 26, 26,"GREY10"},
{ 28, 28, 28,"GRAY11"},
{ 28, 28, 28,"GREY11"},
{ 31, 31, 31,"GRAY12"},
{ 31, 31, 31,"GREY12"},
{ 33, 33, 33,"GRAY13"},
{ 33, 33, 33,"GREY13"},
{ 36, 36, 36,"GRAY14"},
{ 36, 36, 36,"GREY14"},
{ 38, 38, 38,"GRAY15"},
{ 38, 38, 38,"GREY15"},
{ 41, 41, 41,"GRAY16"},
{ 41, 41, 41,"GREY16"},
{ 43, 43, 43,"GRAY17"},
{ 43, 43, 43,"GREY17"},
{ 46, 46, 46,"GRAY18"},
{ 46, 46, 46,"GREY18"},
{ 48, 48, 48,"GRAY19"},
{ 48, 48, 48,"GREY19"},
{ 51, 51, 51,"GRAY20"},
{ 51, 51, 51,"GREY20"},
{ 54, 54, 54,"GRAY21"},
{ 54, 54, 54,"GREY21"},
{ 56, 56, 56,"GRAY22"},
{ 56, 56, 56,"GREY22"},
{ 59, 59, 59,"GRAY23"},
{ 59, 59, 59,"GREY23"},
{ 61, 61, 61,"GRAY24"},
{ 61, 61, 61,"GREY24"},
{ 64, 64, 64,"GRAY25"},
{ 64, 64, 64,"GREY25"},
{ 66, 66, 66,"GRAY26"},
{ 66, 66, 66,"GREY26"},
{ 69, 69, 69,"GRAY27"},
{ 69, 69, 69,"GREY27"},
{ 71, 71, 71,"GRAY28"},
{ 71, 71, 71,"GREY28"},
{ 74, 74, 74,"GRAY29"},
{ 74, 74, 74,"GREY29"},
{ 77, 77, 77,"GRAY30"},
{ 77, 77, 77,"GREY30"},
{ 79, 79, 79,"GRAY31"},
{ 79, 79, 79,"GREY31"},
{ 82, 82, 82,"GRAY32"},
{ 82, 82, 82,"GREY32"},
{ 84, 84, 84,"GRAY33"},
{ 84, 84, 84,"GREY33"},
{ 87, 87, 87,"GRAY34"},
{ 87, 87, 87,"GREY34"},
{ 89, 89, 89,"GRAY35"},
{ 89, 89, 89,"GREY35"},
{ 92, 92, 92,"GRAY36"},
{ 92, 92, 92,"GREY36"},
{ 94, 94, 94,"GRAY37"},
{ 94, 94, 94,"GREY37"},
{ 97, 97, 97,"GRAY38"},
{ 97, 97, 97,"GREY38"},
{ 99, 99, 99,"GRAY39"},
{ 99, 99, 99,"GREY39"},
{102,102,102,"GRAY40"},
{102,102,102,"GREY40"},
{105,105,105,"GRAY41"},
{105,105,105,"GREY41"},
{107,107,107,"GRAY42"},
{107,107,107,"GREY42"},
{110,110,110,"GRAY43"},
{110,110,110,"GREY43"},
{112,112,112,"GRAY44"},
{112,112,112,"GREY44"},
{115,115,115,"GRAY45"},
{115,115,115,"GREY45"},
{117,117,117,"GRAY46"},
{117,117,117,"GREY46"},
{120,120,120,"GRAY47"},
{120,120,120,"GREY47"},
{122,122,122,"GRAY48"},
{122,122,122,"GREY48"},
{125,125,125,"GRAY49"},
{125,125,125,"GREY49"},
{127,127,127,"GRAY50"},
{127,127,127,"GREY50"},
{130,130,130,"GRAY51"},
{130,130,130,"GREY51"},
{133,133,133,"GRAY52"},
{133,133,133,"GREY52"},
{135,135,135,"GRAY53"},
{135,135,135,"GREY53"},
{138,138,138,"GRAY54"},
{138,138,138,"GREY54"},
{140,140,140,"GRAY55"},
{140,140,140,"GREY55"},
{143,143,143,"GRAY56"},
{143,143,143,"GREY56"},
{145,145,145,"GRAY57"},
{145,145,145,"GREY57"},
{148,148,148,"GRAY58"},
{148,148,148,"GREY58"},
{150,150,150,"GRAY59"},
{150,150,150,"GREY59"},
{153,153,153,"GRAY60"},
{153,153,153,"GREY60"},
{156,156,156,"GRAY61"},
{156,156,156,"GREY61"},
{158,158,158,"GRAY62"},
{158,158,158,"GREY62"},
{161,161,161,"GRAY63"},
{161,161,161,"GREY63"},
{163,163,163,"GRAY64"},
{163,163,163,"GREY64"},
{166,166,166,"GRAY65"},
{166,166,166,"GREY65"},
{168,168,168,"GRAY66"},
{168,168,168,"GREY66"},
{171,171,171,"GRAY67"},
{171,171,171,"GREY67"},
{173,173,173,"GRAY68"},
{173,173,173,"GREY68"},
{176,176,176,"GRAY69"},
{176,176,176,"GREY69"},
{179,179,179,"GRAY70"},
{179,179,179,"GREY70"},
{181,181,181,"GRAY71"},
{181,181,181,"GREY71"},
{184,184,184,"GRAY72"},
{184,184,184,"GREY72"},
{186,186,186,"GRAY73"},
{186,186,186,"GREY73"},
{189,189,189,"GRAY74"},
{189,189,189,"GREY74"},
{191,191,191,"GRAY75"},
{191,191,191,"GREY75"},
{194,194,194,"GRAY76"},
{194,194,194,"GREY76"},
{196,196,196,"GRAY77"},
{196,196,196,"GREY77"},
{199,199,199,"GRAY78"},
{199,199,199,"GREY78"},
{201,201,201,"GRAY79"},
{201,201,201,"GREY79"},
{204,204,204,"GRAY80"},
{204,204,204,"GREY80"},
{207,207,207,"GRAY81"},
{207,207,207,"GREY81"},
{209,209,209,"GRAY82"},
{209,209,209,"GREY82"},
{212,212,212,"GRAY83"},
{212,212,212,"GREY83"},
{214,214,214,"GRAY84"},
{214,214,214,"GREY84"},
{217,217,217,"GRAY85"},
{217,217,217,"GREY85"},
{219,219,219,"GRAY86"},
{219,219,219,"GREY86"},
{222,222,222,"GRAY87"},
{222,222,222,"GREY87"},
{224,224,224,"GRAY88"},
{224,224,224,"GREY88"},
{227,227,227,"GRAY89"},
{227,227,227,"GREY89"},
{229,229,229,"GRAY90"},
{229,229,229,"GREY90"},
{232,232,232,"GRAY91"},
{232,232,232,"GREY91"},
{235,235,235,"GRAY92"},
{235,235,235,"GREY92"},
{237,237,237,"GRAY93"},
{237,237,237,"GREY93"},
{240,240,240,"GRAY94"},
{240,240,240,"GREY94"},
{242,242,242,"GRAY95"},
{242,242,242,"GREY95"},
{245,245,245,"GRAY96"},
{245,245,245,"GREY96"},
{247,247,247,"GRAY97"},
{247,247,247,"GREY97"},
{250,250,250,"GRAY98"},
{250,250,250,"GREY98"},
{252,252,252,"GRAY99"},
{252,252,252,"GREY99"},
{255,255,255,"GRAY100"},
{255,255,255,"GREY100"},
{169,169,169,"DARK GREY"},
{169,169,169,"DARKGREY"},
{169,169,169,"DARK GRAY"},
{169,169,169,"DARKGRAY"},
{  0,  0,139,"DARK BLUE"},
{  0,  0,139,"DARKBLUE"},
{  0,139,139,"DARK CYAN"},
{  0,139,139,"DARKCYAN"},
{139,  0,139,"DARK MAGENTA"},
{139,  0,139,"DARKMAGENTA"},
{139,  0,  0,"DARK RED"},
{139,  0,  0,"DARKRED"},
{144,238,144,"LIGHT GREEN"},
{144,238,144,"LIGHTGREEN"},
#endif
{  0,  0,  0,NULL}
};



