//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <devfb/WSDdevfbAppDev.h>
#include <devfb/WSDdevfbPrivateTimer.h>
#include <devfb/WSDdevfbTimer.h>

WSMFclassInit(WSDdevfbTimer,WSDtimer);

//250 ms 
#define _WS_INTERVAL_     250

WSDtimer* _devfbTimer_create_handler(){
  return new WSDdevfbTimer();
}

class _devfbTimer_init{
  public: _devfbTimer_init(){
//printf("_devfbTimer_init..\n");
    WSDtimer::setCreateInstanceHandler(_devfbTimer_create_handler);
  };
};

_devfbTimer_init _devfbTimer_init_run_constructor;

WSDdevfbTimer::WSDdevfbTimer(){
  _internal_timer = new WSDdevfbPrivateTimer();
  _internal_timer->setCont(True);
  _internal_timer->setRate(250);
  _internal_timer->setWorkProc(_timer_callback,this);
  _internal_timer->startTimer();
}
WSDdevfbTimer::~WSDdevfbTimer(){
  _internal_timer->stopTimer();
  delete _internal_timer;
}


void WSDdevfbTimer::_timer_callback(void* ptr){
//printf("WSDdevfbTimer::_timer_callback!!! \n");
    WSDdevfbTimer* obj = (WSDdevfbTimer*)ptr;
    obj->_clock++;
    long i;
    long num = obj->_cproc_list.getNum();

//WSMFtrace("WSDdevfbTimer::_timer_callback timer procs=%d\n",num);
    //execute the timer processes...
    for(i = 0; i < num; i++){
      timerProcRec* proc = (timerProcRec*)obj->_cproc_list.getData(i);
//WSMFtrace("WSDdevfbTimer::_timer_callback clock=%d  proc rate=%d  tm=%d\n",obj->_clock,proc->rate,proc->fclock);
      if ( ( obj->_clock % proc->rate) == proc->fclock ){
//WSMFtrace("WSDdevfbTimer::_timer_callback exec procs=0x%x\n",proc);
//printf("WSDdevfbTimer::_timer_callback exec procs=0x%x\n",proc);
//dbprintf("WSDdevfbTimer::_timer_callback %s:%d timer proc start\n",__FILE__,__LINE__);
        proc->proc(obj->_clock,proc->data);
//dbprintf("WSDdevfbTimer::_timer_callback %s:%d timer proc done.\n",__FILE__,__LINE__);
      }
    }

    num = obj->_proc_list.getNum();
    //execute the trigger processes...
    for(i = 0; i < num; i++){
      triggerProcRec* proc = (triggerProcRec*)obj->_proc_list.getData(i);
      if (( obj->_clock % proc->rate) == proc->fclock ){
        //delete this executed process from the process list
        obj->_proc_list.del(proc); 
        num = obj->_proc_list.getNum();
        i--;
//dbprintf("WSDdevfbTimer::_timer_callback %s:%d trigger proc start\n",__FILE__,__LINE__);

        proc->proc(obj->_clock,proc->data);
//dbprintf("WSDdevfbTimer::_timer_callback %s:%d trigger proc done.\n",__FILE__,__LINE__);
        proc->executed = False;
        delete proc;
      }
    }
    return;
}
