//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <devfb/devfb.h>
#include <devfb/WSDdevfbAppDev.h>
#include <WSDfont.h>
#include <WSDdev.h>
#include <devfb/WSDdevfbMouse.h>
#include <devfb/WSDdevfbColor.h>
#include <devfb/WSDdevfbDraw.h>
#include <WSClocaleSet.h>
#include <WSDfileSystem.h>
#include <devfb/WSDdeviceFont.h>
#include <devfb/devfb_dep.h>

#ifdef TE
extern "C" {
char* getcwd(char* buf,unsigned int len){
  strncpy(buf,"/SYS",len);
  return buf;
}
int chdir(const char* path){
  return 0;
}
int gettimeofday(struct timeval *__tv,
                  struct timezone *__tz){
  __tv->tv_sec = 0;
  __tv->tv_usec = 0;
  __tz->tz_minuteswest = 0;
  __tz->tz_dsttime = 0;
  return 0;
}
char* getenv(const char*){
  return NULL;
}
};
#endif

void WSGFsetRect(RECT* r,short x,short y,WSCushort w,WSCushort h){
  r->c.left = x;
  r->c.top = y;
  r->c.right = x+w;
  r->c.bottom = y+h;
}

#if 0
TF_CTX tc_to_string_ctx = NULL;
TF_CTX string_to_tc_ctx = NULL;
#endif

char* WSGFdevfbTcToString(TC* src){
  return WSGFgetString(src,WS_EN_UTF8);
}

TC* WSGFdevfbStringToTc(char* src,long* tlen){
  TC* str =  WSGFgetUCS2(src,WS_EN_UTF8);
  *tlen = WSGFstrlenUCS2(str);
  return str;
}
TC* WSGFdevfbStringToTc2(char* src,long* tlen){
  TC* str =  WSGFgetUCS2(src,WS_EN_UTF8);
  *tlen = WSGFstrlenUCS2(str);
  return str;
}

TC begin_ascii[5] = { 0xffa2,0x6,0x300,0,0x102 };
TC begin_2byte[5] = { 0xffa2,0x6,0x300,0,0 };

void _devfb_draw_string(TC* str,WSDfont* fn,GID gid,W fg,W bg,long op,long slen,
       long cur,WSCbool inter_cur,long lw,long scur1,long scur2,long x,long y){
//  WSCbool onebyte = False;
//  long sptr = 0;
//  long ptr = 0;
  long bcur = -1;
  long icur = -1;
  FSSPEC* fnt = (FSSPEC*)fn->getValue1();
//  FSSPEC* fnt_ascii = (FSSPEC*)fn->getValue3();
  WSDdeviceFontList* f = (WSDdeviceFontList*)fnt->_f;

//  long cnt = 0;
  if (inter_cur == 0 && cur > -1){
    bcur = cur;
  }
  if (inter_cur != 0 && cur > -1){
    icur = cur;
  }
  if (slen > 0){
    if (scur1 <= 0 && scur2 >= slen){
      long dw = WSGFdeviceGetStringWidth(gid, f, str, slen);
      WSGFdeviceDrawFillRect(gid,x,y - fnt->size.v,dw,fnt->size.v,fg,0);
      WSGFdeviceDrawString(gid,x,y,f,bg,str,slen);
    }else{
      WSGFdeviceDrawString(gid,x,y,f,fg,str,slen);
      if (scur1 < 0) scur1 = 0;
      if (scur2 < 0) scur2 = 0;
      if (scur1 > slen) scur1 = slen;
      if (scur2 > slen) scur2 = slen;
      if (scur1 != scur2){
        int x2 = x;
        if (scur1 > 0){
          x2 += WSGFdeviceGetStringWidth(gid, f, str, scur1);
        }
        long dw = WSGFdeviceGetStringWidth(gid, f, &str[scur1], scur2 - scur1);
        WSGFdeviceDrawFillRect(gid,x2,y - fnt->size.v,dw,fnt->size.v,fg,0);
        WSGFdeviceDrawString(gid,x2,y,f,bg,&str[scur1],scur2 -scur1);
      }
    }
    if (cur >= 0 && cur < slen + inter_cur ){
      int x2 = x;
      if (cur > 0){
        x2 += WSGFdeviceGetStringWidth(gid, f, str, cur);
      }
      if (inter_cur == False){
        long dw = WSGFdeviceGetStringWidth(gid, f, &str[cur],1);
        WSGFdeviceDrawFillRect(gid,x2,y - fnt->size.v,dw,fnt->size.v,fg,0);
        WSGFdeviceDrawString(gid,x2,y,f,bg,&str[cur],1);
      }else{
        if (str[cur] != '\n'){
          WSGFdeviceDrawFillRect(gid,x2-1,y - fnt->size.v,3,fnt->size.v,fg,0);
        }
      }
    }
  }else if (inter_cur == 1 && cur == 0){
    WSGFdeviceDrawFillRect(gid,x,y - fnt->size.v,3,fnt->size.v,fg,0);
  }



#if 0
  long diffx = 0;
  while(1){
//printf("> cnt=%d s1=%d s2=%d diffx=%d icur=%d\n",cnt,scur1,scur2,diffx,icur);
    if (str[ptr] == 0xffa2){
      if (!memcmp(begin_ascii,&str[ptr],sizeof(TC)*5)){
        long tclen = ptr - sptr;
        TC* buf = new TC[tclen+1];
        memcpy(buf,&str[sptr],sizeof(TC)*tclen);
        buf[tclen] = 0;

        if (onebyte == False){
          gset_fon(gid,fnt);
          diffx += (fnt->size.h * tclen);
        }else{
          gset_fon(gid,fnt_ascii);
          diffx += (fnt_ascii->size.h * tclen);
        }
//        if (op == G_AND){
//          if (WSGIdevfbAppDev()->haveColorMap() == False){
//            gset_chc(gid,0x10000000,0x10ffffff);
//          }else{
//            gset_chc(gid,0x10ffffff,0x10000000);
//          }
//          gdra_str(gid,buf,tclen,G_AND);
//        }else{
          if ((scur1 < cnt && cnt <= scur2) || cnt == bcur){
            PAT pat;
            pat.spat.kind = 0;
            pat.spat.hsize = 8;
            pat.spat.vsize = 8;
            pat.spat.fgcol = fg;
            pat.spat.bgcol = -1;
            pat.spat.mask = FILL100;
            RECT r;
            if (onebyte == False){
              r.c.left = x + diffx -(fnt->size.h * tclen);
            }else{
              r.c.left = x + diffx -(fnt_ascii->size.h * tclen);
            }
            r.c.right = x + diffx;
            r.c.top = y - fnt->size.v;
            r.c.bottom = y;
            gfil_rec(gid,r,&pat,0,G_STORE);
            gset_chc(gid,bg,fg);
            gdra_str(gid,buf,tclen,G_STORE);
          }else{
            if (WSGIdevfbAppDev()->haveColorMap() == False){
              gset_chc(gid,fg,0x10000000);
            }else{
              gset_chc(gid,fg,0x10ffffff);
            }
            gdra_str(gid,buf,tclen,G_OR);
          }
//        }
        delete buf;
        ptr +=5;
        sptr = ptr;
        onebyte = True;
      }else
      if (!memcmp(begin_2byte,&str[ptr],sizeof(TC)*5)){
        long tclen = ptr - sptr;
        TC* buf = new TC[tclen+1];
        memcpy(buf,&str[sptr],sizeof(TC)*tclen);
        buf[tclen] = 0;

        if (onebyte == False){
          gset_fon(gid,fnt);
          diffx += (fnt->size.h * tclen);
        }else{
          gset_fon(gid,fnt_ascii);
          diffx += (fnt_ascii->size.h * tclen);
        }
//        if (op == G_AND){
//          if (WSGIdevfbAppDev()->haveColorMap() == False){
//            gset_chc(gid,0x10000000,0x10ffffff);
//          }else{
//            gset_chc(gid,0x10ffffff,0x10000000);
//          }
//          gdra_str(gid,buf,tclen,G_AND);
//        }else{
//printf("cnt=%d s1=%d s2=%d\n",cnt,scur1,scur2);
          if ((scur1 < cnt && cnt <= scur2) || cnt == bcur){
            PAT pat;
            pat.spat.kind = 0;
            pat.spat.hsize = 8;
            pat.spat.vsize = 8;
            pat.spat.fgcol = fg;
            pat.spat.bgcol = -1;
            pat.spat.mask = FILL100;
            RECT r;
            if (onebyte == False){
              r.c.left = x + diffx -(fnt->size.h * tclen);
            }else{
              r.c.left = x + diffx -(fnt_ascii->size.h * tclen);
            }
            r.c.right = x + diffx;
            r.c.top = y - fnt->size.v;
            r.c.bottom = y;
            gfil_rec(gid,r,&pat,0,G_STORE);
            gset_chc(gid,bg,fg);
            gdra_str(gid,buf,tclen,G_STORE);
          }else{
            if (WSGIdevfbAppDev()->haveColorMap() == False){
              gset_chc(gid,fg,0x10000000);
            }else{
              gset_chc(gid,fg,0x10ffffff);
            }
            gdra_str(gid,buf,tclen,G_OR);
          }
//        }

        delete buf;
        ptr +=5;
        sptr = ptr;
        onebyte = False;
      }
    }
    if ( ((scur1 < scur2 ) && ((cnt == scur1) || (cnt == scur2)))||
         (cnt == icur && icur > 0) ||
         (cnt == bcur) ||
         (cnt+1 == bcur) ||
         (ptr == slen)){
//printf(" >> cnt=%d s1=%d s2=%d\n",cnt,scur1,scur2);
      long tclen = ptr - sptr;
      if (onebyte == False){
        gset_fon(gid,fnt);
        diffx += (fnt->size.h * tclen);
//        if (op == G_AND){
//          if (WSGIdevfbAppDev()->haveColorMap() == False){
//            gset_chc(gid,0x10000000,0x10ffffff);
//          }else{
//            gset_chc(gid,0x10ffffff,0x10000000);
//          }
//          gdra_str(gid,&str[sptr],tclen,G_AND);
//        }else{
//printf("cnt=%d s1=%d s2=%d\n",cnt,scur1,scur2);
          if ((scur1 < cnt && cnt <= scur2) || cnt == bcur){
            PAT pat;
            pat.spat.kind = 0;
            pat.spat.hsize = 8;
            pat.spat.vsize = 8;
            pat.spat.fgcol = fg;
            pat.spat.bgcol = -1;
            pat.spat.mask = FILL100;
            RECT r;
            r.c.left = x + diffx -(fnt->size.h * tclen);
            r.c.right = x + diffx;
            r.c.top = y - fnt->size.v;
            r.c.bottom = y;
            gfil_rec(gid,r,&pat,0,G_STORE);
            gset_chc(gid,bg,fg);
            gdra_str(gid,&str[sptr],tclen,G_STORE);
          }else{
            if (WSGIdevfbAppDev()->haveColorMap() == False){
              gset_chc(gid,fg,0x10000000);
            }else{
              gset_chc(gid,fg,0x10ffffff);
            }
            gdra_str(gid,&str[sptr],tclen,G_OR);
          }
//        }

      }else{
        gset_fon(gid,fnt_ascii);
        diffx += (fnt_ascii->size.h * tclen);
//        if (op == G_AND){
//          if (WSGIdevfbAppDev()->haveColorMap() == False){
//            gset_chc(gid,0x10000000,0x10ffffff);
//          }else{
//            gset_chc(gid,0x10ffffff,0x10000000);
//          }
//          gdra_str(gid,&str[sptr],tclen,G_AND);
//        }else{
//printf("cnt=%d s1=%d s2=%d\n",cnt,scur1,scur2);
          if ((scur1 < cnt && cnt <= scur2) || cnt == bcur){
            PAT pat;
            pat.spat.kind = 0;
            pat.spat.hsize = 8;
            pat.spat.vsize = 8;
            pat.spat.fgcol = fg;
            pat.spat.bgcol = -1;
            pat.spat.mask = FILL100;
            RECT r;
            r.c.left = x + diffx -(fnt_ascii->size.h * tclen);
            r.c.right = x + diffx;
            r.c.top = y - fnt->size.v;
            r.c.bottom = y;
            gfil_rec(gid,r,&pat,0,G_STORE);
            gset_chc(gid,bg,fg);
            gdra_str(gid,&str[sptr],tclen,G_STORE);
          }else{
            if (WSGIdevfbAppDev()->haveColorMap() == False){
              gset_chc(gid,fg,0x10000000);
            }else{
              gset_chc(gid,fg,0x10ffffff);
            }
            gdra_str(gid,&str[sptr],tclen,G_OR);
          }
//        }
      }
      sptr = ptr;
    }
//printf("op=%d icur=%d cnt=%d\n",op,icur,cnt);
    if (op == G_OR && icur == cnt){
      PAT pat; 
      pat.spat.kind = 0;
      pat.spat.hsize = 16;
      pat.spat.vsize = 16;
      pat.spat.fgcol = fg;
      pat.spat.bgcol = fg;
      pat.spat.mask = FILL100;
      RECT r;
      r.c.left = x + diffx;
      r.c.right = x + diffx + 3;
      r.c.top = y - fnt->size.v;
      r.c.bottom = y;
      gfil_rec(gid,r,&pat,0,G_STORE);
//printf("fill %d,%d,%d,%d\n",x,y - fnt->size.v,lw,fnt->size.v);
    }
    if (ptr == slen){
      break;
    }
    if (ptr > slen){
      break;
    }
    ptr++;
    cnt++;
  }
#endif
}


void WSGFdevfbDrawString(TC* str,WSDfont* fn,GID gid,W fg,W bg,long len,short x,short y,long cur,WSCbool inter_cur,long lw,long scur1,long scur2){
#if 0
  gset_chp(gid,x,y,(Bool)True);
  _devfb_draw_string(str,fn,gid,fg,bg,G_AND,len,cur,inter_cur,lw,scur1,scur2,x,y);
#endif
  gset_chp(gid,x,y,(Bool)True);
  _devfb_draw_string(str,fn,gid,fg,bg,G_OR,len,cur,inter_cur,lw,scur1,scur2,x,y);
}
short WSGFdevfbGetStringWidth(TC* str,WSDfont* fn,long slen){
  WSCbool onebyte = False;
  long sptr = 0;
  long ptr = 0;
  FSSPEC* fnt = (FSSPEC*)fn->getValue1();
  FSSPEC* fnt_ascii = (FSSPEC*)fn->getValue3();
//  W fdesc = fn->getValue2();
  GID fgid = WSGIdevfbAppDev()->getFontGid();
  W ret = 0;
  while(1){
    if (str[ptr] == 0xffa2){
      if (!memcmp(begin_ascii,&str[ptr],sizeof(TC)*5)){
        long tclen = ptr - sptr;
        TC* buf = new TC[tclen+1];
        memcpy(buf,&str[sptr],sizeof(TC)*tclen);
        buf[tclen] = 0;
        if (onebyte == False){
          gset_fon(fgid,fnt);
        }else{
          gset_fon(fgid,fnt_ascii);
        }
        W width = gget_stw(fgid,buf,tclen,NULL,NULL);
        ret += width;

        delete buf;
        ptr +=5;
        sptr = ptr;
        onebyte = True;
      }else
      if (!memcmp(begin_2byte,&str[ptr],sizeof(TC)*5)){
        long tclen = ptr - sptr;
        TC* buf = new TC[tclen+1];
        memcpy(buf,&str[sptr],sizeof(TC)*tclen);
        buf[tclen] = 0;
        if (onebyte == False){
          gset_fon(fgid,fnt);
        }else{
          gset_fon(fgid,fnt_ascii);
        }

        W width = gget_stw(fgid,buf,tclen,NULL,NULL);
        ret += width;

        delete buf;
        ptr +=5;
        sptr = ptr;
        onebyte = False;
      }
    }
    if (ptr == slen){
      long tclen = ptr - sptr;
      if (onebyte == False){
        gset_fon(fgid,fnt);
      }else{
        gset_fon(fgid,fnt_ascii);
      }
      W width = gget_stw(fgid,&str[sptr],tclen,NULL,NULL);
      ret += width;
      break;
    }
    if (ptr > slen){
      break;
    }
    ptr++;
  }
  return ret;
}

int main1(int argc,char** argv){
#ifdef TDBG
dbprintf("main start:\n");
WSMFtrace("main start:\n");
WSGFsetTimePoint();
#endif

//    W er = opendbox(&lnk, USER_DATA, 0x2000);
//  chg_emk(EM_ALL);
#if 0
  LINK    lnk;
  prc_inf(0, PI_LINK, (VP)&lnk, sizeof(LINK));
  dopn_dat(&lnk);
#endif

dbprintf("Main.cpp: main1() %s:%d stargetd.\n",__FILE__,__LINE__);
   WSDdev::setDraw(new WSDdevfbDraw());

   WSDappDev* app = WSGIappDev();
   WSDdevfbAppDev* devfbApp = (WSDdevfbAppDev*)app->cast("WSDdevfbAppDev");
   if (argc != 0){
     devfbApp->setInitPrm(argc,argv);
   }
   devfbApp->initialize();
   WSGIdevfbAppMouse()->initialize();

//   WSDdevfbColor::restart_blink_server();

   extern void _devfbFont_init();
   _devfbFont_init();

#ifdef TDBG
dbprintf("main init done.:%d\n",WSGFdiffTimePoint());
WSMFtrace("main init done.:%d\n",WSGFdiffTimePoint());
#endif
dbprintf("Main.cpp: main1() %s:%d done.\n",__FILE__,__LINE__);
  return 0;
}

int WSGFwsInitialize(){
  main1(0,NULL);
  return 0;
}

static long mem_initialized = False;
static char* buf[16];
static long buf_size[16];
static long buf_use[16];

char* WSGFdevfbAllocNewMemory(long size){

  if (mem_initialized == False){
    int i;
    for(i=0; i<16; i++){
      buf[i] = NULL;
      buf_size[i] = 0;
      buf_use[i] = 0;
    }
    mem_initialized = True;
  }
  int i;
  for(i=0; i<16; i++){
    if (buf[i] != NULL && buf_size[i] > size-1 && buf_use[i] == False){
      buf_use[i] = True;
      return buf[i];
    }
  }
  for(i=0; i<16; i++){
    if (buf[i] == NULL){
      buf[i] = new char[size];
      buf_size[i] = size;
      buf_use[i] = True;
      return buf[i];
    }
  }
  buf[0] = new char[size];
  buf_size[0] = size;
  buf_use[0] = True;
  return buf[i];
}
void WSGFdevfbDeleteMemory(char* ptr){

  int i;
  for(i=0; i<16; i++){
    if (buf[i] == ptr){
      buf_use[i] = False;
      return;
    }
  }
  delete ptr;
}

