//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#include <iostream>
#include <string>
#include <new>
#include <stdlib.h>
#include <signal.h>
#include "j3wunit.h"

using namespace std;

void my_handler() {
    cout << " Cannot allocate memory \n";
    abort();
}

void my_signal_handler(int i) {
    cbreak();
    echo();
#ifdef WS
    WSGFexit(0);
#else
    exit(0);
#endif
}

int main(int argc, char* argv[])
{
    char ObjectFileName[80];

    J3WCreate();
    J3WOpen(0,0,0,0);
    if (argc > 1) {
        set_new_handler(my_handler);
        signal(SIGINT, my_signal_handler);
        signal(SIGQUIT, my_signal_handler);
        if (strcmp(argv[1],"-f")==0) {
          if (strcmp(argv[2],"-")==0) strcpy(ObjectFileName,"");
          else strcpy(ObjectFileName,argv[2]);
          if (J3WNew(ObjectFileName) == 0) {
              cout << '\n' << " File not found" << '\n';
              J3WClose();
              return 0;
          }
          cout << " Execute file : " << argv[2] << '\n';
          J3WOption(0);
          J3WStart();
          while (J3WLoop() == 0) ;
        } else {
          if (strcmp(argv[1],"-")==0) strcpy(ObjectFileName,"");
          else strcpy(ObjectFileName,argv[1]);
          if (J3WNew(ObjectFileName) == 0) {
              cout << '\n' << " File not found " << '\n';
              J3WClose();
              return 0;
          }
          cout << " Execute file : " << argv[1] << '\n';
          J3WStart();
          while (J3WLoop() == 0) ;
        }
    } else {
        cout << " usage : j3w [-f] file \n ";
    }
    J3WClose();
    return 0;
}
