//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#ifdef WS
#include <stdio.h>
#else //WS
#include    <iomanip.h>
#include    <iostream>
#include    <fstream>
#endif //WS
#include    "jrlcode.h"
#ifdef WS
#include <string.h>
#include <WSCstring.h>
#include <WScom.h>
#endif //WS

void cCode::clear_code()
{
    endpos = 0;
    for(int i=0;i<codeSize;i++) code[i]=0;
}

int cCode::LoadObjFile(char *FileName)
{
dbprintf("cCode::LoadObjFile %s:%d start FileName=%s\n",__FILE__,__LINE__,FileName);
    if (strlen(FileName) == 0) {
        long n;
#ifdef WS
        scanf("%x",&n);
        printf("%d\n",n);
dbprintf("cCode::LoadObjFile %s:%d endpos=%d n=%d\n",__FILE__,__LINE__,endpos,n);
        set_code(n);
#else //WS
        while(cin >> hex >> n){
dbprintf("cCode::LoadObjFile %s:%d endpos=%d n=%d\n",__FILE__,__LINE__,endpos,n);
          set_code(n);
        }
#endif //WS
    } else {
#ifdef WS
        WSCstring* str = WSGFreadTextFile(FileName);
        if (str == NULL){
          return 1;
        }
        while(str->eof() == False){
          WSCstring line = str->gets();
          long val;
          sscanf(line.getString(),"%x",&val);
          set_code(val);
        }
        delete str;

#else //WS
        ifstream source(FileName,ios::in);
dbprintf("cCode::LoadObjFile %s:%d done0 source=%d\n",__FILE__,__LINE__,source);

        if (!source) {
           cerr << "Cannot open source file " << FileName << " for input\n";
dbprintf("cCode::LoadObjFile %s:%d done0 endpos=%d\n",__FILE__,__LINE__,endpos);
           return 1;
        }

        unsigned long n;
        while(source >> hex >> n){
dbprintf("cCode::LoadObjFile %s:%d endpos=%d n=%d\n",__FILE__,__LINE__,endpos,n);
          set_code(n);
        }
        source.close();
#endif //WS
    }
    if (endpos){
dbprintf("cCode::LoadObjFile %s:%d done1 endpos=%d\n",__FILE__,__LINE__,endpos);
      return 0;
    }else{
dbprintf("cCode::LoadObjFile %s:%d done2 endpos=%d\n",__FILE__,__LINE__,endpos);
      return 1;
    }
}

int cCode::SaveObjFile(char *FileName)
{
    if (strlen(FileName) == 0) {
        for(int i=0; i<endpos; i++)
#ifdef WS
        printf("%x\n",code[i]);
#else //WS
        cout << hex << code[i] << '\n';
#endif //WS
    } else {
#ifdef WS
        WSCstring str;
        char buf[128];
        for(int i=0; i<endpos; i++){
          sprintf(buf,"%x\n",(unsigned long)code[i]);
          str << buf;
        }
        WSGFreplaceTextFile(FileName,str.getString(),True);        
#else //WS
        ofstream dest;
        dest.open(FileName);

        if (!dest) {
           cerr << "Cannot open destination file " << FileName << " for output\n";
           return 1;
        }

        for(int i=0; i<endpos; i++)
          dest << hex << (unsigned long)code[i] << '\n';
        dest.close();
#endif //WS
    }
    return 0;
}

