//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#ifndef _WSWINCE
#include <fcntl.h>
#endif
#include <win/WSDfileSerialize.h>
#include <WSClocaleSet.h>
#include <WSCconductor.h>
#include <WSCserializeData.h>

#define WS_SRL_TYPE "FILE"

WSMFclassInit(WSDfileSerialize,WSDserialize);

class  _fserialize_init {
  public:
  _fserialize_init(){
    WSGIconductor()->addSerialize(new WSDfileSerialize);
  };
};
static _fserialize_init _fserialize_init_execute;

WSDfileSerialize::WSDfileSerialize(){
  _fp = NULL;
}
WSDfileSerialize::~WSDfileSerialize(){}

long WSDfileSerialize::endTransaction(){
  if (_need_save == False){
    return WS_NO_ERR;
  }
  _close();
  long ret = _open(_field.getString(),WS_WRITE);
  if (ret != WS_NO_ERR){
WSMFtrace("WSDfileSerialize::endTransaction   open error.\n");
    return ret;
  }

  _need_save = False;
  _seek(0);
  long num = _data_list.getNum();
  char tmp[4];
  WSGIbinType()->memcpy4b(tmp,num);
  _write(tmp,sizeof(char)*4);

  setUnderTransaction(False);

  long i;
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    dt->write(this);
  }
  for(i=0; i< num; i++){
    WSCserializeData* dt = (WSCserializeData*)_data_list.getData(i);
    delete dt;
  }
  _data_list.clear();
  _close();
  return WS_NO_ERR;
}
long WSDfileSerialize::_open(char* name,long mode){
  char* md = "r";
  if (mode == WS_WRITE){
    md = "w";
  }else if (mode == WS_RW){
    md = "r+";
  }

  if (_fp  != NULL){
    fclose(_fp);
  }

  char buffer1[1024];
  if (!strcmp("",_path.getString())){
    strcpy(buffer1,name);
  }else{
    sprintf(buffer1,"%s/%s",_path.getString(),name);
  }
  WSCstring fname(buffer1);

  _fp = fopen(fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),md);
  if (_fp == NULL && mode == WS_RW ){
    md = "a";
    _fp = fopen(fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),md);
  }

  if (_fp == NULL){
WSMFtrace("WSDfileSerialize::_open  open error.   file=%s mode=%s\n",buffer1,md);
    return WS_ERR_CNSRL;
  }else{
    _seek(0);
    return WS_NO_ERR;
  }
}
long WSDfileSerialize::_close(){
  if (_fp  != NULL){
    fclose(_fp);
    _fp = NULL;
  }
  return WS_NO_ERR;
}
long WSDfileSerialize::_read(void* buf,long len){
  if (_fp == NULL){
    return 0;
  }
WSMFtrace("WSDfileSerialize::_read() len=%d\n",len);
  return fread(buf,1,len,_fp);
}
long WSDfileSerialize::_write(void* buf,long len){
  if (_fp == NULL){
    return 0;
  }
  return fwrite(buf,1,len,_fp);
}
long WSDfileSerialize::_tell(){
  if (_fp == NULL){
WSMFtrace("WSDfileSerialize::_tell error file=NULL\n");
    return 0;
  }
  return ftell(_fp);
}
long WSDfileSerialize::_size(){
  if (_fp == NULL){
WSMFtrace("WSDfileSerialize::_tell error file=NULL\n");
    return 0;
  }
  long pos = ftell(_fp);
  fseek(_fp,0,SEEK_END);
  long ret = ftell(_fp);
  fseek(_fp,pos,SEEK_SET);
  return ret;
}
long WSDfileSerialize::_seek(long addr){
  if (_fp == NULL){
    return 0;
  }
  fseek(_fp,addr,SEEK_SET);
  return WS_NO_ERR;
}
long WSDfileSerialize::_seek_end(){
  if (_fp == NULL){
    return 0;
  }
  fseek(_fp,0,SEEK_END);
  return WS_NO_ERR;
}
long WSDfileSerialize::_seek_set(){
   return _seek(0);
}
long WSDfileSerialize::_eof(){
  if (_fp == NULL){
    return 0;
  }
  return feof(_fp);
}
WSCbool WSDfileSerialize::type(char* tp){
  if ( !strcmp(tp,WS_SRL_TYPE) ){
    return True;
  }else{
    return False;
  }
}
WSDserialize* WSDfileSerialize::createSerialize(){
  return new WSDfileSerialize;
}
