//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <win/WSDwinFS.h>
#include <WSCstring.h>
#include <WSDenv.h>
#ifndef _WSWINCE
#include <unistd.h>
#include <sys/stat.h>
#endif
#include <WSClistData.h>
#include <WSClocaleSet.h>
#include <Winnetwk.h>

WSDfileSystem* _win_fs_chandler(){
  return new WSDwinFS();
}
void WSGFinitWinFileSystem(){
static long _init = 0;
  if (_init != 0){
    return;
  }
  _init = 1;
extern void WSGFwinEnvInit();
  WSGFwinEnvInit();
  WSDfileSystem::setCreateInstanceHandler(_win_fs_chandler);
}
class _win_fs_init{
  public: _win_fs_init(){
extern void WSGFwinEnvInit();
    WSGFwinEnvInit();
    WSDfileSystem::setCreateInstanceHandler(_win_fs_chandler);
  };
};
_win_fs_init _win_fs_init_execute;

WSDwinFS::WSDwinFS(){}
WSDwinFS::~WSDwinFS(){}

char* WSDwinFS::adjustFileName(char* src){
static char  buf[1024];

  WSCstring str( WSGIappEnvironment()->getPlaneString(src) );
  str.delHeadSpace();
  str.replaceString("\n","",0);
  str.replaceString("\\","/",0);

  strncpy(buf,str.getString(),1023);
  return buf;
}

long WSDwinFS::rename(char* old_name,char* new_name){
  WSCstring name1(old_name);
  WSCstring name2(new_name);
#ifndef _WSWINCE
  remove(name2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
  long ret = ::rename(name1.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
                      name2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
  if (ret == 0){
    return WS_NO_ERR;
  }
#else
  WSCushort* str1 = WSGFgetUCS2(name1.getString(),WS_EN_DEFAULT);
  WSCushort* str2 = WSGFgetUCS2(name2.getString(),WS_EN_DEFAULT);
  DeleteFile(str2);
  long ret = ::MoveFile(str1,str2);
  delete str1;
  delete str2;
  if (ret != 0){
    return WS_NO_ERR;
  }
#endif
  return WS_ERR;
}

long WSDwinFS::deleteFile(char* name){
  WSCstring fname(name);
  char* fn = fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
#ifndef _WSWINCE
  if (remove(fn) == 0){
    return WS_NO_ERR;
  }
#else
  WSCushort* str1 = WSGFgetUCS2(fn,WS_EN_DEFAULT);
  if (DeleteFile(str1)){
    delete str1;
    return WS_NO_ERR;
  }
  delete str1;
#endif
  return WS_ERR;
}

long WSDwinFS::createDir(char* name){
  WSCstring fname(name);
  char* fn = fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
#ifndef _WSWINCE
  if (_mkdir(fn) == 0){
    return WS_NO_ERR;
  }
#else
  WSCushort* str1 = WSGFgetUCS2(fn,WS_EN_DEFAULT);
  if (CreateDirectory(str1,NULL) != 0){
    delete str1;
    return WS_NO_ERR;
  }
  delete str1;
#endif
  return WS_ERR;
}

long WSDwinFS::deleteDir(char* name){
  WSCstring fname(name);
  char* fn = fname.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
#ifndef _WSWINCE
  if (rmdir(fn) == 0){
    return WS_NO_ERR;
  }
#else
  WSCushort* str1 = WSGFgetUCS2(fn,WS_EN_DEFAULT);
  if (RemoveDirectory(str1) != 0){
    delete str1;
    return WS_NO_ERR;
  }
  delete str1;
#endif
  return WS_ERR;
}

#define WS_CANNOT 0
#define WS_DIR 1
#define WS_WRITABLE_FILE 2
#define WS_READONLY_FILE 3
#if 0
static long chk_file(char* file){
  struct _stat sret;
  if (_stat(file,&sret) == -1){
    return 0;
  }else if ((sret.st_mode & S_IFMT) == S_IFDIR){
    return WS_DIR;
  }else if (!(sret.st_mode & S_IFREG) || _access(file,2 /*W_OK*/) == -1){
    return WS_READONLY_FILE;
  }
  return WS_WRITABLE_FILE;
}
#endif
long WSDwinFS::check(char* fname){
#ifndef _WSWINCE
  WSCstring name(fname);
  char* fn = name.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
  struct _stat sret;
  long ret = 0;
  if (_stat(fn,&sret) == -1){
    return 0;
  }
  if ((sret.st_mode & S_IFMT) == S_IFDIR){
    ret |= WS_FS_DIR;
  }
  if (sret.st_mode & S_IFREG){
    ret |= WS_FS_FILE;
  }
  if ( _access(fn,W_OK) == -1){
    ret |= WS_FS_READONLY;
  }
  return ret;
#else
  return 0;
#endif
}

WSClistData* WSDwinFS::showNetDir(char* dn,char* prvn){
//printf("WSDwinFS::showNetDir 0x%x 0x%x\n",dname,prvname);
  WSCstring name1(dn);
  char* dname = name1.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
  WSCstring name2(prvn);
  char* prvname = name2.getString(WSGIappLocaleSet()->getSystemLocaleEncoding());
  if (prvname != NULL && dname == NULL){
    return showDir(dn);
  }
  if (dname != NULL){
//printf("WSDwinFS::showNetDir dname=%s\n",dn);
  }
  if (prvname != NULL){
//printf("WSDwinFS::showNetDir prvname=%s\n",prvn);
  }
  NETRESOURCE  NetResource;
  NETRESOURCE  lpBuffer[128];
  HANDLE       lphEnum;
  DWORD        lpcCount;
  DWORD        lpBufferSize;
  DWORD        re, i;
#ifndef _WSWINCE
  char  lpBuffer2[4096];
#else
  WSCushort* lpBuff=NULL;
  WSCushort* lpBuff2=NULL;
#endif

  lphEnum  = 0;
  lpcCount = 0xFFFFFFF;
  lpBufferSize = sizeof(lpBuffer);

  NetResource.dwScope		= RESOURCE_GLOBALNET;
  NetResource.dwType		= RESOURCETYPE_ANY;
  NetResource.dwDisplayType	= RESOURCEDISPLAYTYPE_DOMAIN;
  NetResource.dwUsage		= RESOURCEUSAGE_CONTAINER;
  if (dname != NULL ){
    WSCstring str(dname);
    str.replaceString("/","\\",0);
#ifndef _WSWINCE
    strcpy(lpBuffer2,str.getString());
    NetResource.lpRemoteName = lpBuffer2;
#else
    lpBuff = WSGFgetUCS2(str.getString(),WS_EN_DEFAULT);
    NetResource.lpRemoteName = lpBuff;
#endif
  }else{
#ifndef _WSWINCE
    NetResource.lpRemoteName = dname;
#else
    lpBuff = WSGFgetUCS2(name1.getString(),WS_EN_DEFAULT);
    NetResource.lpRemoteName = lpBuff;
#endif
  }
#ifndef _WSWINCE
  NetResource.lpProvider		= prvname;
#else
  lpBuff2 = WSGFgetUCS2(name2.getString(),WS_EN_DEFAULT);
  NetResource.lpProvider		= lpBuff2;
#endif
  re = WNetOpenEnum(RESOURCE_GLOBALNET, RESOURCETYPE_ANY, 0, &NetResource, &lphEnum);
  if (re != 0){
#ifdef _WSWINCE
    if (lpBuff != NULL){
      delete lpBuff;
    }
    if (lpBuff2 != NULL){
      delete lpBuff2;
    }
#endif
    return NULL;
  }

  WSClistData* ret = NULL;
  for (;;) {
    re = WNetEnumResource(lphEnum, &lpcCount, &lpBuffer[0], &lpBufferSize);
    if (re == ERROR_NO_MORE_ITEMS){
      break;
    }else if (re != NO_ERROR){
      break;
    }
    for (i = 0;; i++) {
      if (i >= 128){
        break;
      }else if (i >= lpcCount){
        break;
      }

      WSCstring str;
#ifndef _WSWINCE
      str.setString(lpBuffer[i].lpRemoteName,WSGIappLocaleSet()->getSystemLocaleEncoding());
#else
      char* tmpstr = WSGFgetString(lpBuffer[i].lpRemoteName,WS_EN_DEFAULT);
      str.setString(tmpstr);
      delete tmpstr;
#endif
      str.replaceString("\\","/",0);
      if (dname != NULL ){
        if (!strncmp(dname,"//",2)){
          WSCstring tmp(dname);
          tmp << "/";
          str.replaceString(tmp,"",1);
        }else
        if (!strncmp(dname,"\\\\",2)){
          WSCstring tmp(dname);
          tmp.replaceString("\\\\","//",1);
          tmp << "/";
          str.replaceString(tmp,"",1);
        }
      }
      if (ret == NULL){
        ret = new WSClistData();
      }
      ret->add((void*)WSGFstrdup(str.getString(WSGIappLocaleSet()->getSystemLocaleEncoding())));
    }
    break;
  }
  WNetCloseEnum(lphEnum);
#ifdef _WSWINCE
    if (lpBuff != NULL){
      delete lpBuff;
    }
    if (lpBuff2 != NULL){
      delete lpBuff2;
    }
#endif
  return ret;
}
WSClistData* WSDwinFS::showDir(char* name){
  WSClistData* ret = new WSClistData;
  WIN32_FIND_DATA fd;
  WSCstring str;
  str.setString(name,WS_EN_DEFAULT);
#ifndef _WSWINCE
  if (!strcmp("",name)){
    DWORD drives = GetLogicalDrives();
    unsigned int i;
    for(i=0; i<sizeof(drives)*8;i++){
      char buf[3];
      if (drives & (1<<i)){
        buf[0] = 'A'+i;
        buf[1] = ':';
        buf[2] = 0;
        ret->add((void*)WSGFstrdup(buf));
      }
    }
    return ret;
  }
#endif
  str << "/*";
  str.replaceString("/","\\",0);
#ifndef _WSWINCE
  HANDLE hFind = FindFirstFile(
             str.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()), &fd);
#else
  WSCushort* tmpstr = WSGFgetUCS2(str,WS_EN_DEFAULT);
  HANDLE hFind = FindFirstFile(tmpstr,&fd);
  delete tmpstr;
#endif
  while( hFind != INVALID_HANDLE_VALUE ){
    if ( (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0){
#ifndef _WSWINCE
       if (!strcmp(fd.cFileName,".") || !strcmp(fd.cFileName,"..")){
         // reject...
       }else{
         long i;
         long num = ret->getNum();
         WSCbool add_flag = False;
         for(i=0; i<num; i++){
           char* item = (char*)(*ret)[i];
           if (strcmp(item,fd.cFileName) > 0){
             WSCstring str;
             str.setString(fd.cFileName,WSGIappLocaleSet()->getSystemLocaleEncoding());
             ret->add((void*)WSGFstrdup(str.getString(WS_EN_DEFAULT)),i);
             add_flag = True;
             break;
           }
         }
         if (add_flag == False){
           str.setString(fd.cFileName,WSGIappLocaleSet()->getSystemLocaleEncoding());
           ret->add((void*)WSGFstrdup(str.getString(WS_EN_DEFAULT)));
           add_flag = True;
         }
       }
#else
       char* tmpst = WSGFgetString(fd.cFileName,WS_EN_DEFAULT);
       WSCstring tmps(tmpst);
       delete tmpst;
       if (!strcmp(tmps.getString(),".") || !strcmp(tmps.getString(),"..")){
         // reject...
       }else{
         long i;
         long num = ret->getNum();
         WSCbool add_flag = False;
         for(i=0; i<num; i++){
           char* item = (char*)(*ret)[i];
           if (strcmp(item,tmps) > 0){
             ret->add((void*)WSGFstrdup(tmps.getString(WS_EN_DEFAULT)),i);
             add_flag = True;
             break;
           }
         }
         if (add_flag == False){
           ret->add((void*)WSGFstrdup(tmps.getString(WS_EN_DEFAULT)));
           add_flag = True;
         }
       }

#endif
    }
    WSCbool exist = FindNextFile(hFind,&fd);
    if (exist == False){
      break;
    }
  }
  return ret;
}
WSClistData* WSDwinFS::showFile(char* name){
  WSClistData* ret = new WSClistData();
  WIN32_FIND_DATA fd;
  WSCstring str;
  str.setString(name,WS_EN_DEFAULT);
  str << "/*";
  str.replaceString("/","\\",0);
#ifndef _WSWINCE
  HANDLE hFind = FindFirstFile(
             str.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()), &fd);
#else
  WSCushort* tmpstr = WSGFgetUCS2(name,WS_EN_DEFAULT);
  HANDLE hFind = FindFirstFile(tmpstr,&fd);
  delete tmpstr;
#endif
  while( hFind != INVALID_HANDLE_VALUE ){
    if ( (fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) == 0){
      long i;
      long num = ret->getNum();
      WSCbool add_flag = False;
#ifndef _WSWINCE
      for(i=0; i<num; i++){
        char* item = (char*)(*ret)[i];
        if (strcmp(item,fd.cFileName)>0){
          WSCstring str;
          str.setString(fd.cFileName,WSGIappLocaleSet()->getSystemLocaleEncoding());
          ret->add((void*)WSGFstrdup(str.getString(WS_EN_DEFAULT)),i);
          add_flag = True;
          break;
        }
      }
      if (add_flag == False){
        WSCstring str;
        str.setString(fd.cFileName,WSGIappLocaleSet()->getSystemLocaleEncoding());
        ret->add((void*)WSGFstrdup(str.getString(WS_EN_DEFAULT)));
      }
#else
      char* tmpst = WSGFgetString(fd.cFileName,WS_EN_DEFAULT);
      WSCstring tmps(tmpst,WS_EN_DEFAULT);
      delete tmpst;
      for(i=0; i<num; i++){
        char* item = (char*)(*ret)[i];
        if (strcmp(item,tmps)>0){
          ret->add((void*)WSGFstrdup(tmps.getString(WS_EN_DEFAULT)),i);
          add_flag = True;
          break;
        }
      }
      if (add_flag == False){
        ret->add((void*)WSGFstrdup(tmps.getString(WS_EN_DEFAULT)));
      }
#endif
    }
    WSCbool exist = FindNextFile(hFind,&fd);
    if (exist == False){
      break;
    }
  }
  return ret;
}
