//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <WScom.h>
#include <win/WSDwinThread.h>
#include <win/WSDwinAppDev.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDwinThread,WSDthread);

WSDthread* _win_th_chandler(){
  return new WSDwinThread;
}

void WSGFinitializeWinThread(){
    WSDthread::setCreateInstanceHandler((void*)_win_th_chandler);
}

class _win_thread_init {
  public: _win_thread_init(){
    WSDthread::setCreateInstanceHandler((void*)_win_th_chandler);
  };
};
_win_thread_init  _win_th_init_execute;

WSDwinThread::WSDwinThread(){
  _thr = NULL;
  _tid = 0;
  InitializeCriticalSection(&_cs);
}

WSDwinThread::~WSDwinThread(){
  if (_thr != 0){
    CloseHandle(_thr);
  }
  _tid = 0;
}

long WSDwinThread::createThread(void* data){
  EnterCriticalSection(&_cs);
  if (_proc == 0){
    LeaveCriticalSection(&_cs);
    return WS_ERR;
  }
  if (_thr != 0){
    LeaveCriticalSection(&_cs);
    return WS_ERR;
  }
  _ptr = data;
  _thr = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)_thread_start_handler,this,0,(DWORD*)&_tid);
  if (_thr == 0){
    _tid = 0;
  }
  LeaveCriticalSection(&_cs);
  return WS_NO_ERR;
}

DWORD WSDwinThread::_thread_start_handler(void* ptr){
  WSDwinThread* _this = (WSDwinThread*)ptr;
  void* ret = NULL;
  if (_this->_proc != NULL){
    ret = _this->_proc(_this,_this->_ptr);
  }
  EnterCriticalSection(&_this->_cs);
  _this->_thr = 0;
  _this->_tid = 0;
  LeaveCriticalSection(&_this->_cs);
  ExitThread((long unsigned int)ret);
  return 0;
}

long WSDwinThread::detachThread(){
  return WS_NO_ERR;
}
long WSDwinThread::terminateThread(){
  if (_thr == 0){
    return WS_ERR;  
  }
  EnterCriticalSection(&_cs);
  if (_thr != 0){
    TerminateThread(_thr,0);
  }
  LeaveCriticalSection(&_cs);
  return WS_ERR;  
}
long WSDwinThread::joinThread(void** retval){
  if (_thr != 0){
    int ret = WaitForSingleObject(_thr,INFINITE);
    if (ret != WAIT_FAILED){
      GetExitCodeThread(_thr,(DWORD*)retval);
      return WS_NO_ERR;
    }
    return WS_ERR;
  }
  return WS_ERR;
}
long WSDwinThread::getStatus(){
  if (_thr == 0){
    return WS_THREAD_STOPPED;
  }
  return WS_THREAD_RUNNING;
}
long WSDwinThread::execCallback(void* data){
  _callback_data = data;
  DWORD result;
  SendMessageTimeout(WSGIwinAppDev()->getHWND(),
                     WM_USER,(WPARAM)WS_WIN_THR,(LPARAM)this,
                     SMTO_NORMAL,1000,&result);
  return WS_NO_ERR;
}

