//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <windows.h>
#include <win/WSwincom.h>
#include <win/WSDwinwinDev.h>
#include <win/WSDwinAppDev.h>
#include <WSCdevice.h>
//#include <WSDwindraw.h>
#include <WSCimageSet.h>
#include <WSCcolorSet.h>
#include <WSDtimer.h>
#include <WSCbase.h>
#include <WSDmouse.h>
#include <WSClocaleSet.h>
#define DEBUG

#ifdef _WSWINCE
#define strdup _strdup
#endif
WSMFclassInit(WSDwinwinDev,WSDwinformDev);
WSDdev* _wsdwinwindev_init_(){
  return new WSDwinwinDev();
}

class _WSDwinwinDev_init_ {
  public:_WSDwinwinDev_init_(){
     WSGIappDevice()->setCreateHandler("windowDev",_wsdwinwindev_init_);
  };
};
static _WSDwinwinDev_init_ _init_to_run_WSDwinwinDev_;
//static Atom wm_protocols = 0;
//static Atom wm_delete = 0;

WSDwinwinDev::WSDwinwinDev(){
dbprintf("WSDwinwinDev::WSDwinwinDev %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
//  _shell  = 0;
#ifndef _WSWINCE
  _style = WS_OVERLAPPEDWINDOW;
#else
  _style = 0;
#endif
//  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
  _style_ex = 0;
  _resize_sequence = False;
  _shell  = 0;
  _wnd  = 0;
  _title_bar_style = WS_FULL_TITLE;
  _no_frame = 0;
  _no_frame_first_time = 0;
  _requested_top = 0;
  _popup_parent = False;
  _float_on_top = 0;
  _modal = 0;
  _diff_w = -1;
  _diff_h = -1;
  _x_now = -1;
  _y_now = -1;
  _destroyed_by_method = 0;
  _title_string = 0;
dbprintf("WSDwinwinDev::WSDwinwinDev %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
}

WSDwinwinDev::~WSDwinwinDev(){
dbprintf("WSDwinwinDev::~WSDwinwinDev %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
  if ( _title_string != NULL){
    delete _title_string;
    _title_string = 0;
  }
  destroyWindow();
dbprintf("WSDwinwinDev::~WSDwinwinDev %s:%d done this=0x%x\n",__FILE__,__LINE__,this);
}

WSDdev* WSDwinwinDev::getVisibleParentDev(){
  return this;
}

long WSDwinwinDev::setValue(long kind,void* data){
  WSDwindowDev::setValue(kind,data);

  char val;
//  long vl;
  WSDcolor* color;
  WSDimage* image;
//  XWindowChanges wc;
//  WSCbase* pparent;
//  WSDwinwinDev*  pdev;
//  HWND    pwidget;
//  HWND pwnd;
//  WSCbool   fl;
  RECT p;
  WSCstring tmpstr;
  long diff_w = _diff_w;
  long diff_h = _diff_h;
  if (diff_w < 0){
    diff_w = 0;
  }
  if (diff_h < 0){
    diff_h = 0;
  }
  switch(kind){
    case WSDEV_X: 
//             if (getVisible() == False){
//               _diff_x = 0;
//             }
             if (_wnd != 0){
               if (getVisible() != False){
                 GetWindowRect(_wnd,&p);
                 p.left = *(short*)data;
//WSMFtrace("WSDwinwinDev::setValue X 0x%x %d %d %d %d  XXZZs1\n",this,p.left,p.top,p.right - p.left,p.bottom - p.top);
                 if (_resize_sequence != False && *(short*)data == _x_now){
                   break;
                 }
#if 0
                 MoveWindow(_shell,p.left,p.top,
                            p.right  - p.left + diff_w,
                            p.bottom  - p.top + diff_h, True);
#endif
//WSMFtrace("WSDwinwinDev::setValue X 0x%x %d %d setpos. XXZZs1\n",this,p.left,p.top);
//printf("WSDwinwinDev::setValue X 0x%x x,y=%d,%d setpos=%d,%d. XXZZs1\n",this,p.left,p.top,p.left - _diff_x,p.top);
                 SetWindowPos(_shell,NULL,p.left - _diff_x,p.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
               }
             }
             break;
    case WSDEV_Y:
//             if (getVisible() == False){
//               _diff_y = 0;
//             }
             if (_wnd != 0){
               if (getVisible() != False){
                 GetWindowRect(_wnd,&p);
                 p.top = *(short*)data;
//printf("WSDwinwinDev::setValue Y 0x%x %d %d %d %d\n",this,p.left,p.top,p.right - p.left,p.bottom - p.top);
                 if (_resize_sequence != False && *(short*)data == _y_now){
                   break;
                 }
#if 0
                 MoveWindow(_shell,p.left,p.top,
                            p.right  - p.left + diff_w,
                            p.bottom  - p.top + diff_h, True);
#endif
//WSMFtrace("WSDwinwinDev::setValue Y 0x%x %d %d setpos. XXZZs1\n",this,p.left,p.top);
                 SetWindowPos(_shell,NULL,p.left,p.top,0,0,SWP_NOSIZE|SWP_NOZORDER);
               }
             }
             break;
    case WSDEV_WIDTH:
             if (_wnd != 0){
               if (getVisible() != False && *(WSCushort*)data > 0){
//               if (*(WSCushort*)data > 0){
                 GetClientRect(_wnd,&p);
                 p.right = p.left + *(short*)data;
//WSMFtrace("WSDwinwinDev::setValue diffw,h=%d,%d  XXZZq2v\n",_diff_w,_diff_h);
//WSMFtrace("WSDwinwinDev::setValue W 0x%x %d %d %d %d  XXZZq2v\n",this,p.left,p.top,p.right - p.left,p.bottom - p.top);
#if 0
                 MoveWindow(_wnd,0,0,
                            p.right  - p.left,
                            p.bottom  - p.top, True);
#endif
                 MoveWindow(_wnd,0,0,
                            p.right  - p.left,
                            _w_h, True);
                 if (_resize_sequence != False && *(short*)data == _w_now){
                   break;
                 }
//WSMFtrace("WSDwinwinDev::setValue W 0x%x %d %d setsize. XXZZs1\n",this, p.right  - p.left + diff_w, p.bottom  - p.top + diff_h);
#if 0
                 MoveWindow(_shell,_w_x,_w_y,
                            p.right  - p.left + diff_w,
                            p.bottom  - p.top + diff_h, True);
#endif
                 MoveWindow(_shell,_w_x,_w_y,
                            _w_w + diff_w,
                            _w_h + diff_h, True);
               }
             }
             break;
    case WSDEV_HEIGHT:
             if (_wnd != 0){
               if (getVisible() != False && *(WSCushort*)data > 0){
//               if (*(WSCushort*)data > 0){
                 GetClientRect(_wnd,&p);
                 p.bottom = p.top + *(short*)data;
//WSMFtrace("WSDwinwinDev::setValue diffw,h=%d,%d  XXZZq2v\n",_diff_w,_diff_h);
//WSMFtrace("WSDwinwinDev::setValue H 0x%x %d %d %d %d  XXZZq2v\n",this,p.left,p.top,p.right - p.left,p.bottom - p.top);
#if 0
                 MoveWindow(_wnd,0,0,
                            p.right  - p.left,
                            p.bottom  - p.top, True);
#endif
                 MoveWindow(_wnd,0,0,
                            _w_w,
                            _w_h, True);
                 if (_resize_sequence != False && *(short*)data == _h_now){
                   break;
                 }
//WSMFtrace("WSDwinwinDev::setValue H 0x%x %d %d setsize. XXZZs1\n",this, p.right  - p.left + diff_w, p.bottom  - p.top + diff_h);
#if 0
                 MoveWindow(_shell,_w_x,_w_y,
                            p.right  - p.left + diff_w,
                            p.bottom  - p.top + diff_h, True);
#endif
                 MoveWindow(_shell,_w_x,_w_y,
                            _w_w + diff_w,
                            _w_h + diff_h, True);
               }
             }
             break;
    case WSDEV_BACKCOLOR:
             _back_cno = *(short*)data;
             color = WSGIappColorSet()->getColor(*(short*)data);
             if (color != NULL){
               _bg_cref = (COLORREF)color->getValue1();
             }
             if ( _wnd != (HWND)0){
               setExposed(False);
               invalidate(TRUE);
             }
             break;
    case WSDEV_BACK_PIXMAP:
             _back_pixno = *(short*)data;
//printf("WSDwinwinDev::setValue BACK_PIXMAP here  ino=%d\n",_back_pixno);
             if (*(short*)data == -1 ){
               _bg_image = 0;
             }else{
               image = WSGIappImageSet()->getImage(*(short*)data);
//printf("image=0x%x\n",image);
               if (image != NULL){
                 if (image->getValue1() == -1){
                   _bg_image = 0;
                 }else{
                   _bg_image = (HBITMAP)image->getValue1();
//printf("WSDwinwinDev::setValue BACK_PIXMAP 0x%x\n",_bg_image);
                 }
               }
             }
             if (_wnd != 0){
               setExposed(False);
               invalidate(TRUE);
             }
             break;
    case WSDEV_TITLE_BAR:
             _diff_x = -1;
             _diff_y = -1;
             val = _title_bar_style;
             if (*(char*)data < 0 || *(char*)data > 4){
               _title_bar_style = 0;
             }else{
               _title_bar_style = *(char*)data;
             }
//printf("WSDwinwinDev::setValue XXZZtt1 shell=0x%x t=%d t-bk=%d\n",_shell,_title_bar_style,val);
             if (_title_bar_style == WS_NO_TITLE){ 
                  _style = WS_POPUP;
                  _style_ex = 0;
//                  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
//                  SetWindowLong(_shell,GWL_EXSTYLE,WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
             }else
             if (_title_bar_style == WS_FULL_TITLE){ 
#ifndef _WSWINCE
                  _style = WS_OVERLAPPEDWINDOW;
#else
                  _style = 0;
#endif
                  _style_ex = 0;
//                  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
//                  SetWindowLong(_shell,GWL_EXSTYLE,WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
             }else
             if (_title_bar_style == WS_ONLY_TITLE){ 
                  _style = WS_CAPTION | WS_BORDER;
                  _style_ex = 0;
//                  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
//                  SetWindowLong(_shell,GWL_EXSTYLE,WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
             }else
             if (_title_bar_style == WS_MINI_BTN){ 
                  _style = WS_CAPTION | WS_BORDER | WS_SYSMENU | WS_MINIMIZEBOX;
                  _style_ex = 0;
//                  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
//                  SetWindowLong(_shell,GWL_EXSTYLE,WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
             }else
             if (_title_bar_style == WS_MAX_BTN){ 
                  _style = WS_CAPTION | WS_BORDER | WS_SYSMENU | WS_MAXIMIZEBOX;
                  _style_ex = 0;
//                  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
//                  SetWindowLong(_shell,GWL_EXSTYLE,WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
             }else
             if (_title_bar_style == WS_FRAME){ 
                  _style = WS_THICKFRAME;
                  _style_ex = 0;
//                  _style_ex = WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE;
//                  SetWindowLong(_shell,GWL_EXSTYLE,WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
             }else
             if (_title_bar_style == WS_NO_MANAGE){ 
                  _style = WS_POPUP;
                  _style_ex = 0;
             }
#if 1
             if (_shell!= 0 && _title_bar_style != val){
                 destroyWindow();
             }
#endif


//               SetWindowLong(_shell,GWL_STYLE,_style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN);
//               SetWindowLong(_shell,GWL_EXSTYLE,_style_ex);

//               SetWindowPos(_shell,NULL,0,0,_w_w,_w_h,SWP_NOMOVE | SWP_NOZORDER | SWP_DRAWFRAME);
//               SetWindowPos(_shell,NULL,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE | SWP_NOZORDER | SWP_DRAWFRAME);
             break;
    case WSDEV_TITLE_STRING:
             if (_title_string != NULL){
               delete _title_string;
             }
             tmpstr.setString((char*)data,WSGIappLocaleSet()->getDefaultEncoding());
             _title_string = strdup(
               tmpstr.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()));
             if (_shell != (HWND)NULL){
#ifndef _WSWINCE
               SetWindowText(_shell,_title_string);
#else
               WSCushort* tmpstr = WSGFgetUCS2(_title_string,WS_EN_DEFAULT);
               SetWindowText(_shell,tmpstr);
               delete tmpstr;
#endif
             }
             break;
    case WSDEV_NO_FRAME:  
             _no_frame = *(char*)data;
             _diff_w = -1;
             _diff_h = -1;
             if (_no_frame != False){
               _diff_w = 0;
               _diff_h = 0;
               _style = 0;
               _style_ex = WS_EX_TOPMOST;
               if ( _shell != 0){
                 destroyWindow();
//WSMFtrace("WSDwinwinDev::setValue WSDEV_NO_FRAME !!!!!!!!!!!!!! 0x%x w,h=%d,%d\n",this,_w_w,_w_h);
#if 0
//               SetWindowLong(_shell,GWL_STYLE,0);
                 SetWindowLong(_shell,GWL_STYLE, 0);
                 SetWindowLong(_shell,GWL_EXSTYLE,WS_EX_TOPMOST);
//                 SetWindowPos(_shell,NULL,0,0,_w_w,_w_h,SWP_NOMOVE | SWP_NOZORDER | SWP_DRAWFRAME);
#endif
               }
             }
             break;
    case WSDEV_POPUP_PARENT: 
//WSMFtrace("WSDwinwinDev::setValue WSDEV_POPUP_PARENT is not implemented...\n");
#if 0
             pparent = (WSCbase*)data;
             if (pparent != NULL){
               if (pparent->getowndev() != NULL ){
                 pdev = (WSDwinwinDev*)pparent->getowndev()->cast("WSDwinwinDev");
                 if (pdev != NULL){
                   pwidget = pdev->_shell;
                   if ( (HWND)_shell != (HWND)NULL && pwidget != (HWND)NULL){
                     XtSetArg(args[0],XtNtransient,True);
                     XtSetArg(args[1],XtNtransientFor,pwidget);
                     XtSetValues(_shell,args,2);
                     _popup_parent = True;
                   }
                 }
               }
             }else if (_popup_parent != False){
               if ( (HWND)_shell != (HWND)NULL ){
                 XtSetArg(args[0],XtNtransient,False);
                 XtSetValues(_shell,args,1);
                 _popup_parent = False;
               }
             }
#endif
             break;
    case WSDEV_MAP_STATUS: 
//WSMFtrace("WSDwinwinDev::setValue WSDEV_MAP_STATUS is not implemented...\n");
             if (getVisible()== True){
                if (*(long*)data == WS_TOP){
                  SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
                }else{
                  SetWindowPos(_shell,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
                }
             }
             break;
    case WSDEV_WIN_ACTIVE: 
//WSMFtrace("WSDwinwinDev::setValue WSDEV_WIN_ACTIVE is not implemented...\n");
             if (getVisible()== True){
                if (*(char*)data == True){
                  SetActiveWindow(_shell);
                }
             }
             break;
    case WSDEV_FLOAT_ON_TOP:
//WSMFtrace("WSDwinwinDev::setValue WSDEV_FLOAT_ON_TOP is not implemented...\n");
             if (*(char*)data == False){
                _float_on_top = False;
             }else{
                _float_on_top = True;
             }
             if (_wnd == NULL){
               break;
             }
             if (_float_on_top == True){
                SetWindowPos(_shell,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }else{
                SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }
             break;
    case WSDEV_GRAB_POINTER:
             if (_wnd == NULL){
               break;
             }
             _grabed = *(WSCbool*)data;
             if (_grabed != False){
               WSGIwinAppDev()->setGrabedWnd(_wnd);
             }else{
//WSMFtrace("WSDwinwinDev::setValue   ReleaseCapture...\n");
               int state = WSGIappMouse()->getStatus();
               if (state > 0){
                 break;
               }
               WSGIwinAppDev()->setGrabedWnd(NULL);
             }
#if 0
               XGrabPointer(XtDisplay(_wnd),XtWindow(_wnd),False,
                            ButtonPressMask | ButtonReleaseMask | PointerMotionMask,
                            GrabModeAsync,GrabModeAsync,None,None,CurrentTime);
             }else{
               XUngrabPointer(XtDisplay(_wnd),CurrentTime);
             }
#endif
             break;
    case WSDEV_MODAL:
             if (*(char*)data == False){
               _modal = False;
             }else{
               _modal = True;
             }
             if (_wnd == NULL){
               break;
             }
             if (_modal == True){
                SetWindowPos(_shell,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }else{
                SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
             }
             break;
    case WSDEV_MOUSE_NO:
             _mouse_no = *(WSCushort*)data;
             _mouse_val = (HCURSOR)WSGIappMouse()->getMouseCursor(*(WSCushort*)data);
             break;
    case WSDEV_WINDOW_STATE:
             if (getVisible() == False){
               return WS_ERR;
             }
             if (*(long*)data == WS_WINDOW_NORMAL){
               ShowWindow(_shell,SW_SHOWNORMAL);
             }else
             if (*(long*)data == WS_WINDOW_MINIMIZE){
#ifndef _WSWINCE
               ShowWindow(_shell,SW_SHOWMINIMIZED);
#endif
             }else
             if (*(long*)data == WS_WINDOW_MAXIMIZE){
               ShowWindow(_shell,SW_SHOWMAXIMIZED);
             }
             break;
    default:
      return WS_ERR;
  }
  return WS_NO_ERR;
}
long WSDwinwinDev::getValue(long kind,void* val){
  switch(kind){
    case WSDEV_WINDOW_STATE:
      if (getVisible() == False){
        *(long*)val = WS_WINDOW_NORMAL;
        return WS_NO_ERR;
      }
      if (_shell == 0){
        return WS_ERR;
      }
#ifndef _WSWINCE
      if (IsIconic(_shell)){
        *(long*)val = WS_WINDOW_MINIMIZE;
        return WS_NO_ERR;
      }
      if (IsZoomed(_shell)){
        *(long*)val = WS_WINDOW_MAXIMIZE;
        return WS_NO_ERR;
      }
#endif
      *(long*)val = WS_WINDOW_NORMAL;
      return WS_NO_ERR;
  }
  return WSDwindowDev::getValue(kind,val);
}
long WSDwinwinDev::createWindow(){
dbprintf("WSDwinwinDev::createWindow %s:%d start _wnd=0x%x\n",__FILE__,__LINE__,_wnd);
  _destroyed_by_method = 0;
  if (_wnd != 0){
dbprintf("WSDwinwinDev::createWindow %s:%d done1\n",__FILE__,__LINE__);
    return WS_NO_ERR;
  }
  _no_frame_first_time = 0;
//  _float_on_top = False;

  short x,y;    
  WSCushort w,h;    
  getWindowSize(&x,&y,&w,&h);
  if (w == 0){
    w = 1;
  }
  if (h == 0){
    h = 1;
  }
  _popup_parent = False;
extern char szAppName[];
  HWND alt_hwnd = (HWND)WSGIwinAppDev()->getContext2();
dbprintf("WSDwinwinDev::createWindow %s:%d alt=0x%x\n",__FILE__,__LINE__,alt_hwnd);

#ifdef _WSWINCE
  WSCushort* tmpstr = WSGFgetUCS2(szAppName,WS_EN_DEFAULT);
  WSCushort tmpstr2[1]; tmpstr2[0] = 0;
#endif

  if (alt_hwnd == 0){
  if (_no_frame ){
//    HWND pw = NULL;
#if 0
    WSDwinformDev* windev = getParentAreaDev();
    if (windev != NULL){
      pw = windev->getHWND();
    }
#endif
//    _shell = CreateWindowEx( _style_ex,szAppName,"", _style | WS_CLIPSIBLINGS | WS_POPUP |WS_CLIPCHILDREN, x,y,w,h,pw,
      HWND pw = WSGIwinAppDev()->getHWND();
#ifndef _WSWINCE
      _shell = CreateWindowEx( _style_ex,szAppName,"",
             _style | WS_CLIPSIBLINGS | WS_POPUP | WS_CLIPCHILDREN, x,y,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#else
      _shell = CreateWindowEx( _style_ex,tmpstr,tmpstr2,
             _style | WS_CLIPSIBLINGS | WS_POPUP | WS_CLIPCHILDREN, x,y,w,h,pw,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif
      SetWindowPos(_shell,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
//      SetWindowPos(_shell,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
//WSMFtrace("CreateWindow NO_FRAME XXZZq2  %d,%d,%d,%d\n",x,y,w,h);
    }else{
#ifndef _WSWINCE
      _shell = CreateWindowEx( _style_ex,szAppName,"", _style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN, x,y,w,h,NULL,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
      SetWindowLong(_shell,GWL_STYLE,_style | WS_CLIPSIBLINGS | WS_CLIPCHILDREN);
#else
      _shell = CreateWindowEx( _style_ex,tmpstr,tmpstr2, WS_CLIPSIBLINGS | WS_CLIPCHILDREN, x,y,w,h,NULL,
                        NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif
//      SetWindowLong(_shell,GWL_EXSTYLE,_style_ex);


    }
#ifndef _WSWINCE
    _wnd = CreateWindow(szAppName,"",WS_OVERLAPPED | WS_CLIPCHILDREN | WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#else
    _wnd = CreateWindow(tmpstr,tmpstr2, WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif
  }else{
    _shell = alt_hwnd;
#ifndef _WSWINCE
    _wnd = CreateWindow(szAppName,"",WS_CLIPCHILDREN | WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#else
    _wnd = CreateWindow(tmpstr,tmpstr2, WS_CHILD | WS_CLIPSIBLINGS,0,0,w,h,_shell,NULL,WSGIwinAppDev()->getInstanceHandle(),NULL);
#endif

  }

#ifdef _WSWINCE
  delete tmpstr;
#endif

  if (_title_string != NULL){
#ifndef _WSWINCE
    SetWindowText(_shell,_title_string);
#else
    WSCushort* tmpstr = WSGFgetUCS2(_title_string,WS_EN_DEFAULT);
    SetWindowText(_shell,tmpstr);
    delete tmpstr;
#endif
  }

  if (WSGIwinAppDev()->getWndProc() != NULL){
    if (alt_hwnd == NULL){
      SetWindowLong(_shell,GWL_WNDPROC,(LONG)WSGIwinAppDev()->getWndProc());
    }
    SetWindowLong(_wnd,GWL_WNDPROC,(LONG)WSGIwinAppDev()->getWndProc());
  }
//WSMFtrace("WSDwinwinDev CreateWindow this=0x%x wnd=0x%x style=0x%x,0x%x\n",this,_wnd,_style,_style_ex);
#ifdef DEBUG
WSMFtrace("WSDwinwinDev::createWindow() add callbacks is not implemented..\n");
#endif
#if 0
  RECT p;
  RECT p2;
  GetClientRect(_wnd,&p);
  GetWindowRect(_wnd,&p2);
//  _diff_x = p2.left - _w_x;
//  _diff_y = p2.top - _w_y;
  _diff_w = p2.right - p2.left - (p.right - p.left);
  _diff_h = p2.bottom - p2.top - (p.bottom - p.top);
//printf("createwindow diff x,y =%d,%d\n",_diff_x,_diff_y);
WSMFtrace("createwindow %d %d %d %d -> %d %d %d %d\n",x,y,w,h,p.left,p.top,p.right - p.left,p.bottom - p.top);
WSMFtrace("createwindow %d %d %d %d -> %d %d %d %d\n",x,y,w,h,p.left,p.top,p.right - p.left,p.bottom - p.top);
  MoveWindow(_shell,x,y, w + _diff_w, h + _diff_h,False);
  MoveWindow(_wnd,0,0, w + _diff_w, h + _diff_h,False);
  _moved = False;
  _resized = False;
#endif
  WSDwinformDev* ptr = this;
#if 0
  SetWindowLong(_wnd,GWL_USERDATA,(long)ptr);
  SetWindowLong(_shell,GWL_USERDATA,(long)ptr);
#else
#ifndef _WSWINCE
  SetProp(_wnd,"frm",(HANDLE)ptr);
  SetProp(_shell,"frm",(HANDLE)ptr);
#else
  unsigned short str1[4];
  str1[0] = 'f';
  str1[1] = 'r';
  str1[2] = 'm';
  str1[3] = 0;
  SetProp(_wnd,str1,(HANDLE)ptr);
  SetProp(_shell,str1,(HANDLE)ptr);
#endif
#endif

dbprintf("WSDwinwinDev::createWindow %s:%d done shell=0x%x wnd=0x%x\n",__FILE__,__LINE__,_shell,_wnd);
  return WS_NO_ERR;
}

long WSDwinwinDev::destroyWindow(){
dbprintf("WSDwinwinDev::destroyWindow() %s:%d start wnd=0x%x,shell=0x%x\n",__FILE__,__LINE__,_wnd,_shell);
  _destroyed_by_method = 1;
  _diff_x = -1;
  _diff_y = -1;
  _diff_w = -1;
  _diff_h = -1;
  destroyPixmap();
  if (_wnd != 0){
#if 0
    SetWindowLong(_wnd,GWL_USERDATA,(long)0);
#else
#ifndef _WSWINCE
    SetProp(_wnd,"frm",(HANDLE)0);
#else
  unsigned short str1[4];
  str1[0] = 'f';
  str1[1] = 'r';
  str1[2] = 'm';
  str1[3] = 0;
  SetProp(_wnd,str1,(HANDLE)0);
  SetProp(_shell,str1,(HANDLE)0);
#endif
#endif
    MSG msg;
    while(PeekMessage(&msg,_wnd,0,0,PM_REMOVE)){
      if (msg.message == WM_PAINT){
          PAINTSTRUCT ps;
          BeginPaint(_wnd,&ps);
          EndPaint(_wnd,&ps);
      }
    }
    DestroyWindow(_wnd);
    _wnd =0;
  }
  if (_shell != 0){
#if 0
    SetWindowLong(_shell,GWL_USERDATA,(long)0);
#else
#ifndef _WSWINCE
    SetProp(_shell,"frm",(HANDLE)0);
#else
  unsigned short str1[4];
  str1[0] = 'f';
  str1[1] = 'r';
  str1[2] = 'm';
  str1[3] = 0;
  SetProp(_wnd,str1,(HANDLE)0);
  SetProp(_shell,str1,(HANDLE)0);
#endif
#endif
    MSG msg;
    while(PeekMessage(&msg,_shell,0,0,PM_REMOVE)){
      if (msg.message == WM_PAINT){
          PAINTSTRUCT ps;
          BeginPaint(_shell,&ps);
          EndPaint(_shell,&ps);
      }
    }
    DestroyWindow(_shell);
    _shell =0;
  }
  setExposed(False);
  _pwnd = 0;

//printf("WSCwinwinDev::destroyWindow is not implemented\n");
#if 0
  if (_wnd != 0){
    XtRemoveEventHandler(_wnd,ExposureMask,False,(XtEventHandler)_evh_expose,this);
    XtRemoveEventHandler(_wnd,ButtonPressMask,False,(XtEventHandler)_evh_btn_press,(WSDwinformDev*)this);
    XtRemoveEventHandler(_wnd,ButtonReleaseMask,False,(XtEventHandler)_evh_btn_release,(WSDwinformDev*)this);
    XtRemoveEventHandler(_wnd,ButtonMotionMask | PointerMotionMask,False,(XtEventHandler)_evh_mouse_move,(WSDwinformDev*)this);
    XtRemoveEventHandler(_wnd,EnterWindowMask,False,(XtEventHandler)_evh_mouse_in,this);
    XtRemoveEventHandler(_wnd,LeaveWindowMask,False,(XtEventHandler)_evh_mouse_out,(WSDwinformDev*)this);
    XtRemoveEventHandler(_wnd,KeyPressMask | KeyReleaseMask,False,(XtEventHandler)_evh_dummy,(WSDwinformDev*)this);
    XtRemoveCallback(_wnd,XtNdestroyCallback,_evh_delete2,this);
    XtDestroyHWND(_wnd);
    _wnd = 0;
  }
  if (_shell != 0){
    XtDestroyHWND(_shell);
    _shell = 0;
  }
//  setDependDev(NULL);
#endif
  setInitialized(False);
//  destroyAllDependChildren();
//  WSGIwinAppDev()->dispatchEvent();
dbprintf("WSDwinwinDev::destroyWindow() %s:%d done wnd=0x%x,shell=0x%x\n",__FILE__,__LINE__,_wnd,_shell);
  return WS_NO_ERR;
}

#if 0
void WSDwinwinDev::_float_top_timer_proc(WSCuchar,void* data){
WSMFtrace("WSDwinwinDev::_float_top_timer_proc ...\n");
  WSDwinwinDev* dev = (WSDwinwinDev*)data;
  WSCbool fl = _chk_popup(dev);
  if (fl == False){
    dev->_requested_top = 0;
    return;
  }
  if (dev->getVisible() != False &&
//      dev->_title_bar_style == 0 &&
//      dev->_no_frame == 1 &&
      dev->_wnd != 0 ){
WSMFtrace("WSDwinwinDev::_float_top_timer_proc is not implemented.\n");
#if 0
    XWindowChanges wc;
    wc.stack_mode = TopIf;
    if (dev->_float_on_top != False){
      XConfigureWindow(XtDisplay(dev->_shell),XtWindow(dev->_shell),CWStackMode,&wc);
    }
#endif
    WSGIappTimer()->addTriggerProc(_float_top_timer_proc,WS500MS,dev);
    dev->_requested_top = 1;
  }else{
    dev->_requested_top = 0;
  }

}
#endif
long WSDwinwinDev::setVisible(WSCbool fl){
//WSMFtrace("WSDwinwinDev::setVisible %d this=0x%x\n",fl,this);
  WSCbool bk = getVisible();
  WSDdev::setVisible(fl);
  if (fl == False){
    WSDwinformDev* mdev = WSGIwinAppDev()->getMouseFocusDev();
    if (mdev == this){
      WSGIwinAppDev()->setMouseFocusDev(NULL);
    }
    if (_wnd != 0){
      if (_no_frame != 0){
        destroyWindow();
      }else{
        ShowWindow(_shell,SW_HIDE);
        ShowWindow(_wnd,SW_HIDE);
      }
#if 0
      if (_no_frame == 0){
         _del_list(this);
        XUnmapWindow(XtDisplay(_shell),XtWindow(_shell));
        XFlush(XtDisplay(_shell));
        XtRemoveCallback(_wnd,XtNdestroyCallback,_evh_delete2,this);
        XtDestroyHWND(_shell);
        _shell = 0;
        _wnd = 0;
//        setDependDev(NULL);
//        destroyAllDependChildren();
        setInitialized(False);
        onUnmap();
      }
#endif
    }
  }else{
    if (_wnd == 0){
       createWindow();
    }

    if (getPixmapStyle() != WS_DIRECT_WINDOW){
      if (bk == False){
        destroyPixmap(); //expose handler ō쐬邽߁AĂ
      }
    }

    short x,y;    
    WSCushort w,h;    
    getWindowSize(&x,&y,&w,&h);
    if (w == 0){
      w = 1;
    }
    if (h == 0){
      h = 1;
    }
#if 0
    XtSetArg(args[0],XtNwidth,w);
    XtSetArg(args[1],XtNheight,h);
    XtSetArg(args[2],XtNx,x);
    XtSetArg(args[3],XtNy,y);
    XtSetValues(_shell,args,4);
    XtSetValues(_wnd,args,2);
    XFlush(XtDisplay(_wnd));
    XtManageChild(_shell);
#endif
//    RECT p;
//    RECT p2;
//    GetClientRect(_wnd,&p);
//    GetWindowRect(_wnd,&p2);
//    _diff_x = p2.left - _w_x;
//    _diff_y = p2.top - _w_y;
//printf("setVisible diff x,y =%d,%d\n",_diff_x,_diff_y);
//    _diff_w = p2.right - p2.left - (p.right - p.left);
//    _diff_h = p2.bottom - p2.top - (p.bottom - p.top);
//printf("setVisible %d %d %d %d -> %d %d %d %d\n",x,y,w,h,p2.left,p2.top,p2.right - p2.left,p2.bottom - p2.top);
//printf("setVisible %d %d %d %d -> %d %d %d %d\n",x,y,w,h,p.left,p.top,p.right - p.left,p.bottom - p.top);
    if (_diff_w == -1){
      RECT r1;
      RECT r2;
      r1.left = _w_x;
      r2.left = _w_x;
      r1.right = _w_x + _w_w;
      r2.right = _w_x + _w_w;
      r1.top = _w_y;
      r2.top = _w_y;
      r1.bottom = _w_y + _w_h;
      r2.bottom = _w_y + _w_h;
      if (_no_frame == False){
        AdjustWindowRectEx(&r1,_style,FALSE,_style_ex);
      }
      _diff_x = r2.left - r1.left;
      _diff_y = r2.top - r1.top;
      _diff_w = r1.right - r1.left - (r2.right - r2.left);
      _diff_h = r1.bottom - r1.top - (r2.bottom - r2.top);
//printf("XXZZq2v show diff %d,%d,%d,%d\n",_diff_x,_diff_y,_diff_w,_diff_h);
//WSMFtrace("XXZZq2v show diff %d,%d,%d,%d\n",_diff_x,_diff_y,_diff_w,_diff_h);
//WSMFtrace("XXZZq2v setVis %d,%d,%d,%d ->shell\n",x,y,w+_diff_w,h+_diff_h);
    }
    MoveWindow(_shell,x,y, w + _diff_w ,h + _diff_h,False);
    MoveWindow(_wnd,0,0, w,h,False);
//    _resized = True;
#ifndef WS_NWIN
    if (_no_frame != False){
//      SetWindowLong(_shell,GWL_STYLE,_style);
//      SetWindowLong(_shell,GWL_EXSTYLE,_style_ex);
      ShowWindow(_wnd,SW_SHOWNOACTIVATE);
      ShowWindow(_shell,SW_SHOWNOACTIVATE);
    }else{
#ifndef _WSWINCE
      ShowWindow(_wnd,SW_SHOW);
      ShowWindow(_shell,SW_SHOW);
      SetWindowPos(_shell,HWND_TOP,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
#else
      ShowWindow(_wnd,SW_SHOW);
      ShowWindow(_shell,SW_SHOW);
      SetForegroundWindow(_shell);
      UpdateWindow(_shell);
      UpdateWindow(_wnd);
#endif
    }
#endif
  }
  return WS_NO_ERR;
}

WSDdev* WSDwinwinDev::getParentDev(){
  return NULL;
}
long WSDwinwinDev::dispatchEvent(WinEvent* ev){
  return WSDwinformDev::dispatchEvent(ev);
}
void WSDwinwinDev::_evh_focus_ch(WinEvent* ev){
//WSMFtrace("WSDwinwinDev::_evh_focus_ch() is not implemented.\n");
#if 0
  WSDwinwinDev* dev = (WSDwinwinDev*)ptr;
  if (dev->_wnd == NULL){
    return;
  }
  if (ev->type == FocusIn){
    dev->onFocusChange();
  }
#endif
}

void WSDwinwinDev::_evh_mouse_in(WinEvent* ev){
//WSMFtrace("WSDwinwinDev::_evh_mouse_in() is not implemented.\n");
#if 0
  WSDwinwinDev* dev = (WSDwinwinDev*)ptr;
  if (dev->_shell == NULL){
    return;
  }
//printf("dev=0x%x _shell=0x%x\n",dev,dev->_shell);
//fflush(stdout);
  long val = WSGIappMouse()->getMouseCursor(dev->_mouse_no);
  if (val != 0){
    XDefineCursor(XtDisplay((HWND)dev->_shell),XtWindow((HWND)dev->_shell),val);
  }
#endif
  WSDwinformDev::_evh_mouse_in(ev);
}

void WSDwinwinDev::_evh_delete(WinEvent* ){
dbprintf("WSDwinwinDev::_evh_delete %s:%d start this=0x%x\n",__FILE__,__LINE__,this);
  if (_destroyed_by_method != False){
dbprintf("WSDwinwinDev::_evh_delete %s:%d done1 this=0x%x\n",__FILE__,__LINE__,this);
    return;
  }
  if (_wnd == WSGIwinAppDev()->getEventWnd()){
    _pwnd = 0;
    _wnd = 0;
    _shell = 0;
    setInitialized(False);
    onUnmap();
  }else
  if (_shell == WSGIwinAppDev()->getEventWnd()){
    _pwnd = 0;
    _wnd = 0;
    _shell = 0;
    setInitialized(False);
    onUnmap();
  }
dbprintf("WSDwinwinDev::_evh_delete %s:%d done2 this=0x%x\n",__FILE__,__LINE__,this);
}

#if 0
WSClistData WSDwinwinDev::_no_frame_list;
void WSDwinwinDev::_add_list(WSDwinwinDev* dev){
  long num = _no_frame_list.getNum();
  long i;
  WSCbool fl = False;
  for(i=0; i < num; i++){
    WSDwinwinDev* item = (WSDwinwinDev*)_no_frame_list.getData(i);
    if (item == dev){
      fl = True;
      break;
    }
  }
  if (fl == False){
    _no_frame_list.add((void*)dev);
  }
}

void WSDwinwinDev::_del_list(WSDwinwinDev* dev){
  _no_frame_list.del((void*)dev);
}
#endif
#if 0
WSCbool WSDwinwinDev::_chk_popup(WSDwinwinDev* dev){
    //force popup at first time...
    if (dev->_no_frame_first_time != 0){
      dev->_no_frame_first_time = 0;
      return True;
    }
    long i;
    for(i=0; i<_no_frame_list.getNum(); i++){
      WSDwinwinDev* item = (WSDwinwinDev*)_no_frame_list.getData(i);
      if (item != dev ){
        if ( item->getVisible() == False){
           _del_list(item);
           i--;
        }else{
          long dx,dy;
          WSCulong dw,dh;
          if (WSGFandArea(item->_w_x,item->_w_y,item->_w_w,item->_w_h,
                          dev->_w_x,dev->_w_y,dev->_w_w,dev->_w_h,
                          &dx,&dy,&dw,&dh) == WS_NO_ERR){
            return False;
          }

        }
      } 
    }
    return True;
}
void WSDwinwinDev::_popup_window(WSDwinwinDev* dev){
WSMFtrace("WSDwinwinDev::_popup_window \n");
    _add_list(dev);
    WSCbool fl = _chk_popup(dev);
    if (fl == False){
      return;
    }

//    XWindowChanges wc;
//    wc.stack_mode = TopIf;
//    XConfigureWindow(XtDisplay(dev->_shell),XtWindow(dev->_shell),CWStackMode,&wc);
    if (dev->_requested_top == 0){
      _float_top_timer_proc(0,dev);
    }
}
#endif
void WSDwinwinDev::_evh_move(WinEvent* ev){
//TEST
  if (getVisible() == False){
    return;
  }
//WSMFtrace("WSDwinwinDev::_evh_move() this=0x%x   XXZZs1\n",this);
  if (_shell != WSGIwinAppDev()->getEventWnd()){
//WSMFtrace("_evh_move return1 x,y,w,h=%d %d %d %d\n",_w_x,_w_y,_w_w,_w_h);
    return;
  }
#ifndef _WSWINCE
  if (IsIconic(WSGIwinAppDev()->getEventWnd())){
    return;
  }
#endif
//  if (_moved != 0){
//    _moved = 0;
//printf("_evh_move return2 x,y,w,h=%d %d %d %d\n",_w_x,_w_y,_w_w,_w_h);
//    return;
//  }

  MSG msg;
#if 0
  if (PeekMessage(&msg,_shell,WM_SIZE,WM_SIZE,PM_NOREMOVE) != False){
//WSMFtrace("_evh_move return3 x,y,w,h=%d %d %d %d\n",_w_x,_w_y,_w_w,_w_h);
    return;
  }
#endif
  if (PeekMessage(&msg,_shell,WM_MOVE,WM_MOVE,PM_NOREMOVE) != False){
//WSMFtrace("_evh_move return4 x,y,w,h=%d %d %d %d\n",_w_x,_w_y,_w_w,_w_h);
    return;
  }
//WSMFtrace("_evh_move  x,y,w,h=%d %d %d %d\n",_w_x,_w_y,_w_w,_w_h);
//printf("_evh_move  x,y,w,h=%d %d %d %d\n",_w_x,_w_y,_w_w,_w_h);
  RECT r,r2,r3;
  GetWindowRect(_shell,&r);
  GetWindowRect(_wnd,&r2);
  GetClientRect(_shell,&r3);
#if 0
  _diff_x = r2.left - r.left;
  _diff_y = r2.top - r.top;
#endif
  if (r.left == _w_x && 
      r.top == _w_y ){
#if 0
      (r3.right - r3.left) == _w_w && 
      (r3.bottom - r3.top) == _w_h ){
#endif
//WSMFtrace("_evh_move  return1\n");
    return;
  }

#if 0
  if (_diff_w == -1){
    _diff_w = r.right - r.left - (r3.right - r3.left);
    _diff_h = r.bottom - r.top - (r3.bottom - r3.top);
//    MoveWindow(_shell,r.left,r.top,r.right-r.left + _diff_w,r.bottom - r.top + _diff_h,TRUE);
//    return;
    WSCrect area;
    area.setRect(r.left,r.top, r.right - r.left, r.bottom - r.top);
WSMFtrace("new diff_w/h=%d,%d\n",_diff_w,_diff_y);
    _w_now = 0;
    _h_now = 0;
    _resize_sequence = True;
    onResize(&area);
    _resize_sequence = False;
WSMFtrace("XXZZxx11\n");
    return;
  }
//  _diff_w = r.right - r.left - (r3.right - r3.left);
//  _diff_h = r.bottom - r.top - (r3.bottom - r3.top);
#endif
  WSCrect area;
#if 0
  area.setRect(r.left,r.top, r3.right - r3.left, r3.bottom - r3.top);
#endif
  area.setRect(r.left,r.top, _w_w,_w_h);

//printf("_evh_move  set x,y,w,h=%d %d %d %d\n",r.left,r.top,_w_w,_w_h);
//WSMFtrace("WSDwinwinDev::_evh_move() 0x%x %d %d %d %d   wparam=0x%x\n",this,r.left,r.top,r.right - r.left,r.bottom - r.top,ev->uParam);
//WSMFtrace("WSDwinwinDev::_evh_move() 0x%x diff w,h %d %d\n",this,_diff_w,_diff_h);

  if (area.x <-30000|| area.y < -30000){
    return;
  }
#if 0
  if (area.width >=32760|| area.width < 3){
    area.width = _w_w;
    area.height = _w_h;
  }
#endif
  _x_now = area.x;
  _y_now = area.y;
  _w_now = area.width;
  _h_now = area.height;
  _resize_sequence = True;
  onResize(&area);
  _resize_sequence = False;
}

void WSDwinwinDev::_evh_resize(WinEvent* ev){
//TEST
  if (getVisible() == False){
    return;
  }
  if (_wnd == WSGIwinAppDev()->getEventWnd()){
    return;
  }
#ifndef _WSWINCE
  if (IsIconic( WSGIwinAppDev()->getEventWnd())){
    return;
  }
#endif
//  if (_resized != 0){
//printf("_evh_resize exists return...XXZZz2\n");
//    _resized = 0;
//    return;
//  }

  MSG msg;
  if (PeekMessage(&msg,_shell,WM_SIZE,WM_SIZE,PM_NOREMOVE) != False){
//WSMFtrace("_evh_resize exists return...XXZZz3\n");
    return;
  }
#if 0
  if (_shell == WSGIwinAppDev()->getEventWnd()){
    RECT r;
    GetClientRect(_shell,&r);
    MoveWindow(_wnd,0,0,r.right,r.bottom,True);
    return;
  }
#endif
  if (PeekMessage(&msg,_wnd,WM_SIZE,WM_SIZE,PM_NOREMOVE) != False){
//WSMFtrace("_evh_resize exists return...XXZZz4\n");
    return;
  }
#if 0
  if (PeekMessage(&msg,_shell,WM_MOVE,WM_MOVE,PM_NOREMOVE) != False){
//WSMFtrace("_evh_resize exists return...XXZZz5\n");
    return;
  }
#endif
  RECT r,r2,r3;
  GetWindowRect(_shell,&r);
  GetWindowRect(_wnd,&r2);
  GetClientRect(_shell,&r3);
//WSMFtrace("_evh_resize  r.w/y= %d %d\n",r.right - r.left,r.bottom - r.top);
//WSMFtrace("_evh_resize2 r.w/y= %d %d\n",r3.right - r3.left,r3.bottom - r3.top);
#if 0
  _diff_x = r2.left - r.left;
  _diff_y = r2.top - r.top;
//WSMFtrace("_diff_x,y = %d,%d\n",_diff_x,_diff_y);
//WSMFtrace("x,y,w,h=%d %d %d %d \n",_w_x,_w_y,_w_w,_w_h);
#endif
  if ( (r3.right - r3.left) == _w_w && 
      (r3.bottom - r3.top) == _w_h ){
//WSMFtrace("_evh_resize return1\n");
    return;
  }
//WSMFtrace("_diff_w,h = %d,%d\n",_diff_w,_diff_h);
#if 0
  if (_diff_w == -1){
    _diff_w = r.right - r.left - (r3.right - r3.left);
    _diff_h = r.bottom - r.top - (r3.bottom - r3.top);
//    MoveWindow(_shell,r.left,r.top,r.right-r.left + _diff_w,r.bottom - r.top + _diff_h,TRUE);
//    return;
    WSCrect area;
    area.setRect(r.left,r.top, r.right - r.left, r.bottom - r.top);
//WSMFtrace("new2 diff_w/h=%d,%d\n",_diff_w,_diff_y);
    _w_now = 0;
    _h_now = 0;
    _resize_sequence = True;
    onResize(&area);
    _resize_sequence = False;
    return;
  }
#endif
//  if (_moved != 0){
//printf("_evh_resize return2\n");
//    return;
//  }
//WSMFtrace("_evh_resize x,y,w,h=%d %d %d %d  this=0x%x XXZZq2v\n",_w_x,_w_y,_w_w,_w_h,this);
#if 0
  _w_x = r.left;
  _w_y = r.top;
  _w_w = r.right - r.left;
  _w_h = r.bottom - r.top;
#endif
  WSCrect area;
#if 0
  area.setRect(r.left,r.top, r.right - r.left - _diff_w, r.bottom - r.top - _diff_h);
#endif
  area.setRect(_w_x, _w_y,r.right - r.left - _diff_w, r.bottom - r.top - _diff_h);

//WSMFtrace("WSDwinwinDev::_evh_resize() 0x%x %d %d %d %d   wparam=0x%x XXZZq2v\n",this,r.left,r.top,r.right - r.left,r.bottom - r.top,ev->uParam);
//WSMFtrace("WSDwinwinDev::_evh_resize() 0x%x diff w,h %d %d   wparam=0x%x\n",this,_diff_w,_diff_h);
  if (area.x < -30000|| area.y < -30000){
    return;
  }
  if (area.width >= 32760 || area.width < 3){
//WSMFtrace("resize canceled..........\n");
    return;
  }
  _x_now = area.x;
  _y_now = area.y;
  _w_now = area.width;
  _h_now = area.height;
  _resize_sequence = True;
  onResize(&area);
  _resize_sequence = False;

}

void WSDwinwinDev::_evh_expose(WinEvent* ev){
//WSMFtrace("WSDwinwinDev::_evh_expose() this=0x%x   XXZZs1\n",this);

  if (_shell == WSGIwinAppDev()->getEventWnd()){
    PAINTSTRUCT ps;
    BeginPaint(_shell,&ps);
#if 0
    HDC dc = BeginPaint(_shell,&ps);
    HBRUSH brush = CreateSolidBrush(0x888888);
    HBRUSH bbk = (HBRUSH)SelectObject(dc,(void*)brush);
    Rectangle(dc,0,0,2000,2000);
    SelectObject(dc,(void*)bbk);
    DeleteObject((void*)brush);
#endif
    EndPaint(_shell,&ps);
    return;
  }

  PAINTSTRUCT ps;
  BeginPaint(_wnd,&ps);
#if 0
    HDC dc = BeginPaint(_wnd,&ps);
    HBRUSH brush = CreateSolidBrush(0x888888);
    HBRUSH bbk = (HBRUSH)SelectObject(dc,(void*)brush);
    Rectangle(dc,0,0,2000,2000);
    SelectObject(dc,(void*)bbk);
    DeleteObject((void*)brush);
#endif
#if 0
  WSDwinwinDev* dev = (WSDwinwinDev*)ptr;
  if (wm_protocols == 0){
    wm_protocols = XInternAtom(XtDisplay(w),"WM_PROTOCOLS",False);
  }
  if (wm_delete == 0){
    wm_delete = XInternAtom(XtDisplay(w),"WM_DELETE_WINDOW",False);
  }
  XSetWMProtocols(XtDisplay(dev->_shell),XtWindow(dev->_shell),&wm_delete,1);
  if (dev->_shell == NULL){
    return;
  }
  if (dev->_title_bar_style == 0 && dev->_no_frame == 1 ){
    if (dev->_float_on_top != False){
//WSMFtrace("WSDwinwinDev::_evh_expose _popup_win..\n");
      _popup_window(dev);
    }
  }
  WSDwinformDev::_evh_expose(w,(WSDwinformDev*)dev,ev,fl);
#endif
  WSCrect area;
  area.setRect( (short)ps.rcPaint.left, (short)ps.rcPaint.top,
     (WSCushort)ps.rcPaint.right - ps.rcPaint.left,
     (WSCushort)ps.rcPaint.bottom - ps.rcPaint.top);

//WSMFtrace("winwin::_evh_expose %d,%d %d,%d\n",area.x,area.y,area.width,area.height);

  setExposed(True);
  if (getPixmapStyle() == WS_DIRECT_WINDOW){
    _clear_area(area.x,area.y,area.width,area.height);
  }
  onExpose(&area);

  EndPaint(_wnd,&ps);
}

//HWND WSDwinwinDev::getShell(){
//  return _shell;
//}

void WSDwinwinDev::_evh_client_message(WinEvent* ev){
//WSMFtrace("WSDwinwinDev::_evh_client_message() is not implemented.\n");
#if 0
  if (ev->type == ClientMessage){
    WSCbase* client = dev->getAttachedClient();
	if (client != NULL){
	  client->setVisible(False);
	}
  }
#endif
}
