//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <x11/WSDunixEnv.h>
#include <WSCstring.h>

WSDenv* _unix_env_chandler(){
  return new WSDunixEnv();
}
class _unix_env_init{
  public: _unix_env_init(){
    WSDenv::setCreateInstanceHandler(_unix_env_chandler);
  };
};
static _unix_env_init _unix_env_init_execute;

void WSGFunixEnvInit(){
  WSDenv::setCreateInstanceHandler(_unix_env_chandler);
}

WSDunixEnv::WSDunixEnv(){}
WSDunixEnv::~WSDunixEnv(){}

char* WSDunixEnv::getEnv(char* src){
  WSCstring str(src);
  str.delString("(",0);
  str.delString(")",0);
  WSCstring new_str = str.getWord(0);

  char* ret = getenv( new_str.getString() );
  if (ret == NULL){
    WSCbool wsdir = !strcmp("WSDIR",new_str.getString());
    if (wsdir != 0){
       return WS_DEFAULT_DIR;
    }else{
#if defined (BTRON)  || defined (TE)
      if (!strcmp("HOME",new_str.getString())){
        return "/SYS";
      }
#endif 
       return "";
    }
  }

  return ret;
}

