//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#include <x11/WSDxkeyboard.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/Xatom.h>
#include <x11/WSDxfont.h>
#include <x11/WSDxappDev.h>
#include <WSCdevice.h>
#include <WSDcolor.h>
#include <WSDmouse.h>
#include <WSCbase.h>
#include <WSCcolorSet.h>
#include <WSCfontSet.h>
#include <WSClocaleSet.h>

WSMFclassInit(WSDxkeyboard,WSDkeyboard);

static WSCbool _has_no_focus_win = False;
#ifndef KINPUT2
#include <locale.h>
#else
extern "C" {
extern int _beginConversionWithAttributes(Widget,Atom,Atom,
    void (*)(Widget,Atom,Atom,int,WSCulong,WSCuchar *,XtPointer),
    void (*)(Widget,Atom,int,XtPointer,Window),
    XtPointer,ArgList,Cardinal);
extern int _endConversion(Widget,Atom,WSCbool);
extern int _changeConversionAttributes(Widget,Atom,ArgList,Cardinal);
}
#endif

//#ifdef SUN
//extern "C" {
//extern char *XSetIMValues( XIM , ...);
//}
//#endif

extern "C" {
extern char *XSetIMValues(
#if NeedVarargsPrototypes
    XIM /* im */, ...
#endif
);
};

WSDxkeyboard* WSGIxkeyboard(){
  WSDkeyboard* keybd = WSGIappKeyboard();
  if (keybd == NULL){
    return NULL;
  }
  WSDxkeyboard* xkeybd =(WSDxkeyboard*)keybd->cast("WSDxkeyboard");
  return xkeybd;
}

WSDkeyboard* _xkeyboard_create_handler(){
  WSDkeyboard* keybd =  new WSDxkeyboard();
  keybd->initialize();
  return keybd;
}
#if 0 //move to WSGFdeviceInitialize..
class _xkeyboard_init{
  public: _xkeyboard_init(){
    WSDkeyboard::setCreateInstanceHandler(_xkeyboard_create_handler);
  };
};
_xkeyboard_init _xkeyboard_init_execute;
#endif
WSDxkeyboard::WSDxkeyboard(){
#ifndef KINPUT2
  _dev_for_xim = NULL;
  _xim = 0;
  _xic = 0;
  _focused = False;
#ifdef SUN
  _xim_init = True;
#else
  _xim_init = False;
#endif

#else
  _atom1 = 0;
  _atom2 = 0;
  _dev_for_kn = NULL;
  _font_kn = 0;
  _fg_kn = 0;
  _bg_kn = 0;
  _x_kn = 0;
  _y_kn = 0;
#endif

}

WSDxkeyboard::~WSDxkeyboard(){}

#ifndef KINPUT2
void WSDxkeyboard::_status_start(XIC xic,XPointer,XIMStatusDrawCallbackStruct cdata){ }
void WSDxkeyboard::_status_done(XIC ,XPointer,XIMStatusDrawCallbackStruct ){ }
void WSDxkeyboard::_status_draw(XIC xic,XPointer data,XIMStatusDrawCallbackStruct cdata){
    WSDxkeyboard* obj = (WSDxkeyboard*)data;
    WSCstring str(cdata.data.text->string.multi_byte);
    str.delHeadSpace();
    str.delTailSpace();
    obj->setModeString(str.getString());
    if (str.isExist("Ѿʸ") != -1 || str.isExist("̵Ѵ")   != -1 ||
        str.isExist("[̵Ѵ]") != -1 ){
      obj->setVisibleModeWindow(False);
    }else{
      obj->setVisibleModeWindow(True);
    }

}
#endif

#ifndef KINPUT2 //XIM
void WSDxkeyboard::setDevForXIM(WSDdev* dev){
  _dev_for_xim = dev;
}
WSDdev* WSDxkeyboard::getDevForXIM(){
  return _dev_for_xim;
}
void WSDxkeyboard::_im_instantiate(Display* display,XPointer ptr,XPointer){
  WSDxkeyboard* _this = (WSDxkeyboard*)ptr;
  _this->_xim_init = True;
}
void WSDxkeyboard::_im_destroy(XIM,XPointer ptr,XPointer){
  WSDxkeyboard* _this = (WSDxkeyboard*)ptr;
  _this->_xim = NULL;
  _this->_xic = 0;
}
#else
void WSDxkeyboard::setDevForKI(WSDdev* dev){
  _dev_for_kn = dev;
}
WSDdev* WSDxkeyboard::getDevForKI(){
  return _dev_for_kn;
}
#endif
long xim_lang = WS_EN_NONE;
long WSDxkeyboard::initialize(){
  if (getenv("WS_XIM_LANG")){
extern long WSGFgetEncodingValue(char*);
    xim_lang = WSGFgetEncodingValue(getenv("WS_XIM_LANG"));
  }
  //ISO8859..
  if (WSGIappCodeConvert()->getSystemEncoding() > WS_EN_NONE &&
      WSGIappCodeConvert()->getSystemEncoding() < WS_EN_UTF8){
    return WS_NO_ERR;
  }
#ifndef KINPUT2 //XIM
#ifndef SUN
  XRegisterIMInstantiateCallback(WSGIxwinAppDev()->display(),
        NULL, NULL, NULL, _im_instantiate, (XPointer)this);
#endif
#endif
  char* xmodifiers = getenv("XMODIFIERS");
  if (xmodifiers != NULL && !strcmp(xmodifiers,"@im=Ami")){ //for ami
    _has_no_focus_win = True;
  }
  return WS_NO_ERR;
}

long WSDxkeyboard::startKanji(WSDdev* dev,short x,short y,short fontno,short fgno,short bgno){
  WSDfont*    font  = WSGIappFontSet()->getFont(fontno);
  WSDcolor*   fgcol = WSGIappColorSet()->getColor(fgno);
  WSDcolor*   bgcol = WSGIappColorSet()->getColor(bgno);
#ifdef KINPUT2

  setDevForKI(dev);
  _x_kn = x;
  _y_kn = y;
  _font_kn = fontno;
  _fg_kn = fgno;
  _bg_kn = bgno;
  WSDxappDev* app   = WSGIxwinAppDev(); 
  if (_atom1 == 0){
     _atom1 = XInternAtom(app->display(),"_JAPANESE_CONVERSION",False);
  }
  if (_atom2 == 0){
     _atom2 = XInternAtom(app->display(),"_CONPOUND_TEXT",False);
  }
  XFontStruct* _ef = (XFontStruct*)font->getValue1();
  XFontStruct* _kf = (XFontStruct*)font->getValue2();
  XFontStruct* _gf = (XFontStruct*)font->getValue3();
  XFontStruct*  fonts[4];
  long          num = 0;
  if (_ef != (XFontStruct*)-1 && _ef != NULL){
    fonts[num] = _ef;
    num++;
  }
  if (_kf != (XFontStruct*)-1 && _kf != NULL){
    fonts[num] = _kf;
    num++;
  }
  if (_gf != (XFontStruct*)-1 && _gf != NULL){
    fonts[num] = _gf;
    num++;
  }
  fonts[num] = 0;
  WSCstring tmpstr("ABjpy");
  Arg args[10];

  short px,py;
  dev->getAbsoluteAddr(x,y + font->getStringHeight(&tmpstr),&px,&py);
  dev->setAbsoluteAddrChangeHandler(_device_move_handler,this);

  XtSetArg(args[0],"inputStyle","over");
  XtSetArg(args[1],"spotX",px);
  XtSetArg(args[2],"spotY",py); 
  XtSetArg(args[3],"eventCaptureMethod","focusSelect");
  XtSetArg(args[4],"fonts",fonts);
  XtSetArg(args[5],"foreground",fgcol->getValue1());
  XtSetArg(args[6],"background",bgcol->getValue1());
  _beginConversionWithAttributes((Widget)dev->getSpecialResource(),_atom1,_atom2,
                     _kanji_input, _kanji_start_end,this,args,7);
  _fep_on = True; 
#else //XIM

#if 0
  if(_xic != 0 ){
    if (_focused == True){
      XUnsetICFocus(_xic);
      XDestroyIC(_xic);
      _xic = NULL;
      _focused = False;
    }
  }
#endif

  setDevForXIM(dev);
  WSDxfont* xfont = (WSDxfont*)font->cast("WSDxfont");
  if (xfont != NULL){
    short px,py;
    WSCstring tmpstr("ABjpy");
    dev->getAbsoluteAddr(x,y + font->getStringHeight(&tmpstr),&px,&py);
    dev->setAbsoluteAddrChangeHandler(_device_move_handler,this);
    XPoint point;
    point.x = px;
    point.y = py;

    short dx,dy;
    dev->getDispAddr(&dx,&dy);
    setModeWindowPos(dx,dy,dev);

    XRectangle area;
    area.x = 0;
    area.y = 0;
    area.width =  10000;
    area.height = 10000;

    if (_xic != 0){
      XVaNestedList list;
      XVaNestedList list2;
      XFontSet* font_set = (XFontSet*)xfont->getXFontSet();

      list = XVaCreateNestedList(0, XNFontSet,font_set,
               XNSpotLocation,&point, XNArea,&area, 
               XNForeground,fgcol->getValue1(),
               XNBackground,bgcol->getValue1(), NULL,NULL);

      XIMCallback callback_status_start;
      callback_status_start.client_data = (char*)this;
      callback_status_start.callback = (XIMProc)_status_start;

      XIMCallback callback_status_done;
      callback_status_done.client_data = (char*)this;
      callback_status_done.callback = (XIMProc)_status_done;

      XIMCallback callback_status_draw;
      callback_status_draw.client_data = (char*)this;
      callback_status_draw.callback = (XIMProc)_status_draw;

      list2 = XVaCreateNestedList(0, XNStatusStartCallback,
           &callback_status_start, 
           XNStatusDoneCallback,&callback_status_done, 
           XNStatusDrawCallback,&callback_status_draw, NULL,NULL);

      if (_has_no_focus_win == False){
        Window win;
        XGetICValues(_xic,XNFocusWindow,&win, NULL);
        if(win != XtWindow((Widget)dev->getSpecialResource())){
          XWindowAttributes att;
          Display* disp =  XtDisplay((Widget)dev->getSpecialResource());
          Window   target =  XtWindow((Widget)dev->getSpecialResource());
          XGetWindowAttributes(disp, target, &att);
          WSCulong mask;
          XGetICValues(_xic,XNFilterEvents,&mask,NULL);
          XSelectInput(disp,target,mask | att.your_event_mask);
          _xic = _get_xic(target);
          XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                       list2, NULL);
        }else{
          XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                     list2, NULL);
        }
      }else{
        XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                     list2, NULL);
      }
      XSetICFocus(_xic);
      _focused = True;
      XFree(list);
      XFree(list2);
    }
#if 0 //TEST
    XEvent ev;
    Window win = XtWindow((Widget)_dev_for_xim->getSpecialResource());
    ev.type = KeyPress;
    ev.xany.window = win;
    ev.xany.display = XtDisplay((Widget)_dev_for_xim->getSpecialResource());
    ev.xkey.root = win;
    ev.xkey.subwindow = win;
    ev.xkey.time = CurrentTime;
    ev.xkey.x = 0;
    ev.xkey.y = 0;
    ev.xkey.x_root = 0;
    ev.xkey.y_root = 0;
    ev.xkey.same_screen = 0;
    ev.xkey.keycode = 65;
    ev.xkey.state = 1;
    XFilterEvent(&ev,None);
//    XSendEvent( XtDisplay((Widget)_dev_for_xim->getSpecialResource()),
//                  win,False,KeyPressMask,&ev);
    ev.type = KeyRelease;
    XFilterEvent(&ev,None);
//    XSendEvent( XtDisplay((Widget)_dev_for_xim->getSpecialResource()),
//                  win,False,KeyReleaseMask,&ev);

//    ev.xkey.keycode = XK_Shift_L;
//    ev.xkey.state = 0;
//    ev.type = KeyRelease;
//    XSendEvent( XtDisplay((Widget)_dev_for_xim->getSpecialResource()),
//                  win,False,KeyReleaseMask,&ev);

#endif //TEST
  }
#endif //XIM
  return WS_NO_ERR;
}

long WSDxkeyboard::startAscii(WSDdev* dev,short ,short ,short ,short ,short ){
#ifdef KINPUT2
  setDevForKI(dev);
  if (_fep_on == True){
    _endConversion((Widget)dev->getSpecialResource(), _atom1, True);
    if (dev != NULL){
      dev->setAbsoluteAddrChangeHandler(NULL,NULL);
    }
  }
#else  //XIM
  if(_xic != 0 ){
    if (_focused == True){
      XUnsetICFocus(_xic);
      _focused = False;
    }
  }

  setDevForXIM(dev);
#endif //XIM

  _fep_on = False;
  return WS_NO_ERR;
}


long WSDxkeyboard::resetFep(WSDdev* dev){
#ifdef KINPUT2
  if (_fep_on == True){
    _endConversion((Widget)dev->getSpecialResource(), _atom1, True);
    if (dev != NULL){
      dev->setAbsoluteAddrChangeHandler(NULL,NULL);
    }
  }
  _fep_on = False;
  setDevForKI(NULL);
  return WS_NO_ERR;
#else  //KINPUT2
  if(_xic != 0 ){
    if (_focused == True){
      XUnsetICFocus(_xic);
      _focused = False;
    }
  }
  setDevForXIM(NULL);
  return WS_NO_ERR;
#endif
}

#ifndef KINPUT2 //XIM
XIC WSDxkeyboard::_create_xic(Window win,XVaNestedList list,XVaNestedList list2){
  if (_xim != 0){
    XCloseIM( _xim );
    _xim = 0;
  }
  WSDxappDev* app   = WSGIxwinAppDev(); 
  setlocale(LC_CTYPE,"");
  XSetLocaleModifiers("");
  _xim = XOpenIM(app->display(),NULL,NULL,NULL);

  if (_xim == 0){
    return NULL;
  }

  XIMCallback ximcallback;
#ifdef SUN
  ximcallback.callback = (XIMProc)_im_destroy;
#else
  ximcallback.callback = _im_destroy;
#endif
  ximcallback.client_data = (XPointer)this;
  XSetIMValues(_xim, XNDestroyCallback, &ximcallback, NULL);


  XIMStyle style = 0;
#if 0
  static XIMStyle preedit[] = {XIMPreeditArea,XIMPreeditCallbacks,
              XIMPreeditPosition, XIMPreeditNothing,XIMPreeditNone,NULL};
  static XIMStyle statusedit[] = {XIMStatusArea,XIMStatusCallbacks,
              XIMStatusNothing, XIMStatusNone,NULL};
#endif

  static XIMStyle the_styles[]
          = { XIMPreeditPosition | XIMStatusNothing, //over_the_spot style
              XIMPreeditNothing | XIMStatusNothing,  //root style
              XIMPreeditNone | XIMStatusNone,        //root style
              0
            };

  XIMStyles* styleBuf;
  XGetIMValues(_xim,XNQueryInputStyle,&styleBuf,NULL);

  long i = 0;
  while(the_styles[i] != 0){
    long j;
    for(j = 0; j < styleBuf -> count_styles;j++){
        if( the_styles[i] == styleBuf->supported_styles[j]){
          style = styleBuf -> supported_styles[j];
          break;
        }
    }
    if (style != 0){
      break;
    }
    i++;
  }

  XFree(styleBuf);

  if(style == 0){
WSMFtrace("Error. CAN'T USE INPUT STYLE !!  \n" );
    return 0;
  }

  XIC xic = (XIC)XCreateIC(_xim, XNInputStyle,style,
//           XNClientWindow,XtWindow((Widget)WSGIxwinAppDev()->appWidget()),
           XNClientWindow,win,
           XNFocusWindow,win, XNPreeditAttributes,list,
           XNStatusAttributes,list2, NULL);
  return xic;
}

XIC WSDxkeyboard::_get_xic(Window win){
  if (_xic != 0){
//    XSetICValues( _xic, XNClientWindow,win,NULL);
    XSetICValues( _xic, XNFocusWindow,win,NULL);
  }
  return _xic;
}
#endif


long WSDxkeyboard::setFepPos(WSDdev* dev,short x,short y,short fontno,short fgno,short bgno){
#ifdef KINPUT2
  setDevForKI(dev);
  _x_kn = x;
  _y_kn = y;
  _font_kn = fontno;
  _fg_kn = fgno;
  _bg_kn = bgno;
  if (dev != NULL && _fep_on == True){
//    WSCstring tmpstr("ABjpy");
    WSDfont*  font  = WSGIappFontSet()->getFont(fontno);
    short px,py;
    dev->getAbsoluteAddr(x,y + font->getFontHeight(),&px,&py);
    dev->setAbsoluteAddrChangeHandler(_device_move_handler,this);
    Arg args[2];
    XtSetArg(args[0],"spotX",px);
    XtSetArg(args[1],"spotY",py); 
    _changeConversionAttributes((Widget)dev->getSpecialResource(), _atom1,args,2);
  }

#else  //XIM
static short x_bk = 0;
static short y_bk = 0;

  setDevForXIM(dev);
  WSDfont*    font  = WSGIappFontSet()->getFont(fontno);
  WSDcolor*   fgcol = WSGIappColorSet()->getColor(fgno);
  WSDcolor*   bgcol = WSGIappColorSet()->getColor(bgno);
  WSDxfont* xfont = (WSDxfont*)font->cast("WSDxfont");
  if (dev != NULL && xfont != NULL){
    short px,py;
    WSDfont*  font  = WSGIappFontSet()->getFont(fontno);
    dev->getAbsoluteAddr(x,y + font->getFontHeight(),&px,&py);
//printf("setFepPos %d,%d %d,%d fh=%d\n",x,y,px,py,font->getFontHeight());
    dev->setAbsoluteAddrChangeHandler(_device_move_handler,this);

    XPoint point;
    point.x = px;
    point.y = py;
    short dx,dy;
    dev->getDispAddr(&dx,&dy);
    setModeWindowPos(dx,dy,dev);

    XRectangle area;
    area.x = 0;
    area.y = 0;
    area.width =  10000;
    area.height = 10000;
    if (_xim_init != False){
      XVaNestedList list;
      XVaNestedList list2;

      XFontSet* font_set = (XFontSet*)xfont->getXFontSet();
      list = XVaCreateNestedList(0,
               XNFontSet,font_set,
               XNSpotLocation,&point,
               XNArea,&area,
               XNForeground,fgcol->getValue1(),
               XNBackground,bgcol->getValue1(),NULL,NULL);

      XIMCallback callback_status_start;
      callback_status_start.client_data = (char*)this;
      callback_status_start.callback = (XIMProc)_status_start;

      XIMCallback callback_status_done;
      callback_status_done.client_data = (char*)this;
      callback_status_done.callback = (XIMProc)_status_done;

      XIMCallback callback_status_draw;
      callback_status_draw.client_data = (char*)this;
      callback_status_draw.callback = (XIMProc)_status_draw;

      list2 = XVaCreateNestedList(0, XNStatusStartCallback,
                  &callback_status_start, 
                  XNStatusDoneCallback,&callback_status_done, 
                  XNStatusDrawCallback,&callback_status_draw, NULL,NULL);
      if (_xic == 0){
        _xic = _create_xic(XtWindow((Widget)dev->getSpecialResource()),
                         list,list2);
        if (_xic != 0 && _has_no_focus_win == False){
          Window win = 0;
          XGetICValues(_xic,XNFocusWindow,&win, NULL);
          if (win == 0){
            _has_no_focus_win = True;
          }
        }
      }else{
        Window win = 0;
        if (_has_no_focus_win == False){ // for ami
          XGetICValues(_xic,XNFocusWindow,&win, NULL);
          if (win == 0){
            _has_no_focus_win = True;
          }
        }
        if(win == 0){
          if (x_bk == x && y_bk == y){
            point.y ++;
            XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                         list2, NULL);
            point.y --;
          }
          XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                       list2, NULL);
       }else if(win != XtWindow((Widget)dev->getSpecialResource())){
          Display* disp =  XtDisplay((Widget)dev->getSpecialResource());
          Window   target =  XtWindow((Widget)dev->getSpecialResource());
          XWindowAttributes att;
          XGetWindowAttributes(disp, target, &att);
          XDestroyIC(_xic);
          _xic = NULL;
          _xic = _create_xic(XtWindow((Widget)dev->getSpecialResource()),
                           list,list2);
          WSCulong mask;
          XGetICValues(_xic,XNFilterEvents,&mask,NULL);
          XSelectInput(disp,target,mask | att.your_event_mask);
        }else{
          if (x_bk == x && y_bk == y){
            point.y ++;
            XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                         list2, NULL);
            point.y --;
          }
          XSetICValues(_xic, XNPreeditAttributes,list, XNStatusAttributes,
                       list2, NULL);
        }
        XSetICFocus(_xic);
        _focused = True;
      }
      XFree(list);
      XFree(list2);
    }
  }
  x_bk = x;
  y_bk = y;
#endif
  return WS_NO_ERR;
}

void WSDxkeyboard::setModeWindowPos(short x,short y,WSDdev* dev){
  WSCushort h = 0;
  WSCbase* client = dev->getAttachedClient();
  if (client != NULL){
    if (client->existProperty(WSNheight) != False){
       client->getPropertyV(WSNheight,&h);
    }
  }
  short dx = x;
  short dy = y + h + 10;
  if ((long)(y + h + 40) > (long)WSGIappDev()->getHeight()){
    dy = y - 50;
  }
  setPositionModeWindow(dx,dy);
}


#ifdef KINPUT2
void WSDxkeyboard::_kanji_input(Widget,Atom,Atom,int pformat,
                    WSCulong psize,WSCuchar *data,XtPointer dt){
  WSDxkeyboard* obj = (WSDxkeyboard*)dt;
  if (pformat == 8){
    char *buf = new char[psize+1];
    memcpy(buf,data,(WSCuint)psize);
    buf[psize] = 0;
    char* kanji_euc_str = WSGFcreateEucStringFromJisStr(buf);
    delete buf;
    obj->setKey(0);
    obj->_with_cntl = False;
    obj->_with_lock =  False;
    obj->_with_shift = False;
    obj->_with_alt = False;
    obj->_is_function = False;
    obj->_is_cursor = False;
    obj->_is_tty_function = False;
    obj->setText(kanji_euc_str,WSGIappCodeConvert()->getSystemEncoding());
    delete kanji_euc_str;
    obj->executeHandler(True);
    obj->executeHandler(False);
  }
  return;
}

void WSDxkeyboard::_kanji_start_end(Widget,Atom,int state,XtPointer dt,Window){
  WSDxkeyboard* obj = (WSDxkeyboard*)dt;
  if (state == 1 || state == -1){
    obj->_fep_on = False;
  }
}
#endif
#ifndef KINPUT2
void WSDxkeyboard::setEnableFep(WSDdev* dev,WSCbool fl){
  WSDkeyboard::setEnableFep(dev,fl);
  return;
#if 0
  if (fl == False){
    if (_xic != 0){
      if (_focused == True){
        XUnsetICFocus(_xic);
        _focused = False;
      }
    }
  }else if (dev != NULL){
    setDevForXIM(dev);
    Window win ;
    if(_xic != 0){
      if ( getDevForXIM() != NULL ){
        WSDdev* dev = getDevForXIM();
        Display* disp =  XtDisplay((Widget)dev->getSpecialResource());
        Window   target =  XtWindow((Widget)dev->getSpecialResource());
        int revent;
        Window tmpw = 0;
        XGetInputFocus(disp, &tmpw,&revent);
        if (tmpw != target){
          int fl = 1;
          if (dev->getVisible() != False){
            XWindowAttributes wa;
            XGetWindowAttributes(disp,target,&wa);
            if (wa.map_state != IsViewable){
              fl = 0;
            }
          }else{
            fl = 0;
          }
          if (fl == 1){
            XSetInputFocus(disp,target,RevertToParent,CurrentTime);
          }
        }

        WSCulong mask;
        XGetICValues(_xic, XNFocusWindow,&win, XNFilterEvents,&mask, NULL);
        if(win != target){
         _xic = _get_xic(target);
          XWindowAttributes att;
          XGetWindowAttributes(disp, target, &att);
          XSelectInput(disp,target,mask | att.your_event_mask);
        }
      }
      XSetICFocus(_xic);
      _focused = True;
    }
  }
#endif
}
#endif

WSCbool WSDxkeyboard::deliverKeyEvent(XEvent* ev){
  WSCbool press = False;
  if ( ev->type == KeyPress){
     press = True;
  }
  setIsPressed(press);

  char buffer[1024];
  KeySym key = 0;
#ifdef KINPUT2 
  if (ev->type == FocusIn ){
    return True;
  }
  if (_fep_on != False ){
    static WSCulong time_bk = 0;
    if (_dev_for_kn != NULL && _dev_for_kn->getVisible() != False){
      Window win = XtWindow((Widget)_dev_for_kn->getSpecialResource());
      if (ev->xany.window != win){
        ev->xany.window = win;
        if (ev->type == KeyPress){
          XSendEvent( XtDisplay((Widget)_dev_for_kn->getSpecialResource()),
                  win,False,KeyPressMask,ev);
        }else{
          XSendEvent( XtDisplay((Widget)_dev_for_kn->getSpecialResource()),
                  win,False,KeyReleaseMask,ev);
        }
        return False;
      }
    }
    if (ev->xkey.time != time_bk){
      time_bk = ev->xkey.time;
      return False;
    }
  }

  int len = XLookupString((XKeyEvent *)ev,buffer,1022,&key,(XComposeStatus*)NULL);
  buffer[len]=0;
  if (len == 1 && ((WSCuchar)buffer[0] < 0x20 || (WSCuchar)buffer[0] > 0x7f)){
     buffer[0] = 0;
     len = 0;
  }

#else //XIM
  if (_xic == 0){
    if (ev->type == FocusIn){
       return True;
    }
    int len = XLookupString((XKeyEvent *)ev,buffer,1022,&key,(XComposeStatus*)NULL);
    buffer[len]=0;
    if (len == 1 && (buffer[0] < 0x20 || (unsigned char)buffer[0] > 0x7f)){
       buffer[0] = 0;
       len = 0;
    }

  }else{
    if (_dev_for_xim != NULL ){ 
      if (_dev_for_xim->getVisible() != False){
        Window win = XtWindow((Widget)_dev_for_xim->getSpecialResource());
        if (ev->type == FocusIn){
          if ( ev->xany.window != win){

            XWindowAttributes att;
            XGetWindowAttributes(
                 XtDisplay((Widget)_dev_for_xim->getSpecialResource()),
                 win, &att);
            if (att.map_state == IsViewable){
#if 0 //This causes focus trouble under click focus mode..
              XSetInputFocus(
                 XtDisplay((Widget)_dev_for_xim->getSpecialResource()),
                 win, RevertToParent,CurrentTime);
#endif
            }
            return False;
          }else{
            return True;
          }
        }
        if (ev->xany.window != win){
          if (ev->type == KeyPress || ev->type == KeyRelease){
            ev->xany.window = win;
            WSCbool fl = XFilterEvent(ev,None);
            if (fl != False){
              return False; //It is Ok ,because FEP is effected.
            }
          }else{
            return False;
          }
        }
      }
    }
    Status status = XLookupNone;
    int len = XmbLookupString(_xic,(XKeyEvent *)ev,buffer,1022, &key,&status);
    buffer[len] = 0;
    if(status == XLookupNone){
         len = XLookupString((XKeyEvent *)ev,buffer,1022,&key,(XComposeStatus*)NULL);
    }
    if (len == 1 && (buffer[0] < 0x20 || (unsigned char)buffer[0] > 0x7f)){
       buffer[0] = 0;
       len = 0;
    }

  }
#endif
  setKey(key);
  _with_shift = ((ev->xkey.state & ShiftMask) != 0    );
  if (key == XK_ISO_Left_Tab){
    setKey(XK_Tab);
    _with_shift = 1;
  }
  _with_lock = ((ev->xkey.state & LockMask) != 0     );
  _with_cntl = ((ev->xkey.state & ControlMask) != 0  );
  _with_alt = ((ev->xkey.state & Mod1Mask) != 0     );
  _is_cursor = IsCursorKey(key);
  _is_function = IsFunctionKey(key);
  if (xim_lang == WS_EN_NONE){
    setText(buffer,WSGIappCodeConvert()->getSystemEncoding());
  }else{
    setText(buffer,xim_lang);
  }

  if (key == WSK_Delete || key == WSK_Insert){
    _is_tty_function = True;
  }else{
    _is_tty_function = False;
  }

#ifdef KINPUT2
  if ( ev->type == KeyPress && (
   (key == WSK_space && withShift() == True ) ||
#ifndef SUN
               key == WSK_Kanji ||
#else 
               key == WSK_Henkan ||
#endif
        (key == WSK_Zenkaku_Hankaku && withAlt() == True) ||
        (key == WSK_Hiragana_Katakana ) )){
    if (_dev_for_kn != NULL && getEnableFep() == True ){
      startKanji(_dev_for_kn,_x_kn,_y_kn,_font_kn,_fg_kn,_bg_kn);
      return False;
    }
  }
#endif

  WSCbool executed = executeHandler(press);
  if (executed == True){
    return False;
  }else{
    return True;
  }
}

void WSDxkeyboard::_device_move_handler(WSDdev* dev,void*dt){
  WSDxkeyboard* obj = (WSDxkeyboard*)dt;
  if (obj->_fep_on == True){
    obj->startAscii(dev,0,0,0,0,0);
  }
}
void WSDxkeyboard::setSelectedString(char* str,long encode){
  WSDkeyboard::setSelectedString(str,encode);
  WSDxappDev* app   = WSGIxwinAppDev(); 

  WSCstring string;
  string.setString(str,encode);

  XStoreBytes(app->display(),
              string.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()),
    strlen( string.getString(WSGIappLocaleSet()->getSystemLocaleEncoding()))+1);

  Window owner = XGetSelectionOwner(app->display(),XA_PRIMARY);
  Window me = XtWindow(app->appWidget());
  if (owner != me){
//printf("WSDxkeyboard::setSelectedString selection owner::\n");
    XSetSelectionOwner(app->display(),XA_PRIMARY,me,CurrentTime);
  }
}
char* WSDxkeyboard::getSelectedString(long encoding){
//  return WSDkeyboard::getSelectedString();
//printf("WSDxkeyboard::getSelectedString...\n");
#if 0
    int bytes;
    WSDxappDev* app   = WSGIxwinAppDev(); 
    char* ret = XFetchBytes(app->display(),&bytes);
    char* str = new char[bytes+1];
    memcpy(str,ret,bytes);
    str[bytes]=0;
    WSDkeyboard::setSelectedString(str,
         WSGIappLocaleSet()->getSystemLocaleEncoding());
    delete str;
    return WSDkeyboard::getSelectedString(encoding); 
#endif

static long _lock = 0;
  if (_lock == 0){
    _lock = 1;
    WSDxappDev* app   = WSGIxwinAppDev(); 
static Atom prop = 0;
    if (prop == 0){
//      prop = XInternAtom(app->display(),"COMPOUND_TEXT",False);
//      prop = XInternAtom(app->display(),"UTF8_STRING",False);
      prop = XInternAtom(app->display(),"TARGETS",False);
    }
    Window me = XtWindow(app->appWidget());
//    XConvertSelection(app->display(),XA_PRIMARY,XA_STRING,prop,me,CurrentTime);
    XConvertSelection(app->display(),XA_PRIMARY,prop,prop,me,CurrentTime);
//printf("WSDxkeyboard::getSelectedString... create request...\n");


    _wait_for_receive_data = 1;
    while(_wait_for_receive_data){
      app->dispatchEvent();
      WSGIappDevice()->clearDeleteList();
    }
    _lock = 0;
//printf("WSDxkeyboard::getSelectedString() #%s#\n", WSDkeyboard::getSelectedString());
    return WSDkeyboard::getSelectedString(encoding); 
  }else{
    return "";
  }

}

void WSDxkeyboard::selectionDataAvailable(){
  _wait_for_receive_data = 0;
}

