//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDFILE_H
#define WSDFILE_H

#include <WSCroot.h>
#include <WSCstring.h>

class WSDfile :public WSCroot{

  protected:
    WSCstring _file_name;
    WSCbool   _read_only;
    char      _type;

    static WSDfile* (*_create_handler)();
    WSDLEX32 void   setReadOnly(WSCbool);

  public:
    WSDLEX32 WSDfile();

    WSDLEX32 WSCbool isReadOnly();
    WSDLEX32 void setType(char);
    WSDLEX32 char getType();

    WSDLEX32 virtual long    open(char* name,char* mode);
    WSDLEX32 virtual long    close();
    WSDLEX32 virtual long    read(void*,long len);
    WSDLEX32 virtual long    write(void*,long len);
    WSDLEX32 virtual WSCbool eof();
    WSDLEX32 virtual long    seek(long addr);
    WSDLEX32 virtual long    seekSet();
    WSDLEX32 virtual long    seekEnd();
    WSDLEX32 virtual long    getSize();
    WSDLEX32 virtual long    tell();

    WSDLEX32 static WSDfile* getNewInstance();
    WSDLEX32 static void      setCreateInstanceHandler(void* hd);
    WSDLEX32 static void*     getCreateInstanceHandler();

    WSMFclassDef(WSDfile,WSCroot);
};
#endif
