//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDDFBSCRDEV_H
#define WSDDFBSCRDEV_H

#include <dfb/WSDdfbFormDev.h>

class WSDdfbScrFrameDev   :public WSDdfbFormDev{
 protected:
  short   _h_scr_pos;
  short   _v_scr_pos;
  short   _p1_x;
  short   _p1_y;
  short   _p2_x;
  short   _p2_y;
  WSCushort  _work_width;
  WSCushort  _work_height;
  WSCushort  _title_height;

  virtual long createPixmap();

 public:
virtual void _copy_area(long x,long y,WSCulong w,WSCulong h,long dx,long dy,WSCuchar fl);
virtual void _setup_pixmap(short x,short y,WSCushort w,WSCushort h,short bg,short img_no);
virtual void _clear_area( long x,long y,WSCulong w,WSCulong h);
  WSDdfbScrFrameDev();
  virtual ~WSDdfbScrFrameDev();
  virtual long setValue(long kind,void*);
  virtual void getDispAddr(short*,short*);
  virtual void getAbstPos(short*,short*);
  WSMFclassDef(WSDdfbScrFrameDev,WSDdfbFormDev);
};
#endif
