//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDFBCOM_H
#define WSDFBCOM_H

#include <WScom.h>
#include <pthread.h>
#include <dfb/WSDdfbFont.h>

typedef struct pthread_sem_struct{
  int value;
  pthread_mutex_t mutex;
  pthread_cond_t lock_free;
} pthread_sem_t;

#define WS_FONT_LEFT_TO_RIGHT 0
#define WS_FONT_RIGHT_TO_LEFT 1

extern int pthread_sem_init_np(pthread_sem_t* semp);
extern int pthread_sem_lock_np(pthread_sem_t* semp);
extern int pthread_sem_unlock_np(pthread_sem_t* semp);
extern int pthread_sem_destroy_np(pthread_sem_t* semp);

extern void WSGFdfbDrawString(IDirectFBSurface* context,WSDfont* font,
                      WSCushort* string, int x,int y,int nchars, WSCbool erase,
                      WSCuchar fr,WSCuchar fg,WSCuchar fb,
                      WSCuchar br,WSCuchar bg,WSCuchar bb);

extern void WSGFdfbTextWidth(WSDfont* font, WSCushort* string, int nchars, long* w);
extern int WSGFdfbQueryChar(WSCushort* c, WSDdfbFontStruct* font_list,int* order);


extern void WSGFdfbDrawStringEx(IDirectFBSurface* context,
                       WSCuchar fr, WSCuchar fg, WSCuchar fb,
                       WSCuchar br, WSCuchar bg, WSCuchar bb,
                       long x,long y,char *string,
                       WSDfont* font,
                       long cur,WSCbool inter_cur,WSCushort linew,
                       long scur1,long scur2 );
extern WSCrectList* WSGFcreateClipList(WSCrect*,WSCrectList*);
extern void WSGFdestroyClipList(WSCrectList*);
extern void  _set_clip_(IDirectFBSurface* context,long,long,WSCulong,WSCulong);
extern void WSGFdfbDrawPolygon(IDirectFBSurface* context,
                               WSCpoint* point,long num,WSCbool rev);
extern void WSGFdfbDrawArc( IDirectFBSurface* context,int x,int y, int w,int h,
                     long a1,long a2,WSCbool fill,long type);

#endif //WSDFBCOM_H
