//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team 
// shall not be used in advertising or otherwise to promote the sale, use or 
// other dealings in this Software without prior written authorization from  
// WideStudio Development Team.

#if !defined(_axis_h)
#define _axis_h

#include "misc3d.h"

class TAxis {
    int     change;
    Vector  origin;
    Matrix3      m;
    Quaternion   q;

    void SetAngle(long h, long p, long b);
    void GetAngle(long &h, long &p, long &b);
    void EulerAngle(long DH, long DP, long DB);

  public:
    TAxis();
    void reset_change() { change = 0; };
    void move(Vector v);

    void rotate(long h, long p, long b);

    void set_origin(long x, long y, long z);

    Vector get_origin();

    Matrix3 get_matrix();
    void    set_matrix(Matrix3 tm);
    Quaternion get_quat();
    Vector RelativePosition(Vector v);

    void attitude(long h, long p, long b);

    void get_attitude(long &h, long &p, long &b);

    void CalcRotationMatrix();

    int  CheckShortestPath(const Quaternion &q1, const Quaternion &q2);

    void attitudeq(Quaternion qq);

};

#endif
