//
// Copyright (C) 1999-2004 WideStudio Development Team
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// WIDESTUDIO DEVELOPMENT TEAM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of WideStudio Development Team
// shall not be used in advertising or otherwise to promote the sale, use or
// other dealings in this Software without prior written authorization from
// WideStudio Development Team.

#ifndef WSDMACDRAW_H
#define WSDMACDRAW_H

#include <Carbon/Carbon.h>
#include <WScom.h>
#include <WSDdraw.h>
#include <WSClistData.h>
#include <WSDdev.h>

class WSCbase;

class WSDmacDraw :public WSDdraw{

  protected:
    WindowRef   _window;
//    Display* _display;
//    GC       _gc;
    WSDdev*  _dev;
    long _fg_no;
    long _bg_no;
    RGBColor _fg_color;
    RGBColor _bg_color;
    short    _line_width;
    char     _line_type;
    WSCbool  _clipping;
    char     _fill_type;
//    WSCbool  _region_saved;
    Pattern  _pattern;
//    RgnHandle _save_region;
    WSClistData _clip_stack;
    WSClistData _current_clip_stack;
    WSClistData _offset_stack;
    WSClistData _window_stack;
    WSClistData _pre_window_stack;
    WSCrect _clip_area;
    long _pre_offset_x;
    long _pre_offset_y;
    long _exposed;
    long _draw_string(long x,long y,char* str,long fh,int cur,WSCbool,
                      long lw,long scur1,long scur2);
  public:
    WSDmacDraw();
    virtual ~WSDmacDraw();

    virtual long setForeColor(short cid);
    virtual long setBackColor(short cid);
    virtual long setForeColor(WSDcolor*);
    virtual long setBackColor(WSDcolor*);
    virtual long setLineWidth(short);
    virtual long setLineDashType(char no);
    virtual long setHatchPattern(char no);
    virtual long setRegion(short x,short y,WSCushort w,WSCushort h);
    virtual long beginDraw(WSDdev*,long prm1,long prm2,long prm3);
    virtual long endDraw();
    virtual long drawArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2);
    virtual long drawFillArc(short x,short y,WSCushort width,WSCushort height,short a1,short a2,char kind);
    virtual long drawLine(short x1,short y1,short x2,short y2);
    virtual long drawLines(WSCpoint*,long num);
    virtual long drawRect(short x,short y,WSCushort w,WSCushort h);
    virtual long drawFillRect(short x,short y,WSCushort w,WSCushort h);
    virtual long drawRects(WSCrect*,long num);
    virtual long drawGradation(long type,short col1,short col2,short col3,
                         short x,short y,WSCushort w,WSCushort h,WSCuchar);
    virtual long drawFillRects(WSCrect*,long num);
    virtual long drawPoly(WSCpoint*,long num);
    virtual long drawFillPoly(WSCpoint*,long num);
    virtual long drawImage(short x,short y,WSCushort,WSCushort,WSDimage*,char align);
    virtual long drawImage(short x,short y,short sx,short sy,WSCushort,WSCushort,WSDimage*);
    virtual long drawStretchedImage(short x,short y,WSCushort w,WSCushort h,
                                    WSDimage*);

    virtual long drawString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                            char font,char align,long cur,WSCbool inter_cur,
                            long scur1 = 0,long scur2 = 0);

    virtual long drawUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                             char font,char align,long cur,WSCbool inter_cur,
                             long scur1 = 0,long scur2 = 0);

    virtual long drawFillString(long x,long y,WSCulong w,WSCulong h,WSCstring*,
                                char font,char align,short cur,WSCbool inter_cur);

    virtual long drawFillUString(long x,long y,WSCulong w,WSCulong h,WSCushort*,
                                 char font,char align,short cur,WSCbool inter_cur);
    void setExposed(WSCbool fl);

     WSMFclassDef(WSDmacDraw,WSDdraw);
};
#endif
