//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCfunction.h>

static WSCfunctionList* _the_app_function_list = NULL;
WSCfunctionList* WSGIappFunctionList(){
  if (_the_app_function_list == NULL){
    _the_app_function_list = new WSCfunctionList;
  }
  return _the_app_function_list;
}
WSCfunction* WSCfunctionList::addFunction(char* fname,void* proc){
  WSCfunction* fn = getFunction(fname);
  if (fn != NULL){
    fn->setFunction(fname,proc);
    return fn;
  }else{
    WSCfunction* fc = new WSCfunction();
    fc->setFunction(fname,proc);
    addFunction(fc);
    return fc;
  }
}
void WSCfunctionList::addFunction(WSCfunction* function){
  _function_list.add((void*)function);
}
void WSCfunctionList::delFunction(WSCfunction* function){
  _function_list.del((void*)function);
}
WSCfunction* WSCfunctionList::getFunction(char* fname){
  long i;
  long num = _function_list.getNum();
  for(i=0; i< num; i++){
    WSCfunction* fc = (WSCfunction*)_function_list[i];
    char* fn = fc->getFunctionName();
    if (fn[0] == fname[0] && !strcmp(fn,fname)){
      return fc;
    }
  }
  return NULL;
}
void* WSCfunctionList::getFunctionAddr(char* fname){
  long i;
  long num = _function_list.getNum();
  for(i=0; i< num; i++){
    WSCfunction* fc = (WSCfunction*)_function_list[i];
    char* fn = fc->getFunctionName();
    if (fn[0] == fname[0] && !strcmp(fn,fname)){
      return fc->getFunction();
    }
  }
  return NULL;
}

void WSCfunctionList::delAll(){
  long i;
  long num = _function_list.getNum();
  for(i=0; i< num; i++){
    WSCfunction* fc = (WSCfunction*)_function_list[i];
    delete fc;
  }
  _function_list.clear();
}
WSCfunctionRegister::WSCfunctionRegister(char* fname,void* proc){
  _function = WSGIappFunctionList()->addFunction(fname,proc);
}
WSCfunctionRegister::~WSCfunctionRegister(){
  WSGIappFunctionList()->delFunction(_function);
}

