//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDres.h>

WSMFclassInit(WSDres,WSCroot);

WSDres::WSDres(){
  setValue1(-1);
  setValue2(-1);
  setValue3(-1);
  setId(-1);
  _src_name = WSGFstrdup("");
}

WSDres::~WSDres(){
  destroy();
  delete _src_name;
}
long WSDres::initialize(){
   return WS_ERR;
}
long WSDres::destroy(){
   return WS_ERR;
}
long WSDres::setId(short id){
   _id = id;
   return WS_NO_ERR;
}
WSCbool WSDres::isInitialized(){
  return _initialized;
}
void WSDres::setInitialized(WSCbool fl){
  _initialized = fl;
  return;
}

short WSDres::getId(){
  return _id;
}

long WSDres::getValue1(){
  if (_value1 == -1){
    initialize();
  }
  return _value1;
}
long WSDres::getValue2(){
  if (_value2 == -1){
    initialize();
  }
  return _value2;
}
long WSDres::getValue3(){
  if (_value3 == -1){
    initialize();
  }
  return _value3;
}

long WSDres::setSrc(char* src){
   if (strcmp(_src_name,src)){
       if (_value1 != -1){
         destroy();
         setValue1(-1);
         setValue2(-1);
         setValue3(-1);
       }
       delete _src_name;
       _src_name = WSGFstrdup(src);
   }
  return WS_NO_ERR;
}
long WSDres::setValue1(long val){
  _value1 = val;
  return WS_NO_ERR;
}
long WSDres::setValue2(long val){
  _value2 = val;
  return WS_NO_ERR;
}
long WSDres::setValue3(long val){
  _value3 = val;
  return WS_NO_ERR;
}
char* WSDres::getSrc(){
  return _src_name;
}
